/* Copyright Abandoned 1996 TCX DataKonsult AB & Monty Program KB & Detron HB
   This file is public domain and comes with NO WARRANTY of any kind */

/* maintaince of mysql databases */


#include <global.h>
#include <my_sys.h>
#include <m_string.h>
#include <signal.h>
#include "mysql.h"
#include "version.h"
#include "my_sys.h"
#include <getopt.h>
#ifdef THREAD
#include <my_pthread.h>				/* because of signal()	*/
#endif

#define ADMIN_VERSION "4.3"

extern uint mysql_port;
extern string mysql_unix_port;

static int intervall=0;
static bool option_quick=0,interrupted=0;

static void print_version(void);
static void usage(void);
static bool execute_commands(MYSQL *mysql,int argc, char **argv);
static sig_handler endprog(int signal_number);
static int create_db(MYSQL *sock,char *db);
static int drop_db(MYSQL *sock,char *db);
static void nice_time(ulong sec,char *buff);
static void print_header(MYSQL_RES *result);
static void print_top(MYSQL_RES *result);
static void print_row(MYSQL_RES *result,MYSQL_ROW cur);

string command_names[]={"create","drop","shutdown","reload","version",
			"processlist","status",NullS};
TYPELIB commands={array_elements(command_names)-1,"commands",command_names};

static struct option long_options[] =
{
  {"debug",	optional_argument, 0, '#'},
  {"force",	no_argument,	   0, 'f'},
  {"help",	no_argument,	   0, '?'},
  {"host",	required_argument, 0, 'h'},
  {"password",	required_argument, 0, 'p'},
  {"port",	required_argument, 0, 'P'},
  {"socket",	required_argument, 0, 'S'},
  {"sleep",	required_argument, 0, 'i'},
#ifdef SAFE_USER
  {"user",	required_argument, 0, 'u'},
#endif
  {"version",	no_argument,	   0, 'V'},
  {0, 0, 0, 0}
};


int main(int argc,char *argv[])
{
  int	c, error = 0,option_index=0;
  MYSQL mysql;
  char	*host = NULL,*password=0,*user=0;
  MY_INIT(argv[0]);

  while ((c=getopt_long(argc,argv,"h:i:p:u:#::P:S:fq?V",long_options,
			&option_index)) != EOF)
  {
    switch(c) {
    case 'h':
      host = optarg;
      break;
    case 'q':					/* Allow old 'q' option */
    case 'f':
      option_quick++;
      break;
    case 'p':
      password=my_strdup(optarg,MYF(MY_FAE));
      while (*optarg) *optarg++= 'x';		/* Destroy argument */
      break;
#ifdef SAFE_USER
    case 'u':
      user=optarg;
      break;
#endif
    case 'i':
      intervall=atoi(optarg);
      break;
    case 'P':
      mysql_port= (unsigned int) atoi(optarg);
      break;
    case 'S':
      mysql_unix_port= optarg;
      break;
    case '#':
      DBUG_PUSH(optarg ? optarg : "d:t:o");
      break;
    case 'V':
      print_version();
      exit(0);
      break;
    default:
      fprintf(stderr,"Illegal option character '%c'\n",opterr);
      /* Fall throught */
    case '?':
    case 'I':					/* Info */
      error++;
      break;
    }
  }
  argc-=optind;
  argv+=optind;
  if (error || argc == 0)
  {
    usage();
    exit(1);
  }

  VOID(signal(SIGINT,endprog));			/* Here if abort */
  VOID(signal(SIGTERM,endprog));		/* Here if abort */

  if (!mysql_connect(&mysql,host,user,password))
  {
    error=1;
    my_printf_error("connect to server at '%s' failed; error: '%s'",
		    MYF(ME_BELL),(host ? host : ""),mysql_error(&mysql));
  }
  else
  {
    error=0;
    while (!interrupted)
    {
      if (execute_commands(&mysql,argc,argv))
      {
	error=1;
	break;
      }
      if (intervall)
      {
	sleep(intervall);
	puts("");
      }
      else
	break;
    }
    mysql_close(&mysql);
  }
  my_free(password,MYF(MY_ALLOW_ZERO_PTR));
  my_end(0);
  exit(error);
  return 0;
}

static sig_handler endprog(int signal_number __attribute__((unused)))
{
  interrupted=1;
}


static bool execute_commands(MYSQL *mysql,int argc, char **argv)
{
  char *stat;
  for (; argc > 0 ; argv++,argc--)
  {
    switch (find_type(argv[0],&commands,2)) {
    case 1:					/* Create */
      if (argc < 2)
      {
	my_printf_error("Too few arguments to create",MYF(ME_BELL));
	return 1;
      }
      else if (create_db(mysql,argv[1]))
	return 1;
      else
      {
	argc--; argv++;
      }
      break;
    case 2:					/* drop */
      if (argc < 2)
      {
	my_printf_error("Too few arguments to drop",MYF(ME_BELL));
	return 1;
      }
      else if (drop_db(mysql,argv[1]) > 0)
	return 1;
      else
      {
	argc--; argv++;
      }
      break;
    case 3:					/* shutdown */
      if (mysql_shutdown(mysql))
      {
	my_printf_error("shutdown failed; error: '%s'",MYF(ME_BELL),
			mysql_error(mysql));
	return 1;
      }
      break;
    case 4:					/* reload */
      if (mysql_reload(mysql) < 0)
      {
	my_printf_error("reload failed; error: '%s'",MYF(ME_BELL),
			mysql_error(mysql));
	return 1;
      }
      break;
    case 5:					/* version */
      print_version();
      puts("TCX Datakonsult AB, by Monty\n");
      printf("Server version\t\t%s\n", mysql_get_server_info(mysql));
      printf("Protocol version\t%d\n", mysql_get_proto_info(mysql));
      printf("Connection\t\t%s\n",mysql_get_host_info(mysql));
      if (mysql_port)
	printf("TCP port\t\t%d\n", mysql_port);
      if (mysql_unix_port)
	printf("UNIX socket\t\t%s\n", mysql_unix_port);
      stat=mysql_stat(mysql);
      {
	char *pos,buff[40];
	ulong sec;
	pos=strchr(stat,' ');
	*pos++=0;
	printf("%s\t\t\t",stat);			/* print label */
	if ((stat=str2int(pos,10,0,LONG_MAX,(long*) &sec)))
	{
	  nice_time(sec,buff);
	  puts(buff);				/* print nice time */
	  while (*stat == ' ') stat++;		/* to next info */
	}
      }
      putc('\n',stdout);
      if (stat)
	puts(stat);
      break;
    case 6:					/* process_list */
    {
      MYSQL_RES *result;
      MYSQL_ROW row;

      if (!(result=mysql_list_processes(mysql)))
      {
	my_printf_error("process list failed; error: '%s'",MYF(ME_BELL),
			mysql_error(mysql));
	return 1;
      }
      print_header(result);
      while ((row=mysql_fetch_row(result)))
	print_row(result,row);
      print_top(result);
      mysql_free_result(result);
      break;
    }
    case 7:
      stat=mysql_stat(mysql);
      if (stat)
	puts(stat);
      break;
    default:
      my_printf_error("Unknown command: '%s'",MYF(ME_BELL),argv[0]);
      return 1;
    }
  }
  return 0;
}

static void print_version(void)
{
  printf("%s  Ver %s Distrib %s, for %s on %s\n",my_progname,ADMIN_VERSION,
	 SERVER_VERSION,SYSTEM_TYPE,MACHINE_TYPE);
}

static void usage(void)
{
  print_version();
  puts("TCX Datakonsult AB, by Monty");
  puts("This software comes with NO WARRANTY: see the file PUBLIC for details.\n");
  puts("Administer program for the mysqld demon");
  printf("Usage: %s [OPTIONS] command command....\n", my_progname);
  printf("\n\
  -#, --debug=...       output debug log. Often this is 'd:t:o,filename`\n\
  -f, --force		don't ask for confirmation on drop table\n\
  -?, --help		display this help and exit\n\
  -h, --host=#		connect to host\n\
  -p, --password=#	password to use when connecting\n\
  -P  --port=...	Port number to use for connection\n\
  -i, --sleep=sec	execute commands again and again with a sleep between\n\
  -S  --socket=...	Socket file to use for connection\n");
#ifdef SAFE_USER
  printf("\
  -u, --user=#		user for login if not current user\n");
#endif
  printf("\
  -V, --version		output version information and exit\n");

  puts("\nWhere command is a one or more of: (Commands may be shortened)
  create databasename	Create a new database\n\
  drop databasename	Delete a database and all its tables\n\
  processlist		Show list of threads in server\n\
  reload		Tell server to flush all fields and read grant tables\n\
  shutdown		Take server down\n\
  status		Gives a short status message from the server\n\
  version		Get version info from server");
}


static int create_db(MYSQL *mysql,char *db)
{
  if (mysql_create_db(mysql,db))
  {
    my_printf_error("create of '%s' failed; error: '%s'",MYF(ME_BELL),
		    db,mysql_error(mysql));
    return 1;
  }
  printf("Database \"%s\" created.\n",db);
  return 0;
}


static int drop_db(MYSQL *mysql,char *db)
{
  char	buf[10];
  if (!option_quick)
  {
    puts("Dropping the database is potentially a very bad thing to do.");
    puts("Any data stored in the database will be destroyed.\n");
    printf("Do you really want to drop the '%s' database [y/N]\n",db);
    VOID(fgets(buf,sizeof(buf)-1,stdin));
    if ((*buf != 'y') && (*buf != 'Y'))
    {
      puts("\nOK, aborting database drop!");
      return -1;
    }
  }
  if (mysql_drop_db(mysql,db))
  {
    my_printf_error("drop of '%s' failed; error: '%s'",MYF(ME_BELL),
		    db,mysql_error(mysql));
    return 1;
  }
  printf("Database \"%s\" dropped\n",db);
  return 0;
}


static void nice_time(ulong sec,char *buff)
{
  ulong tmp;

  if (sec >= 3600L*24)
  {
    tmp=sec/(3600L*24);
    sec-=3600L*24*tmp;
    buff=int2str(tmp,buff,10);
    buff=strmov(buff,tmp > 1 ? " days " : " day ");
  }
  if (sec >= 3600L)
  {
    tmp=sec/3600L;
    sec-=3600L*tmp;
    buff=int2str(tmp,buff,10);
    buff=strmov(buff,tmp > 1 ? " hours " : " hour ");
  }
  if (sec >= 60)
  {
    tmp=sec/60;
    sec-=60*tmp;
    buff=int2str(tmp,buff,10);
    buff=strmov(buff," min ");
  }
  strmov(int2str(sec,buff,10)," sec");
}

static void print_header(MYSQL_RES *result)
{
  MYSQL_FIELD *field;

  print_top(result);
  mysql_field_seek(result,0);
  putchar('|');
  while ((field = mysql_fetch_field(result)))
  {
    printf(" %-*s|",field->max_length+1,field->name);
  }
  putchar('\n');
  print_top(result);
}


static void print_top(MYSQL_RES *result)
{
  uint i,length;
  MYSQL_FIELD *field;

  putchar('+');
  mysql_field_seek(result,0);
  while((field = mysql_fetch_field(result)))
  {
    if ((length=strlen(field->name)) > field->max_length)
      field->max_length=length;
    else
      length=field->max_length;
    for (i=length+2 ; i--> 0 ; )
      putchar('-');
    putchar('+');
  }
  putchar('\n');
}


static void print_row(MYSQL_RES *result,MYSQL_ROW cur)
{
  uint i,length;
  MYSQL_FIELD *field;
  putchar('|');
  mysql_field_seek(result,0);
  for (i=0 ; i < mysql_num_fields(result); i++)
  {
    field = mysql_fetch_field(result);
    length=field->max_length;
    printf(" %-*s|",length+1,cur[i] ? (char*) cur[i] : "");
  }
  putchar('\n');
}
