#!/usr/bin/perl -Tw
#############################################################
#  MyAdmin.cgi                                              #
#                                                           #
#      Web administration CGI for a MySQL database          #
#                                                           #
#         MySQL is a awsome database and the newest         #
#         version can always be found at www.tcx.se         #
#                                                           #
#############################################################


#### Load needed modules.
use CGI;
use CGI::Carp qw(fatalsToBrowser);
use DBI;
use strict;

#### Declair some variables we know we will use thoughout the cgi
my ($sth, $table, $dbaction, $actiondb, $tableaction, $actiontable, $colsaction, @actioncols, $column, $columnaction, $actioncolumn);

#### Set server variables
my $defaultdb = "test";
my $body = "<body>";
my $header= "<CENTER><h2>MyAdmin v0.2 - MySQL Web Administrator</h2></CENTER>\n";

#### Create the query struct to get form data
my $query = new CGI;
my $thiscgi = $query->url();

#### Get the username and password if exists from the form
#### or else use the defaults
my ($host, $username, $password, $database);
$host = $query->param("host") || "localhost";
$database = $query->param("database") || $defaultdb;
$username = $query->param("username") || "";
$password = $query->param("password") || "";
$table = $query->param("table") || "";

my @DATATYPE = ("tinyint","smallint","meduimint","int","bigint","float","double","decimal","varchar","char","tinyblob","blob","mediumblob","longblob","timestamp","date","time","datetime","text","enum");


#### Print HTML header
print "Content-type: text/html\n\n";


#### Connect to the database $defaultdb becasue there doesnt 
#### seem to be a way to connect to just the server with 
#### out specifying a database. If $defaultdb does not exists
#### An invalid login error will occour
my $dbh = DBI->connect("DBI:mysql:$database:$host", $username, $password) || error('connect');


#############################################################
#  drop_table                                               #
#                                                           #
#     Drop the selected table from the database server      #
#                                                           #
#############################################################
if ($query->param("drop_table") ne "") {

    $sth = $dbh->do("drop table ".$query->param("table")) || error("action");
    $tableaction = "DROPED";
    $actiontable = $query->param("table");
    $table = "";
    $query->param("list_tables","NOT NULL");


#############################################################
#  drop_column                                              #
#                                                           #
#     Drop the selected column from the database server     #
#                                                           #
#############################################################
} elsif ($query->param("drop_column") ne "") {

    foreach my $selectedcol ($query->param("selectedcols")) {
      $sth = $dbh->do("alter table $table drop column $selectedcol") || error("action");
    }
    $colsaction = "DROPED";
    @actioncols = $query->param("selectedcols");
    $query->param("list_columns","NOT NULL");


#############################################################
#  drop_db                                                  #
#                                                           #
#     Drop the selected db from the database server         #
#                                                           #
#############################################################
} elsif ($query->param("drop_db") ne "") {

    $dbh->do("drop database $database") || error("action");
    $dbaction = "DROPED";
    $actiondb = $database;
    $database = $defaultdb;
    $query->param("list_dbs","NOT NULL");


#############################################################
#  create_column                                            #
#                                                           #
#     Add the column to the server                          #
#                                                           #
#############################################################
} elsif ($query->param("create_column") ne "") {

    $colsaction = "ADDED";
    @actioncols = $query->param("new_column");
#    $column = $query->param("new_column");
    $query->param("list_columns","NOT NULL");

    my ($buildcolumnsql, $extracolumnsql);
    $buildcolumnsql = "alter table $table add column ".$query->param("new_column")." ".$query->param("column_type")."\(".$query->param("column_size")."\) ".$query->param("nulltype");

    if ($query->param("column_auto_increment") eq "on") {
      $extracolumnsql = " PRIMARY KEY AUTO_INCREMENT";
    } elsif ($query->param("nulltype") eq "not null") {
      $extracolumnsql = " default \"".$query->param("column_default")."\"";
    }

    $buildcolumnsql = $buildcolumnsql.$extracolumnsql;
    
    if ($query->param("after_col") ne "noaftercol") {
       if ($query->param("after_col") eq "FIRST") {
          $buildcolumnsql = $buildcolumnsql." FIRST";
       } else {
          $buildcolumnsql = $buildcolumnsql." after ".$query->param("after_col");
       }
     }

#    print "$buildcolumnsql";

    $dbh->do($buildcolumnsql) || error("action", $dbh->errstr);

    if ($query->param("column_unique") eq "on") {
       $dbh->do("alter table $table add unique ".$query->param("column_key")."\(".$query->param("new_column")."\)") || error("action", $dbh->errstr);
    }



#############################################################
#  create_table                                             #
#                                                           #
#     Add the table to the server                           #
#                                                           #
#############################################################
} elsif ($query->param("create_table") ne "") {

    $tableaction = "ADDED";
    $actiontable = $query->param("new_table");
    $table = $query->param("new_table");
    $query->param("list_columns","NOT NULL");

    my ($buildtablesql, $extratablesql);
    $buildtablesql = "create table $table \(".$query->param("new_column")." ".$query->param("column_type")."\(".$query->param("column_size")."\) ".$query->param("nulltype");

    if ($query->param("column_auto_increment") eq "on") {
      $extratablesql = " PRIMARY KEY AUTO_INCREMENT";
    } elsif ($query->param("nulltype") eq "not null") {
      $extratablesql = " default \"".$query->param("column_default")."\"";
    }

    $buildtablesql = $buildtablesql.$extratablesql;

    $buildtablesql = $buildtablesql."\)";
 #   print "$buildtablesql";

    $dbh->do($buildtablesql) || error("action", $dbh->errstr);

    if ($query->param("column_unique") eq "on") {
       $dbh->do("alter table $table add unique ".$query->param("column_key")."\(".$query->param("new_column")."\)") || error("action", $dbh->errstr);
    }



#############################################################
#  create_db                                                #
#                                                           #
#     Add the database to the server                        #
#                                                           #
#############################################################
} elsif ($query->param("create_db") ne "") {

    $dbh->do("create database ".$query->param("new_database")) || error("action", $dbh->errstr);
    $dbaction = "ADDED";
    $actiondb = $query->param("new_database");
    $database = $query->param("new_database");
    $query->param("list_dbs","NOT NULL");

}




#############################################################
#  list_columns                                             #
#                                                           #
#     Print the columns from the selected database          #
#                                                           #
#############################################################
if ($query->param("list_columns") ne "") {

    print "<html><head><title>Choose Column Action</title>\n";
    print qq!
     <script laguage="Javascript">

     function check() {
       message=("Drop Selected Columns?")
       if(confirm(message)) {
          return true
        } else {
          return false
        }
     }      
    
     </script>    
    !;
    print "</head>$body\n";
    print "$header";

    if ($colsaction eq "DROPED") {
      print "<center><b>".font("red:2:arial","Droped Column\(s\)<i>@actioncols\!</i>")."</b></center><br>\n";
    } elsif ($tableaction eq "ADDED") {
      print "<center><b>".font("red:2:arial","Table <i>$actiontable</i> Added!")."</b></center><br>\n";
    } elsif ($colsaction eq "ADDED") {
      print "<center><b>".font("red:2:arial","Column <i>@actioncols</i> Added!")."</b></center><br>\n";
    }
      
  
    print "<CENTER>".font("black:3:arial","Select Column from <i>$table</i> in Database <i>$database</i>")."\n";
    print "<FORM ACTION=\"$thiscgi\" METHOD=\"POST\">\n";
    $sth = $dbh->prepare("show columns from $table");
    $sth->execute;
    print "<table border=1>\n";
    print "<tr><th>Column #</th><th>Column Name</th><th>Data Type</th><th>Data Size</th><th>Null</th><th>Key</th><th>Default</th><th>Extra</th><th>Drop</th></tr>\n";
    my $colcount = 0;
    while (my @columns = $sth->fetchrow_array) {
        $columns[2] = "NO" if $columns[2] eq "";
        $columns[3] = "--" if $columns[3] eq "";
        $columns[4] = "NULL" if $columns[4] eq "";
        $columns[5] = "--" if $columns[5] eq "";
        $_ = $columns[1];
        my ($type, $len) = /(\w+)(.*)/;
        $len = "----" if $len eq "";
        print "<tr align=center><td>$colcount</td><td>$columns[0]</td><td>";
#        print "<select name=\"$columns[0]_$type\">\n";
#        print "<option selected value=\"$type\">$type\n";
#        foreach my $TYPE (@DATATYPE) {
#          next if $TYPE eq $type;
#          print "<option value=\"$TYPE\">$TYPE\n";
          print "$type";
#        }
#        print "</select>";
        print "</td><td>".substr($len, 1, (length($len) - 2))."</td><td>$columns[2]</td><td>$columns[3]</td><td>$columns[4]</td><td>$columns[5]</td><td><input type=checkbox name=selectedcols value=\"$columns[0]\"></tr>\n";
        $colcount++;
    }
    print "</table>\n";
    print "<input type=\"hidden\" name=\"table\" value=\"$table\">\n";
    print "<input type=\"hidden\" name=\"username\" value=\"$username\">\n";
    print "<input type=\"hidden\" name=\"password\" value=\"$password\">\n";
    print "<input type=\"hidden\" name=\"database\" value=\"$database\">\n";
    print "<input type=\"hidden\" name=\"host\" value=\"$host\">\n";
    print "<br><input type=\"submit\" name=\"new_column\" value=\"New Column\">\n";
    print "\&nbsp\;<input type=\"submit\" name=\"drop_column\" value=\"Drop Selected Columns\" onclick=\"return check()\">\n";
    print "<br><br><input type=\"submit\" name=\"list_dbs\" value=\"List Databases\">\n";
    print "\&nbsp\;<input type=\"submit\" name=\"list_tables\" value=\"List Tables\">\n";
    print "</FORM></body></html>\n";


#############################################################
#  new_column                                               #
#                                                           #
#     Print the form to add a new column                    #
#                                                           #
#############################################################
} elsif ($query->param("new_column") ne "") {
  
   
    print "<html><head><title>Add Culumn</title></head>$body\n";
    print "$header";
    print "<br><form action=\"$thiscgi\" METHOD=\"POST\">\n";
    print "<input type=\"hidden\" name=\"table\" value=\"$table\">\n";
    print "<input type=\"hidden\" name=\"username\" value=\"$username\">\n";
    print "<input type=\"hidden\" name=\"password\" value=\"$password\">\n";
    print "<input type=\"hidden\" name=\"database\" value=\"$database\">\n";
    print "<input type=\"hidden\" name=\"host\" value=\"$host\">\n";
    print "<center>".font("black:4:arial","New Column In Table <i>$table</i>")."<br><br>";
    print "<center>".font("red:2:arial","Select \"N/A\" for After Column for MySQL < 3.22.x")."<br><br>";
    print "<table border=1>\n";
    print "<tr><th>Column Name</th><th>Data Type</th><th>Data Size</th><th>Null Type</th><th>Defaut</th><th>Auto<br>Increment</th><th>Unique</th><th>After Column</th></tr>\n";
    print "<tr align=center><td><input type=\"text\" name=\"new_column\" size=\"10\"></td><td><select name=\"column_type\">";
    foreach my $coltype (@DATATYPE) {
      print "<option value=\"$coltype\">$coltype\n";
    }
     
    print "</select></td><td><input type=\"text\" name=\"column_size\" size=\"6\"></td><td>NULL<input type=radio name=\"nulltype\" value=\"null\" CHECKED> NOT NULL <input type=\"radio\" name=\"nulltype\" value=\"not null\"></td><td><input type=\"text\" name=\"column_default\" size=\"5\"></td><td><input type=checkbox name=\"column_auto_increment\"></td><td>Unique <input type=\"checkbox\" name=\"column_unique\"><br>Key: <input type=\"text\" name=\"column_key\" size=6></td>";
    $sth = $dbh->prepare("show columns from $table");
    $sth->execute;
    print "<td><select name=\"after_col\">\n";
    print "<option selected value=\"noaftercol\">N/A\n";
    print "<option value=\"FIRST\">FIRST\n";
    while (my @cols = $sth->fetchrow_array) {
     print "<option value=\"$cols[0]\">$cols[0]\n";
    } 
    print "</select></td></tr>\n";
    print "</table><table border=0>\n";
    print "</tr><td></td><td><input type=\"submit\" name=\"create_column\" value=\"Create Column\"></td></tr>\n";
    print "</table>\n";

    print "<br><br><input type=\"submit\" name=\"list_dbs\" value=\"List Databases\">\n";
    print "\&nbsp\;<input type=\"submit\" name=\"list_tables\" value=\"List Tables\">\n";
    print "\&nbsp\;<input type=\"submit\" name=\"list_columns\" value=\"List Columns\"><br><br>\n";
    print "</center></form></body></html>\n";


#############################################################
#  new_table                                                #
#                                                           #
#     Print the form to add a new table                     #
#                                                           #
#############################################################
} elsif ($query->param("new_table") ne "") {
  
   
    print "<html><head><title>Add Table</title></head>$body\n";
    print "$header";
    print "<br><form action=\"$thiscgi\" METHOD=\"POST\">\n";
    print "<input type=\"hidden\" name=\"username\" value=\"$username\">\n";
    print "<input type=\"hidden\" name=\"password\" value=\"$password\">\n";
    print "<input type=\"hidden\" name=\"database\" value=\"$database\">\n";
    print "<input type=\"hidden\" name=\"host\" value=\"$host\">\n";
    print "<center><table border=0>\n";
    print "<tr><td>".font("black:3:arial","New Table")."</td><td><input type=\"text\" name=\"new_table\"></td></tr>\n";
    print "</table>\n";
    print "Inital Column";
    print "<table border=1>\n";
    print "<tr><th>Column Name</th><th>Data Type</th><th>Data Size</th><th>Null Type</th><th>Defaut</th><th>Auto<br>Increment</th><th>Unique</th></tr>\n";
    print "<tr align=center><td><input type=\"text\" name=\"new_column\" size=\"10\"></td><td><select name=\"column_type\">";
    foreach my $coltype (@DATATYPE) {
      print "<option value=\"$coltype\">$coltype\n";
    }
     
    print "</select></td><td><input type=\"text\" name=\"column_size\" size=\"6\"></td><td>NULL<input type=radio name=\"nulltype\" value=\"null\" CHECKED> NOT NULL <input type=\"radio\" name=\"nulltype\" value=\"not_null\"></td><td><input type=\"text\" name=\"column_default\" size=\"5\"></td><td><input type=checkbox name=\"column_auto_increment\"></td></td><td>Unique <input type=\"checkbox\" name=\"column_unique\"><br>Key: <input type=\"text\" name=\"column_key\" size=6></td></tr>\n";
    print "</table><table border=0>\n";
    print "</tr><td></td><td><input type=\"submit\" name=\"create_table\" value=\"Create Table\"></td></tr>\n";
    print "</table>\n";
    print "<br><input type=\"submit\" name=\"list_dbs\" value=\"List Databases\">\n";
    print "\&nbsp\;<input type=\"submit\" name=\"list_tables\" value=\"List Tables\"><br><br>\n";
    print "</center></form></body></html>\n";


#############################################################
#  new_db                                                   #
#                                                           #
#     Print the form to add a new database                  #
#                                                           #
#############################################################
} elsif ($query->param("new_db") ne "") {
  
   
    print "<html><head><title>Add Database</title></head>$body\n";
    print "$header";
    print "<br><form action=\"$thiscgi\" METHOD=\"POST\">\n";
    print "<input type=\"hidden\" name=\"username\" value=\"$username\">\n";
    print "<input type=\"hidden\" name=\"password\" value=\"$password\">\n";
    print "<input type=\"hidden\" name=\"host\" value=\"$host\">\n";
    print "<center><table border=0>\n";
    print "<tr><td>".font("black:3:arial","New Database")."</td><td><input type=\"text\" name=\"new_database\"></td></tr>\n";
    print "</tr><td></td><td><input type=\"submit\" name=\"create_db\" value=\"Create Database\"></td></tr>\n";
    print "</table>\n";
    print "<br><input type=\"submit\" name=\"list_dbs\" value=\"List Databases\"><br><br>\n";
    print "</center></form></body></html>\n";



#############################################################
#  list_tables                                              #
#                                                           #
#     Print the tables from the selected database           #
#                                                           #
#############################################################
} elsif ($query->param("list_tables") ne "") {

    print "<html><head><title>Choose Table Action</title>\n";
    print qq!
     <script laguage="Javascript">

     function check() {
       db = document.forms[0].elements[0].options[document.forms[0].elements[0].selectedIndex].value 
       message=("Drop Table "+db+"?")
       if(confirm(message)) {
          return true
        } else {
          return false
        }
     }      
    
     </script>    
    !;
    print "</head>$body\n";
    print "$header";

    if ($tableaction eq "DROPED") {
      print "<center><b>".font("red:2:arial","Table <i>$actiontable</i> Droped!")."</b></center><br>\n";
    }
  
    print "<CENTER>".font("black:3:arial","Select Table from <i>$database</i>")."\n";
    print "<FORM ACTION=\"$thiscgi\" METHOD=\"POST\">\n";
    print "<select name=\"table\">\n";
    $sth = $dbh->prepare("show tables");
    $sth->execute;
    print "<option selected value=\"$table\">$table\n" if $table ne "";
    while (my @tables = $sth->fetchrow_array) {
       next if $table eq $tables[0];
       print "<option value=\"$tables[0]\">$tables[0]\n";
    }
    print "</select><br>\n";
    print "<input type=\"hidden\" name=\"username\" value=\"$username\">\n";
    print "<input type=\"hidden\" name=\"password\" value=\"$password\">\n";
    print "<input type=\"hidden\" name=\"database\" value=\"$database\">\n";
    print "<input type=\"hidden\" name=\"host\" value=\"$host\">\n";
    print "<input type=\"submit\" name=\"list_columns\" value=\"Show Columns\">\n";
    print "\&nbsp\;<input type=\"submit\" name=\"new_table\" value=\"New Table\">\n";
    print "\&nbsp\;<input type=\"submit\" name=\"drop_table\" value=\"Drop Selected Table\" onclick=\"return check()\">\n";
    print "<br><br><input type=\"submit\" name=\"list_dbs\" value=\"List Databases\">\n";
    print "</FORM></body></html>\n";




#############################################################
#  list_dbs                                                 #
#                                                           #
#     Print the databases and the options to list tables,   #
#     add new database or drop selected database            #
#                                                           #
#############################################################
} elsif ($query->param("list_dbs") ne '') {

    print "<html><head><title>Choose Database Action</title>\n";
    print qq!
     <script laguage="Javascript">

     function check() {
       db = document.forms[0].elements[0].options[document.forms[0].elements[0].selectedIndex].value 
       message=("Drop Database "+db+"?")
       if(confirm(message)) {
          return true
        } else {
          return false
        }
     }      
    
     </script>    
    !;
    print "</head>$body\n";
    print "$header";

    if ($dbaction eq "DROPED") {
      print "<center><b>".font("red:2:arial","Database <i>$actiondb</i> Droped!")."</b></center><br>\n";
    } elsif ($dbaction eq "ADDED") {
      print "<center><b>".font("red:2:arial","Database <i>$actiondb</i> Added!")."</b></center><br>\n";
    }
  
    print "<CENTER>".font('black:3:arial','Select Database')."\n";
    print "<FORM ACTION=\"$thiscgi\" METHOD=\"POST\">\n";
    print "<select name=\"database\">\n";
    $sth = $dbh->prepare("show databases");
    $sth->execute;
    print "<option selected value=\"$database\">$database\n" if $database ne $defaultdb;
    while (my @databases = $sth->fetchrow_array) {
       next if $database eq $databases[0] && $databases[0] ne $defaultdb;
       print "<option value=\"$databases[0]\">$databases[0]\n";
    }
    print "</select><br>\n";
    print "<input type=\"hidden\" name=\"username\" value=\"$username\">\n";
    print "<input type=\"hidden\" name=\"password\" value=\"$password\">\n";
    print "<input type=\"hidden\" name=\"host\" value=\"$host\">\n";
    print "<input type=\"submit\" name=\"list_tables\" value=\"Show Tables\">\n";
    print "\&nbsp\;<input type=\"submit\" name=\"new_db\" value=\"New Database\">\n";
    print "\&nbsp\;<input type=\"submit\" name=\"drop_db\" value=\"Drop Selected Database\" onclick=\"return check()\">\n";
    print "</FORM>\n";
    print "</BODY></HTML>\n"; 



}


#############################################################
#  default page                                             #
#                                                           #
#     Print the login screen to connect to the server       #
#                                                           #
#############################################################
else {

    print "<html><head><title>Login</title></head>$body\n";
    print "$header";
    print "<CENTER>".font('black:3:arial','Enter Login Information')."\n";
    print "<FORM ACTION=\"$thiscgi\" METHOD=\"POST\">\n";
    print "<TABLE BORDER=0>\n";
    print "<tr><td>".font("black:2:arial","Username: ")."</td><td><input type=\"text\" name=\"username\"></td></tr>\n";
    print "<tr><td>".font("black:2:arial","Password: ")."</td><td><input type=\"password\" name=\"password\"></td></tr>\n";
    print "<tr><td>".font("black:2:arial","Server Host: ")."</td><td><input type=\"text\" name=\"host\"></td></tr>\n";
    print "<tr><td></td><td><input type=\"submit\" name=\"list_dbs\" value=\"Login\"></td></tr>\n";
    print "</TABLE></CENTER></FORM>\n";
    print "</body></html>\n";

}


print "<center><a href=\"$thiscgi\">Back To MyAdmin Login Page</a></center>\n";


#### Disconnect at the end of the script
$dbh->disconnect;


#############################################################
# subs                                                      #
#                                                           #
#    Variuos subs for handleing repetitive tasks            #
#                                                           #
#############################################################

#### font sub for printing stings in different fonts
sub font {
  #### arg0 is in format color:size:face
  my $options = $_[0];
  my ($color, $size, $face) = split(/:/, $options);
  my $string = $_[1];
  return "<font color=\"$color\" size=\"$size\" face=\"$face\">$string</font>";
}


#### error sub for various errors
sub error {
  my($error, $errstr);
  $error = shift;
  $errstr = shift;
  print "<html><head><title>Error!</title></head>$body\n";

  if ($error eq 'connect') {
    print "<br><center><h1>Error connecting to database</h1></center>\n";
    print "<p>This could be caused by an invalid username or password or you do not have permission to connect to the database specified.</p>\n";
    print "Native MySQL error: <i>$errstr</i>";
  } elsif ($error eq 'action') {
    print "<br><center><h1>Error Preforming Action</h1></center>\n";
    print "<p>This could be caused by insificient priviages on selected database.</p>\n";
    print "Native MySQL error: <i>$errstr</i>";
  }
  exit;

}
     

