#ifndef SERVERTREE_H
#define SERVERTREE_H

#include <qpixmap.h>
#include <qpopupmenu.h>
#include <ktreelist.h>
#include <kapp.h>
#include <kiconloader.h>

class ServerTree : public KTreeList
  {
  Q_OBJECT
  public:
    enum ItemType { SERVER, BASE, TABLE, UNDEF };
    ServerTree(QWidget *);
    KTreeListItem *createServerItem(const char *);
    KTreeListItem *createConnectedServerItem(const char *);
    KTreeListItem *createBaseItem(const char *);
    KTreeListItem *createTableItem(const char *);
    ItemType currentItemType(void);
    QString currentConnectionName(void);
    QString currentBaseName(void);
    QString currentTableName(void);
    void saveTree(void);
    void restoreTree(void);
  signals:
    void serverConnect();
    void serverDisconnect();
    void serverRemove();
    void serverShutdown();
    void serverReload();
    void serverInfo();
    void serverCreateBase();
    void baseCreateTable();
    void baseDelete();
    void baseSelect();
    void tableDrop();
    void tableShowFields();
    void tableSelect();
  protected:
    void mousePressEvent(QMouseEvent *);
  private slots:
		void slotServerConnect();
		void slotServerDisconnect();
    void slotServerRemove();
    void slotServerShutdown();
    void slotServerReload();
    void slotServerInfo();
    void slotServerCreateBase();
    void slotBaseCreateTable();
    void slotBaseDelete();
    void slotBaseSelect();
    void slotTableDrop();
    void slotTableShowFields();
    void slotTableSelect();
  private:
  	class NodeInfo;
  	bool _saveTree(KTreeListItem *, void *);
  	bool _restoreTree(KTreeListItem *, void *);
  	QString pathToString(KPath *);
  	QString getPath(KTreeListItem *);
  	NodeInfo *nodeInfoByPath(QString);
  private:
  	class NodeInfo
		  {
		  public:	
				NodeInfo(QString, bool);
				~NodeInfo(void);
				QString path;
				bool expanded;
			};	
    QPixmap connectedServerPix, serverPix, basePix, tablePix;
    QPopupMenu *serverPopup, *connectedServerPopup, *basePopup, *tablePopup;
    QList<NodeInfo> nodes;
    int selectedItem;
  };

#endif // SERVERTREE_H
