#include "ServerTree.h"

ServerTree::ServerTree(QWidget *parent)
  : KTreeList(parent)
  {
  // Les icones
  KIconLoader *iconLoader = KApplication::getKApplication()->getIconLoader();
  serverPix = iconLoader->loadIcon(QString("server.xpm"));
  connectedServerPix = iconLoader->loadIcon(QString("cserver.xpm"));
  basePix = iconLoader->loadIcon(QString("base.xpm"));
  tablePix = iconLoader->loadIcon(QString("table.xpm"));
  // Les popups
  QPopupMenu *admin = new QPopupMenu(this);
  admin->insertItem("Shutdown", this, SLOT(slotServerShutdown()));
  admin->insertItem("Reload", this, SLOT(slotServerReload()));
  admin->insertItem("Info", this, SLOT(slotServerInfo()));
  serverPopup = new QPopupMenu(this);
  serverPopup->insertItem("Connect", this, SLOT(slotServerConnect()));
  serverPopup->insertItem("Remove from tree", this, SLOT(slotServerRemove()));
  connectedServerPopup = new QPopupMenu(this);
  connectedServerPopup->insertItem("Disconnect", this, SLOT(slotServerDisconnect()));
  connectedServerPopup->insertItem("Remove from tree", this, SLOT(slotServerRemove()));
  connectedServerPopup->insertItem("Create base", this, SLOT(slotServerCreateBase()));
  connectedServerPopup->insertItem("Admin", admin);
  basePopup = new QPopupMenu(this);
  basePopup->insertItem("Create table", this, SLOT(slotBaseCreateTable()));
  basePopup->insertItem("Drop base", this, SLOT(slotBaseDelete()));
  basePopup->insertItem("Select...", this, SLOT(slotBaseSelect()));
  tablePopup = new QPopupMenu(this);
  tablePopup->insertItem("Drop table", this, SLOT(slotTableDrop()));
  tablePopup->insertItem("Show fields", this, SLOT(slotTableShowFields()));
  tablePopup->insertItem("Select in this table...", this, SLOT(slotTableSelect()));
  }

KTreeListItem *ServerTree::createConnectedServerItem(const char *name)
  {
  return new KTreeListItem(name, &connectedServerPix);
  }


KTreeListItem *ServerTree::createServerItem(const char *name)
  {
  return new KTreeListItem(name, &serverPix);
  }

KTreeListItem *ServerTree::createBaseItem(const char *name)
  {
  return new KTreeListItem(name, &basePix);
  }

KTreeListItem *ServerTree::createTableItem(const char *name)
  {
  return new KTreeListItem(name, &tablePix);
  }

ServerTree::ItemType ServerTree::currentItemType(void)
  {
  KPath *path = itemPath(currentItem());
  if(path == NULL)
    return UNDEF;
  int count = path->count();
  delete path;
  switch(count)
    {
    case 1: return SERVER;
    case 2: return BASE;
    case 3: return TABLE;
    default: return UNDEF;
    }
  return UNDEF;
  }


QString ServerTree::currentConnectionName(void)
  {
  int i = currentItem();
  if(i == -1)
    return 0;
  KPath *path = itemPath(i);
  QString *s = NULL;
  while(!path->isEmpty())
    {
    if(s)
      delete s;
    s = path->pop();
    }
  if(s==NULL)
    return 0;
  QString res = *s;
  delete path;
  return res;
  }

QString ServerTree::currentBaseName(void)
  {
  int i = currentItem();
  if(i==-1)
    return 0;
  KPath *path = itemPath(i);
  if(!path)
    return 0;
  if(path->count() < 2)
    return 0;
  while(path->count() != 2)
    delete(path->pop());
  QString *s = path->pop();
  QString res = *s;
  delete s;
  delete path;
  return res;
  }

QString ServerTree::currentTableName(void)
  {
  int i = currentItem();
  if(i==-1)
    return 0;
  KPath *path = itemPath(i);
  if(!path)
    return 0;
  if(path->count() < 3)
    return 0;
  while(path->count() != 3)
    delete(path->pop());
  QString *s = path->pop();
  QString res = *s;
  delete s;
  delete path;
  return res;
  }

void ServerTree::mousePressEvent(QMouseEvent *e)
  {
  KTreeList::mousePressEvent(e);
  if(e->button()==RightButton)
    {
    QPopupMenu *popup;
    switch(currentItemType())
      {
      case SERVER:
      	{
      	KTreeListItem *item = itemAt(currentItem());
      	if(item->getPixmap()->serialNumber() == connectedServerPix.serialNumber())
      		popup = connectedServerPopup;
      	else
	      	popup = serverPopup;
	      break;
	      }
      case BASE:
      	popup = basePopup;
      	break;
      case TABLE:
				popup = tablePopup;
				break;
      default:
				return;
      }
    popup->popup(mapToGlobal(e->pos()));
    }
  }

void ServerTree::slotServerConnect(void)
	{
	emit serverConnect();
	}

void ServerTree::slotServerCreateBase(void)
	{
	emit serverCreateBase();
	}

void ServerTree::slotServerDisconnect(void)
	{
	emit serverDisconnect();
	}

void ServerTree::slotServerRemove(void)
	{
	emit serverRemove();
	}

void ServerTree::slotServerShutdown(void)
	{
	emit serverShutdown();
	}

void ServerTree::slotServerReload(void)
	{
	emit serverReload();
	}

void ServerTree::slotServerInfo(void)
	{
	emit serverInfo();
	}

void ServerTree::slotBaseCreateTable(void)
	{
	emit baseCreateTable();
	}

void ServerTree::slotBaseDelete(void)
	{
	emit baseDelete();
	}

void ServerTree::slotTableDrop(void)
	{
	emit tableDrop();
	}

void ServerTree::slotTableSelect(void)
	{
	emit tableSelect();
	}

void ServerTree::slotTableShowFields(void)
	{
	emit tableShowFields();
	}

void ServerTree::slotBaseSelect(void)
	{
	emit baseSelect();
	}

void ServerTree::saveTree(void)
	{
	selectedItem = currentItem();
	nodes.setAutoDelete(true);
	nodes.clear();
	forEveryItem((bool (KTreeList::*)(KTreeListItem *, void *))&_saveTree, NULL);
	}

void ServerTree::restoreTree(void)
	{
	forEveryItem((bool (KTreeList::*)(KTreeListItem *, void *))&_restoreTree, NULL);
	if(itemAt(selectedItem) != NULL)
		setCurrentItem(selectedItem);
	}

bool ServerTree::_saveTree(KTreeListItem *item, void *)
	{
	QString path = getPath(item);
	NodeInfo *node = new NodeInfo(path, item->isExpanded());
	nodes.append(node);
	return false;
	}

bool ServerTree::_restoreTree(KTreeListItem *item, void *)
	{
	QString path = getPath(item);
	NodeInfo *node = nodeInfoByPath(path);
	if(node != NULL)
		if(node->expanded)
			expandItem(itemIndex(item));
	return false;
	}

ServerTree::NodeInfo *ServerTree::nodeInfoByPath(QString path)
	{
	for(int i=0; i<nodes.count(); i++)
		{
		NodeInfo *node = nodes.at(i);
		if(node->path == path)
			return node;
		}
	return NULL;
	}

QString ServerTree::pathToString(KPath *path)
	{
	if(!path)
		return 0;
	QString res;
	while(!path->isEmpty())
		{
		QString *s = path->pop();
		res += (*s);
		res += "|";
		}
	delete path;
	}

QString ServerTree::getPath(KTreeListItem *item)
	{
	QString res;
	if(item->hasParent())
		res = getPath(item->getParent());
	res += item->getText();
	res += "|";
	return res;
	}


// Nodeinfo
ServerTree::NodeInfo::NodeInfo(QString path, bool expanded)
	: path(path), expanded(expanded)
	{
	}

ServerTree::NodeInfo::~NodeInfo(void)
	{
	}














	