#ifndef SQLSERVER_H
#define SQLSERVER_H

#include <qstring.h>
#include "QueryResult.h"

class SQLServer
  {
  public:
    SQLServer(void);
    virtual QueryResult connect(QString, QString, QString) = 0;
    virtual void close(void) = 0;
    virtual QueryResult selectBase(QString) = 0;
    virtual QueryResult getBases(void) = 0;
    virtual QueryResult getTables(QString, QString = 0) = 0;
    virtual QueryResult query(QString) = 0;
    virtual QueryResult createBase(QString) = 0;
    virtual QueryResult dropBase(QString) = 0;
    virtual QueryResult shutdown(void) = 0;
    virtual QueryResult reload(void) = 0;
    virtual QString serverInfo(void) = 0;
    bool isConnected(void);
  protected:
    bool connected;
  };

#endif
