#ifndef QSCANNER_H
#define QSCANNER_H

#include <qstring.h>
#include <fstream>

/*!
  \class QParser
  \brief Genere des jetons a partir d'un fichier texte.

  Cette classe fait un premier parsing d'un fichier texte, et permet
  d'en extraire des jetons,en fonction de deux ensembles de caractres:
  les sparateurs (comme espace, tab...) et les caractres spciaux qui
  constituent  eux seuls des jetons (comme un point-virgule).
 */
class QScanner
  {
  public:
    QScanner(const char *);
    ~QScanner(void);
    QString getToken(void);
    QString getUntil(char);
    bool ungetToken(QString);
    bool isValid(void);
    bool eof(void);
    int currentLine(void);
    void setCommentStyle(int);
    int getCommentStyle(void);
    enum { C_STYLE, CXX_STYLE, PASCAL_STYLE, SHELL_STYLE, LISP_STYLE, NO_STYLE};
    void setSeparators(char *);
    void setSpecialChars(char *);
  protected:
    bool isSeparator(char);
    bool isSpecialChar(char);
  private:
    char get(void);
    void unget(char);
    void close(void);
    bool member(char, const char *);
    bool readComment(void);
    bool readCComment(void);
    bool readCXXComment(void);
    bool readPascalComment(void);
    bool readShellComment(void);
    bool readLispComment(void);
    QString getUngotToken(void);
    bool isCommentBegin(char);
    bool readUntil(char);
  private:
    //! Le flux d'entre
    ifstream in;
    //! L'tat de validit du flux
    bool valid;
    //! Chaine contenant les caractres sparateurs. Voir isSeparator().
    char *separators;
    //! Chaine contenant les caractres spciaux. Voir isSpeacialChar().
    char *specialChars;
    //! Le token qui a t remis avec ungetToken(). Sera remplac par une pile.
    QString ungotToken;
    //! \c true si on a un token remis avec ungetToken(). \c false sinon.
    bool haveUngotToken;
    //! La ligne courante.
    int line;
    //! Le type des commentaires
    int commentStyle;
  };

#endif
