#include "MySqlServer.h"

QueryResult MySqlServer::connect(QString addr, QString user, QString passwd)
	{
	QueryResult res;
	if(mysql.connect(addr, user, passwd))
	  {
	  res.setType(QueryResult::Ok);
	  connected = true;
	  }
	else
	  {
	  res.setType(QueryResult::Error);
	  res.setMessage(mysql.error());
	  }
	return res;
	}

void MySqlServer::close(void)
  {
  mysql.close();
  connected = false;
  }

QueryResult MySqlServer::selectBase(QString baseName)
  {
  QueryResult res;
  if(!mysql.selectDB(baseName))
    {
    res.setType(QueryResult::Ok);
    }
  else
    {
    res.setType(QueryResult::Error);
    res.setMessage(mysql.error());
    }
  return res;
  }

QueryResult MySqlServer::query(QString query)
  {
  QueryResult queryRes;
  if(mysql.query(query))
    {
    queryRes.setType(QueryResult::Error);
    queryRes.setMessage(mysql.error());
    return queryRes;
    }
  MySqlResult res = mysql.storeResult();
  if(!res)
    {
    if(!QString(mysql.error()).isEmpty())
      {
      queryRes.setType(QueryResult::Error);
      queryRes.setMessage(mysql.error());
      return queryRes;
      }
    else
      {
      queryRes.setType(QueryResult::Ok);
      int n = mysql.affectedRows();
      QString s;
      if(n == -1)
	s = "Error processing query.";
      else
	s.sprintf("Query OK, %d %s affected.", n, n>1 ? "rows" : "row");
      queryRes.setMessage(s);	
      return queryRes;
      }
    }
  // Les champs
  int nbcols = res.numFields();
  queryRes.setNumColumns(nbcols);
  QString fields = "";
  MySqlRow row;
  for(int i=0; i<nbcols; i++)
    {
    MySqlField *field = res.fetchField();
    fields += field->name;
    if(i != nbcols-1)
      fields += '\t';
    }		
  queryRes.setFields(fields);
  // Puis on prend chaque ligne
  int numrows = res.numRows();
  while((row = res.fetchRow()))
    {
    QString cols;
    for(int i=0; i<nbcols; i++)
      {
      cols += row[i];
      if(i != nbcols-1)
	cols += "\t";
      }
    queryRes.addRow(cols);
    }
  // On retourne
  queryRes.setType(QueryResult::Set);
  QString s;
  s.sprintf("Query OK, %d %s in set.", numrows, numrows>1 ? "rows" : "row");
  queryRes.setMessage(s);
  return queryRes;
  }

QueryResult MySqlServer::getBases(void)
  {
  QueryResult queryRes;
  MySqlResult res = mysql.listDbs(0);
  if(!res)
    {
    queryRes.setType(QueryResult::Error);
    queryRes.setMessage(mysql.error());
    return queryRes;
    }
  MySqlRow row;
  while((row = res.fetchRow()))
    queryRes.addRow(row[0]);
  if(!res.eof())
    {
    queryRes.setType(QueryResult::Error);
    queryRes.setMessage(mysql.error());
    return queryRes;
    }
  return queryRes;
  }

QueryResult MySqlServer::getTables(QString baseName, QString wild)
  {
  QueryResult queryRes;
  selectBase(baseName);
  MySqlResult res = mysql.listTables(wild);
  if(!res)
    {
    queryRes.setType(QueryResult::Error);
    queryRes.setMessage(mysql.error());
    return queryRes;
    }
  MySqlRow row;
  while((row = res.fetchRow()))
    queryRes.addRow(row[0]);
  if(!res.eof())
    {
    queryRes.setType(QueryResult::Error);
    queryRes.setMessage(mysql.error());
    return queryRes;
    }
  return queryRes;
  }

QueryResult MySqlServer::shutdown(void)
	{
	QueryResult queryRes;
	if(mysql.shutdown() != 0)
	  {
	  queryRes.setType(QueryResult::Error);
	  queryRes.setMessage(mysql.error());
	  return queryRes;
	  }
	queryRes.setType(QueryResult::Ok);
	return queryRes;
	}

QueryResult MySqlServer::reload(void)
	{
	QueryResult queryRes;
	if(mysql.reload() != 0)
	  {
	  queryRes.setType(QueryResult::Error);
	  queryRes.setMessage(mysql.error());
	  return queryRes;
	  }
	queryRes.setType(QueryResult::Ok);
	return queryRes;
	}

QString MySqlServer::serverInfo(void)
	{
	QString res;
	QString protNum;
	protNum.setNum(mysql.protoInfo());
	res += "Type: MySql\n";
	res += QString("Server version: ") + mysql.serverInfo() + "\n";
	res += QString("Host: ") + mysql.hostInfo() + "\n";
  res += QString("Protocol version: ") + protNum + "\n";
 	res += QString("Statistics: ") + mysql.stat() + "\n";
 	res += QString("Processes list: ");
 	MySqlResult processes = mysql.listProcesses();
 	if(!processes)
 		{
 		res += "Access denied\n";
 		return res;
 		}
 	MySqlRow row;
  while((row = processes.fetchRow()))
    res += QString(row[0]) + "\t";
  return res;
	}

QueryResult MySqlServer::createBase(QString name)
	{
	QueryResult queryRes;
	if(mysql.createDB(name) != 0)
	  {
	  queryRes.setType(QueryResult::Error);
	  queryRes.setMessage(mysql.error());
	  return queryRes;
	  }
	queryRes.setType(QueryResult::Ok);
	return queryRes;
	}

QueryResult MySqlServer::dropBase(QString name)
	{
	QueryResult queryRes;
	if(mysql.dropDB(name) != 0)
	  {
	  queryRes.setType(QueryResult::Error);
	  queryRes.setMessage(mysql.error());
	  return queryRes;
	  }
	queryRes.setType(QueryResult::Ok);
	return queryRes;
	}

	
