#include <qapp.h>
#include <qmenubar.h>
#include <qpopmenu.h>
#include <qmsgbox.h>
#include <qcombo.h>
#include <qstrlist.h>
#include <qlist.h>
#include <qstring.h>
//#include <qprinter.h>

#include <kapp.h>
#include <kcombo.h>
#include <kmsgbox.h>
#include <kpopmenu.h>
#include <kmenubar.h>
#include <kmsgbox.h>
#include <kfiledialog.h>
#include <kstatusbar.h>
#include <ktmainwindow.h>
#include <kiconloader.h>
#include <kmsgbox.h>

#include "MySqlServer.h"
#include "MainFrame.h"
#include "Common.h"
#include "DialogPref.h"
#include "DialogSelectBase.h"
#include "DialogFormEditor.h"
#include "FormDialog.h"
#include "DialogCreateTable.h"
#include "DialogInput.h"
#include "DialogAddServer.h"
#include "DialogSelect.h"
#include "Connection.h"

/**
   This represents a item of the menu containing forms.
**/
struct FormMenuItem
  {
    int id;
    int delid;
    QString filename;
  };

class MainWindow : public KTMainWindow
  {
    Q_OBJECT
  public:
    MainWindow(const char * =0);
    ~MainWindow(void);
  protected:
    virtual void closeEvent(QCloseEvent *);
  private slots:
    void menuNewWindow();
    void menuConnect();
    void menuClose();
    void menuSelectBase();
    void menuPref();
    void menuSavePref();
    void menuPrint();
    void menuQuit();
    void menuRemoveRow();
    void menuClear();
    void menuFitAll();
    void menuShowTables();
    void menuCreateTable();
    void menuAlterTable();
    void menuDropTable();
    void menuFormEditor();
    void menuRunForm();
    void menuAddForm();
    void menuTableSelect();
    void menuShowFields();
    void menuDeleteBase();
    void menuCreateBase();
    void menuRemoveServer();
    void menuAddServer();
    void menuShutdownServer();
    void menuReloadServer();
    void menuServerInfo();
    void menuSelect();
    void menuFormsActivated(int);
    void menuDelformsActivated(int);
    void comboActivated(const char *);
    void go();
  private:
    void commonInit(void);
    int readPref(void);
    int savePref(void);
    int newQuery(const char *);
    void updateWithPrefs(void);
    int addConnection(Connection *);
    int removeConnection(Connection *);
    int updateTree(void);
    int updateTree(Connection *);
    SQLServer *currentServer(void);
    Connection *currentConnection(void);
    Connection *connectionByName(QString);
    QString currentBase();
    QString currentTable();
  private:
    KStatusBar *status;
    KCombo *edit;
    TabView *tab;
    ServerTree *treeView;
    QPopupMenu *fichier;
    QPopupMenu *forms;
    QPopupMenu *delforms;
    QPopupMenu *edition;
    QPopupMenu *base;
    KMenuBar *menu;
    //QString currentBase;
    int tableId;
    int editionId;
    QPushButton *btn_go;
    int connect_id, close_id, select_id, pref_id;
    QList<FormMenuItem> formMenuItems;
    static DialogFormEditor *formEditor;
    static Pref pref;
    static bool initialized;
    static QList<MainWindow> windows;
    static QList<Connection> connections;    
  };



