#include "MainFrame.h"

MainFrame::MainFrame(QWidget *parent)
  : QWidget(parent)
  {
  // Le layout vertical
  QBoxLayout *vbox = new QBoxLayout(this, QBoxLayout::TopToBottom);
  // L'arbre et la vue
  KPanner *panner = new KPanner(this, "paner", KPanner::O_VERTICAL | KPanner::U_PERCENT, 30);
  QBoxLayout *leftLayout = new QBoxLayout(panner, QBoxLayout::LeftToRight);
  QBoxLayout *rightLayout = new QBoxLayout(panner, QBoxLayout::LeftToRight);
  treeView = new ServerTree(panner->child0());
  leftLayout->addWidget(treeView);
  tab = new TabView(panner->child1());
  CHECK_PTR(tab);
  tab->setSeparator('\t');
  tab->setAutoUpdate(true);
  rightLayout->addWidget(tab);
  vbox->addWidget(panner, 100);
  vbox->addSpacing(5);
  // Le layout horizontal
  QBoxLayout *hbox = new QHBoxLayout(); //QBoxLayout::LeftToRight);
  vbox->addLayout(hbox, 0);
  vbox->addSpacing(5);
  // Query edit combo
  edit = new KCombo(true, this);
  edit->setInsertionPolicy(QComboBox::AtTop);
  edit->setFixedHeight(30);
  hbox->addWidget(edit);
  hbox->addSpacing(10);
  // Go button
  btn_go = new QPushButton("Submit", this);
  btn_go->setFixedSize(50, 30);
  hbox->addWidget(btn_go);
  };

MainFrame::~MainFrame(void)
	{
	}
