#include "FormDialog.h"

FormDialog::FormDialog(QWidget* parent, QString filename, bool preview)
  : QDialog(parent, 0, true), preview(preview)
  {
  createFromFile(filename);
  }

FormDialog::~FormDialog(void)
  {
  if(fields)
    delete[] fields;
  if(names)
    delete[] names;
  }

void FormDialog::ok(void)
  {
  done(1);
  }

void FormDialog::cancel(void)
  {
  done(0);
  }

int FormDialog::createFromFile(QString filename)
  {
  int res = form.readFile(filename);
  if(res != 0)
    return res;
  // On cre le tableau de widgets
  fields = new (QWidget *)[form.items.count()];
  names = new QString[form.items.count()];
  // Set catpion
  QString caption = "KMySql Form - " + form.getName();
  if(preview)
    caption += " (Preview)";
  setCaption(caption);
  // Get query
  query = form.getQuery();
  // On cre le layout destin  recevoir les widgets
  // Il fait 2 de large, et a autant de lignes que la forme contient
  // de widgets
  int count = form.items.count();
  QGridLayout *layout = new QGridLayout(this, count*2+1, 3);
  layout->addColSpacing(1, 10);
  layout->setColStretch(0, 30);
  layout->setColStretch(2, 30);
  // On cre chaque couple de widget
  for(int line = 0; line<count; line++)
    {
    // Le label
    FormItem *item = form.items.at(line);
    layout->addRowSpacing(line*2+1, 10);
    layout->setRowStretch(line*2, 30);
    QLabel *label = new QLabel(item->getName()+": ", this);
    layout->addWidget(label, line*2, 0);
    QWidget *field;
    // Le widget
    if(item->getType() == FormItem::TypeText) // Type text
      {
      field = new QLineEdit(this);
      layout->addWidget(field, line*2, 2);
      }
    else if(item->getType() == FormItem::TypeCombo) // Type combo
      {
      field = new QComboBox(this);
      FormItemCombo *combo = (FormItemCombo *)item;
      for(int i=0; i<combo->choices.count(); i++)
	((QComboBox *)field)->insertItem(*combo->choices.at(i));
      layout->addWidget(field, line*2, 2);
      }
    field->setFixedHeight(30);
    fields[line] = field;
    names[line] = item->getName();
    }
  // Boutons du bas
  QPushButton *btnCancel = new QPushButton("Cancel", this);
  btnCancel->setFixedHeight(30);
  layout->addWidget(btnCancel, count*2, 0);
  QPushButton *btnSubmit = new QPushButton("Submit", this);
  btnSubmit->setEnabled(!preview);
  btnSubmit->setFixedHeight(30);
  btnSubmit->setDefault(true);
  layout->addWidget(btnSubmit, count*2, 2);
  layout->setRowStretch(count*2, 30);
  connect(btnSubmit, SIGNAL(clicked()), SLOT(ok()));
  connect(btnCancel, SIGNAL(clicked()), SLOT(cancel()));
  // Activation du layout
  layout->activate();
  // Taille
  setFixedSize(200, (count+1)*40);
  }

QString FormDialog::makeQuery(void)
  {
  if(query.isEmpty())
    return "";
  QString res = "";
  unsigned int len = query.length();
  for(int i=0; i<len; i++)
    {
    if(query[i] != '%')
      {
      res += query[i];
      }
    else
      {
      QString fieldName = "";
      i++;
      while(i<len && query[i] != '%')
	fieldName += query[i++];
      res += getValue(fieldName);
      }
    }
  return res;
  }

QString FormDialog::getValue(QString fieldName)
  {
  for(int i=0; i<form.items.count(); i++)
    if(form.items.at(i)->getName() == fieldName)
      {
      FormItem *item = form.items.at(i);
      if(item->getType() == FormItem::TypeText)
	return ((QLineEdit *)(fields[i]))->text();
      else if(item->getType() == FormItem::TypeCombo)
	return ((QComboBox *)(fields[i]))->currentText();
      }
  return "";
  }
