#ifndef FORM_H
#define FORM_H

#include <fstream.h>

#include "QScanner.h"
#include "qlist.h"
#include "qstring.h"
#include "FormItem.h"
#include "FormItemText.h"
#include "FormItemCombo.h"

/**
  @short Represents a form.
  @author Frederik Bilhaut
	A form is a set of widgets 
**/   
class Form
  {
  public:
  	/**
  	 Constructor.
  	**/
    Form(void);
    /**
     Destructor.
    **/
    ~Form(void);
    /**
     Clear the form removing all its fields. 
    **/
    void clear(void);
    /**
     Adds an item (field) to the form.
    **/
    void addItem(FormItem *);
    /**
     Removes an item (field), given by its name.
    **/
    void removeItem(QString);
    /**
     Tests if an item given by its name exists.
     If specified, the form item is ignored.
    **/
    bool itemExists(QString, FormItem * = 0);
    /**
     Sets the name of the form.
    **/
    void setName(QString);
    /**
     Sets the query.
    **/
    void setQuery(QString);
    /**
     Returns the name of the form.
    **/
    QString getName(void);
    /**
     Returns the query.
    **/
    QString getQuery(void);
    /**
     Writes the form to a file given by its name.
    **/
    bool writeFile(const char *);
    /**
     Reads a form from a file given by its name.
    **/
    int readFile(const char *);
    /**
     Return the index of a item given by its name. If specified, 
     the form item is ignored.
    **/
    int findItemFromName(QString, FormItem * = 0);
    /**
     The items list.
    **/
    QList<FormItem> items;
  private:
    /**
     Name of the form.
    **/
    QString name;
    /**
     The query.
    **/
    QString query;
  };

#endif
