#include "Form.h"

Form::Form(void)
  {
  items.setAutoDelete(true);
  }

Form::~Form(void)
  {
  clear();
  }

void Form::clear(void)
  {
  items.clear();
  name = "";
  query = "";
  }

void Form::addItem(FormItem *item)
  {
  items.append(item);
  }

void Form::removeItem(QString itemName)
  {
  int index = findItemFromName(itemName);
  if(index != -1)
    items.remove(index);
  else
    warning("Removing item that not exists");
  }

int Form::findItemFromName(QString itemName, FormItem *except)
  {
  int count = items.count();
  for(int i=0; i<count; i++)
    {
    if(items.at(i)->getName() == itemName && items.at(i) != except)
      return i;
    }
  return -1;
  }

bool Form::itemExists(QString itemName, FormItem *except)
  {
  return findItemFromName(itemName, except) != -1;
  }

void Form::setName(QString str)
  {
  name = str;
  }

QString Form::getName(void)
  {
  return name;
  }

void Form::setQuery(QString str)
  {
  query = str;
  }

QString Form::getQuery(void)
  {
  return query;
  }

bool Form::writeFile(const char *filename)
  {
  ofstream out(filename, ios::out);
  if(!out)
    return false;
  out << "form " << name << endl
      << "  {" << endl;
  out << "  query=" << query << ";" << endl;
  for(FormItem *item = items.first(); item; item=items.next())
    item->writeFile(out);
  out << "  }" << endl;
  out.close();
  return true;
  }

int Form::readFile(const char *filename)
  {
  clear();
  QScanner scanner(filename);
  if(!scanner.isValid())
    return -1;
  scanner.setSpecialChars(";{}()=");
  scanner.setCommentStyle(QScanner::CXX_STYLE);
  QString token;
  // Entete de la forme
  token = scanner.getToken();
  if(token != "form")
    return scanner.currentLine();
  // Le nom de la forme
  token = scanner.getToken();
  name = token;
  // Ouverture du bloc
  token = scanner.getToken();
  if(token != "{")
    return scanner.currentLine();
  // Le bloc lui-meme
  bool fin = false;
  while(!fin)
    {
    token = scanner.getToken();
    if(token == "}") // fin du bloc
      {
      fin = true;
      }
    else if(token == "query")
      {
      // Signe =
      token = scanner.getToken();
      if(token != "=")
	return scanner.currentLine();
      // La valeur
      token = scanner.getUntil(';');
      query = token;
      // Le point-virgule
      token = scanner.getToken();
      if(token != ";")
	return scanner.currentLine();
      }
    else if(token == "text") // Definition d'un item text
      {
      FormItemText *item = new FormItemText;
      // Le nom de l'item
      token = scanner.getToken(); 
      item->setName(token);
      // Accolade ouvrante
      token = scanner.getToken();
      if(token != "{")
	return scanner.currentLine();
      // Le bloc lui-meme
      bool fin2 = false;
      while(!fin2)
	{
	token = scanner.getToken();
	// Fin du bloc
	if(token == "}") 
	  fin2 = true;
	// Sinon erreur
	else
	  return scanner.currentLine(); // Erreur
	}
      // Ajout de l'item
      addItem(item);
      }
    else if(token == "combo") // Definition d'un item combo
      {
      FormItemCombo *item = new FormItemCombo;
      // Le nom de l'item
      token = scanner.getToken(); 
      item->setName(token);
      // Accolade ouvrante
      token = scanner.getToken();
      if(token != "{")
	return scanner.currentLine();
      // Le bloc lui-meme
      bool fin2 = false;
      while(!fin2)
	{
	token = scanner.getToken();
	// Fin du bloc
	if(token == "}") 
	  fin2 = true;
	// Dfinition d'une option
	else if(token == "option") 
	  {
	  // Le signe =
	  token = scanner.getToken(); 
	  if(token != "=")
	    return scanner.currentLine();
	  // L'option elle-meme
	  token = scanner.getUntil(';');
	  item->addChoice(token);
	  // Le point-virgule
	  token = scanner.getToken();
	  if(token != ";")
	    return scanner.currentLine();
	  }
	else
	  return scanner.currentLine(); // Erreur
	}
      // Ajout de l'item
      addItem(item);
      }
    else
      return scanner.currentLine();
    }
  return 0;  
  }
