#ifndef DialogFormEditor_included
#define DialogFormEditor_included

#include <qmessagebox.h>
#include <kfiledialog.h>
#include <kapp.h>
#include "DialogFormEditorData.h"
#include "DialogNewField.h"
#include "Form.h"
#include "FormDialog.h"

class DialogFormEditor : public DialogFormEditorData
  {
  Q_OBJECT
  public:
    DialogFormEditor(QWidget* parent = NULL, const char* name = NULL);
    virtual ~DialogFormEditor();
  public slots:
    void newField();
    void editField();
    void deleteField();
    void menuNew();
    void menuOpen();
    void menuSave();
    void menuSaveAs();
    void menuClose();
    void changed(const char *);
    void menuPreview();
  private:
    void fillFromForm(void);
    bool askSave(void);
  private:
    Form form;
    QString filename;
    bool saved;
  };

#endif 
