#include "DialogFormEditor.h"

#define Inherited DialogFormEditorData

DialogFormEditor::DialogFormEditor(QWidget* parent, const char* name)
  : Inherited(parent, name), saved(false), filename("")
  {
  setCaption("Form editor");
  setIcon(KApplication::getKApplication()->getIcon());
  // La barre de menu
  //   Menu fichier
  QPopupMenu *file = new QPopupMenu();
  CHECK_PTR(file);
  file->insertItem("&New", this, SLOT(menuNew()));
  file->insertItem("&Open...", this, SLOT(menuOpen()));
  file->insertItem("&Save", this, SLOT(menuSave()));
  file->insertItem("S&ave as...", this, SLOT(menuSaveAs()));
  file->insertSeparator();
  file->insertItem("&Close", this, SLOT(menuClose()));
  //    Menu form
  QPopupMenu *form = new QPopupMenu();
  CHECK_PTR(form);
  form->insertItem("&Preview", this, SLOT(menuPreview()));
  //    Ajout des menus
  menubar->insertItem("&File", file);
  menubar->insertItem("F&orm", form);
  }


DialogFormEditor::~DialogFormEditor()
  {
  }

void DialogFormEditor::newField(void)
  {
  DialogNewField dlg(this);
  if(dlg.exec())
    {
    FormItem *res = dlg.getItem();
    if(res == NULL)
      return; // Should manage error, but it shouldn't happen
    if(!form.itemExists(res->getName()))
      {
      fieldList->insertItem(res->getName());
      form.addItem(res);
      saved = false;
      }
    else
      {
      QMessageBox::warning(this, "New item", "Field name is already used");
      delete res;
      }
    }
  }

void DialogFormEditor::editField(void)
  {
  int current = fieldList->currentItem();
  if(current != -1)
  	{
  	int currentItem = form.findItemFromName(fieldList->text(current));
  	if(currentItem == -1)
  		{
  		warning("Form::findItemFromName failed.");
  		return;
  		}
  	FormItem *item = form.items.at(currentItem);
  	DialogNewField dlg;
  	dlg.fill(item);
  	if(dlg.exec())
    	{
    	FormItem *res = dlg.getItem();
    	if(res == NULL)
      	return; // Should manage error, but it shouldn't happen
    	if(!form.itemExists(res->getName(), item))
     		{
      	fieldList->changeItem(res->getName(), current);
      	form.items.remove(currentItem);
      	form.items.insert(currentItem, res);
      	saved = false;
      	}
    	else
      	{
      	QMessageBox::warning(this, "Edit item", "Field name is already used");
      	delete res;
      	}
    	}
  	}
  }

void DialogFormEditor::deleteField(void)
  {
  int current = fieldList->currentItem();
  if(current != -1)
    {
    warning("Removing item: %s", fieldList->text(current));
    form.removeItem(fieldList->text(current));
    fieldList->removeItem(current);
    saved = false;
    }
  }

bool DialogFormEditor::askSave(void)
  {
  if(!saved)
    {
    int res;
    res = QMessageBox::information(this, "New",
				   "The document contains unsaved work\n"
				   "Do you want to save it?",
				   "&Save", "&Don't Save", "&Cancel",
				   0, 2);
    if(res == 2)
      return false;
    if(res == 0)
      menuSave();
    }
  return true;
  }

void DialogFormEditor::menuNew(void)
  {
  if(askSave())
    {
    form.clear();
    fillFromForm();
    fieldList->repaint();
    saved = true;
    filename = "";
    }
  }

void DialogFormEditor::menuOpen(void)
  {
  KFileDialog dlg(0, 0, this, 0, true, false);
  if(dlg.exec())
    {
    QString afilename = dlg.selectedFile();
    int res = form.readFile(afilename);
    if(res == -1)
      QMessageBox::critical(this, "Open", "Error opening file");
    else if(res > 0)
      {
      QString line;
      line.setNum(res);
      QString msg = "Parse error line " + line;
      QMessageBox::critical(this, "Open", msg);
      }
    else
      {
      fillFromForm();
      saved = true;
      filename = afilename;
      }
    }
  }

void DialogFormEditor::menuSave(void)
  {
  if(filename == "")
    menuSaveAs();
  else
    {
    form.setName(editName->text());
    form.setQuery(editQuery->text());
    if(!form.writeFile(filename))
      QMessageBox::critical(this, "Saving", "Error writing file");
    saved = true;
    } 
  }

void DialogFormEditor::menuSaveAs(void)
  {
  KFileDialog dlg(0, 0, this, 0, true, false);
  if(dlg.exec())
    {
    QString afilename = dlg.selectedFile();
    form.setName(editName->text());
    form.setQuery(editQuery->text());
    if(!form.writeFile(afilename))
      QMessageBox::critical(this, "Saving", "Error writing file");
    else
      {
      saved = true;
      filename = afilename;
      }
    }
  }

void DialogFormEditor::menuClose(void)
  {
  if(askSave())
    close();
  }

void DialogFormEditor::menuPreview(void)
  {
  if(!saved)
    {
    QMessageBox::warning(this, "Form preview", "Please save the form before");
    }
  else
    {
    FormDialog dlg(this, filename, true);
    dlg.exec();
    }
  }

void DialogFormEditor::changed(const char *)
  {
  //warning("Changed");
  saved = false;
  }

void DialogFormEditor::fillFromForm(void)
  {
  editName->setText(form.getName());
  editQuery->setText(form.getQuery());
  fieldList->clear();
  for(FormItem *item = form.items.first(); item; item = form.items.next())
    fieldList->insertItem(item->getName());
  }
