#include "DialogCreateTable.h"

#define Inherited DialogCreateTableData

DialogCreateTable::DialogCreateTable(QWidget* parent, const char* name)
  : Inherited( parent, name )
  {
  setCaption( "Create table" );
  fieldList.setAutoDelete(true);
  }


DialogCreateTable::~DialogCreateTable()
  {
  }


void DialogCreateTable::addField(void)
  {
  DialogTableField dlg(this);
  if(dlg.exec())
    {
    TableField *item = dlg.result();
    if(getField(item->name) != 0)
      QMessageBox::critical(this, item->name, "Field name already exists.");
    else
    	{
    	fields->insertItem(item->name);
    	fieldList.append(item);
    	}
    }
  }

void DialogCreateTable::editField(void)
	{
	}

void DialogCreateTable::removeField(void)
	{
	if(fields->currentItem() != -1)
	  {
		TableField *item = getField(fields->text(fields->currentItem()));
		if(item)
			{
			fieldList.removeRef(item);
			fields->removeItem(fields->currentItem());
			}
		}
	}

TableField *DialogCreateTable::getField(QString fieldName)
	{
	for(int i=0; i<fieldList.count(); i++)
		if(fieldList.at(i)->name == fieldName)
			return fieldList.at(i);
	return 0;
	}


QString DialogCreateTable::getQuery(void)
	{
	QString res = "CREATE TABLE ";
	res += tableName->text();
	res += " (";
	for(int i=0; i<fieldList.count(); i++)
		{
		TableField *field = fieldList.at(i);
		res += field->name + " ";
		res += field->type;
		if(field->specLength)
			{
			QString length; length.setNum(field->length);
			QString decimals; decimals.setNum(field->decimals);
			res += "(" + length;
			if(field->specDecimals)
			  res += ", "+decimals+")";
			else
			  res += ")"; 
			}
		res += " ";
		if(field->isUnsigned)
			res += "UNSIGNED ";
		if(field->binary)
			res += "BINARY ";
		if(field->zeroFill)
			res += "ZEROFILL ";
		if(field->canNull)
			res += "NULL ";
		else
		  res += "NOT NULL ";
		if(field->specDefaultValue)
			res += "DEFAULT "+field->defaultValue+" ";
		if(field->autoIncrement)
			res += "AUTO_INCREMENT ";
		if(i != fieldList.count()-1)
			res += ", ";
		}	
	if(isTherePrimaryKey())
		{
		res += ", PRIMARY KEY(";
		bool first = true;
		for(int i=0; i<fieldList.count(); i++)
			if(fieldList.at(i)->isKey)
				{
				if(!first)
					res += ", ";
				else
					first = false;
				res += fieldList.at(i)->name;
				}
		res += ")";
		}
	res += " )";
	return res;
	}	

bool DialogCreateTable::isTherePrimaryKey(void)
	{
	for(int i=0; i<fieldList.count(); i++)
		if(fieldList.at(i)->isKey)
			return true;
return false;
	}



	
	