#include "DialogComboOptions.h"

#define Inherited DialogComboOptionsData

DialogComboOptions::DialogComboOptions (QWidget* parent, const char* name)
  : Inherited( parent, name )
  {
  setCaption( "Combo box options" );
  }


DialogComboOptions::~DialogComboOptions()
  {
  }

void DialogComboOptions::ok(void)
  {
  done(1);
  }

void DialogComboOptions::cancel(void)
  {
  done(0);
  }

void DialogComboOptions::remove(void)
  {
  int current = list->currentItem();
  if(current != -1)
    list->removeItem(current);
  }

void DialogComboOptions::add(void)
  {
  QString text = edit->text();
  if(!text.isEmpty())
    {
    list->insertItem(text);
    edit->setText("");
    }
  }

QList<QString> DialogComboOptions::getChoices(void)
  {
  QList<QString> res;
  res.setAutoDelete(false);
  for(int i=0; i<list->count(); i++)
    res.append(new QString(list->text(i)));
  return res;
  }

void DialogComboOptions::setChoices(QList<QString> &choices)
  {
  for(int i=0; i<choices.count(); i++)
    list->insertItem(*choices.at(i));
  }
