#ifndef CONNECTION_H
#define CONNECTION_H

#include "MySqlServer.h"

class Connection
  {
  public:
    enum ServerType { MYSQL, POSTGRES, ODBC, UNDEF };
    Connection(ServerType, const char *, const char *, const char *);
    ~Connection(void);
    QueryResult connect(void);
    SQLServer *sql(void) const;
    QString getName(void) const;
  private:
    const char *login, *passwd, *host;
    ServerType st;
    SQLServer *_sql;
  };


#endif // CONNECTION_H
