#include "Connection.h"

Connection::Connection(ServerType st, const char *host, const char *login, const char *passwd)
  : st(st), host(strdup(host)), login(strdup(login)), passwd(strdup(passwd))
  {
  if(st==MYSQL)
    _sql = new MySqlServer();
  else if(st==POSTGRES)
    _sql = NULL;
  else if(st==ODBC)
    _sql = NULL;
  }

Connection::~Connection(void)
  {
  if(_sql)
    delete _sql;
  }

SQLServer *Connection::sql(void) const
  {
  return _sql;
  }

QString Connection::getName(void) const
  {
  QString res = login;
  res += "@";
  res += host;
  switch(st)
  	{
  	case MYSQL:
  		res += " (MySql)"; break;
  	case POSTGRES:
  		res += " (Postgres)"; break;
  	case ODBC:
  		res += " (ODBC)"; break;
  	default:
  		res += " (Unknown server type)"; break;
  	}
  return res;
  }

QueryResult Connection::connect(void)
  {
  return _sql->connect(host, login, passwd);
  }
