.TH DBTOOL 1 "xxDATExx" "dbtool Version xxVERSIONxx"
.SH NAME
dbtool \- Interactive user frontend for MySQL
.SH SYNOPSIS
.B db
[
.B database
[
.B table
] ]
.br
.B db
[
.B mysqlhost
[
.B mysqluser
[
.B mysqlpassword
] ] ]
.br
.B db \-h
|
.B \-\-help
|
.B \-V
|
.B \-\-version
.SH DESCRIPTION
.B dbtool
is an interactive shell script providing access to the MySQL database.
Dialog boxes are generated on the ASCII screen. Users are assisted in
creating new tables, entering data and accessing stored data. Massmail
functions are implemented using TeX.
.LP
.B dbtool
requires a running
.B mysqld
daemon on 
.B mysqlhost
to connect to. Any existing local 
.B ".my.cnf "
file will take effect (in fact
.B db
is using standard MySQL clients to make the connection).
.B db
should start as soon as you can connect with your local
.B mysql
client.
.SH OPTIONS
There are two completely different methods available to invoke
.B db:
Either serverhost and username are given (optionally along with a password)
or database and table.
.B db
tries to find the first argument given in 
.B /etc/hosts
and - in case of success - assumes that the second form of invocation was
intended. This causes problems in some cases: everytime a hostname from
.B /etc/hosts
coincides with a database name there is no way to use the 
.B db database table
invocation. Even worse: remote hosts not listed in
.B /etc/hosts
will be taken as database names :-(
.TP
.B database
Any MySQL database. No
.B table
may be specified if
.B database
is omitted.
.TP
.B table
Select any existing MySQL database table from database. Leave it out and you
will be prompted for a table.
.TP
.B mysqlhost
Hostname with a running MySQL daemon (mysqld) to connect to. Can be a fully
qualified hostname or localhost.
.TP
.B mysqluser
Username used to connect to 
.B mysqld
daemon on 
.B mysqlhost.
.TP
.B mysqlpassword
Password used to connect to the mysqld daemon.
.B Note:
In most cases no password must be given. It will be read from
.B .my.cnf
or from
.B .db.rc
or will be asked for by the
.B db
script.
.TP
.B \-h \-\-help \-V \-\-version
These options all have the same effect: a short message is displayed showing
the version number and a guideline how to invoke
.B db.
.SH FILES
.TP 24
.I $HOME/.db.rc
Each user's personal configuration file;
.TP 24
.I $HOME/.dbtool/massmail/
Where each user's personal massmail letters are kept;
.TP 24
.I $HOME/.dbtool/print/
Where *.tex and *.dvi files of anything printed by this user are kept;
.TP 24
.I $HOME/.dbtool/scripts/
Where *.sql scripts made by this user are kept;
.TP 24
.I /usr/local/bin/db
Executable shell script;
.TP 24
.I /var/tmp/db/db.log
Logfile for errors and most user action.
.SH DIAGNOSTICS
.B db
tries to catch some errors. Failure to insert data into MySQL
is reported in 
.B /var/tmp/db/db.log.
Have a look at the TeX logfile under
.B ~/.dbtool/print/
if massmail did not succeed to print. In most cases there was a TeX error.
.SH BUGS
Probably quite a few (let me know of any you find).
Import functions are still missing but are on the TODO list.
.TP
Insert after changes is much too slow.
.SH AUTHOR
Thomas G. Spahni <thomas@spahni.ch>
.LP
