#include "arch.h"

#define SETBIT(el, x) (e->pmt_bool.ch [(x+1) / 8] |= 1 INCR_SHIFT (x+1) % 8)
#define CLRBIT(el, x) (e->pmt_bool.ch [(x+1) / 8] &= ~(1 INCR_SHIFT (x+1) % 8))
#define TSTBIT(el, x) (e->pmt_bool.ch [(x+1) / 8] & 1 INCR_SHIFT (x+1) % 8)

typedef void (*INIT) (void);
typedef unsigned int * (*LOCATE) (char*, unsigned int, char**);
typedef int (*REGISTER) (Element*);
typedef void (*UNREG) (Element*);
typedef unsigned int (*USAGE) (void);

typedef struct {
	INIT init;
	char *code;
	char *fqname;
	LOCATE locate;
	REGISTER reg;
	UNREG unreg;
	USAGE rusage;
} PolymorphicType;

