#include "config.h"
#ifdef BUG_TRAP
 #include <assert.h>
#endif

typedef struct Element_t Element;
typedef struct Link_t Link;
typedef struct Group_t Group;
typedef struct polymorphic_bits_t polymorphic_bits;

extern unsigned int sleep (unsigned int);
extern const char MEM_FAIL [];

#define GUARD(x) \
	while ((x) == NULL) \
	{\
		fputs (MEM_FAIL, stderr);\
		sleep (1);\
	}
#define PMT_BYTES 1
#define BAD_PMT &Elements
#define FREE_ID ElTop
#define ELOADED(x) ((x)->pmt_bool.ch [0] & 1)
#define ISLOADED(x) ((x)->pmt_bool.ch [0] |= 1)

struct polymorphic_bits_t {
	unsigned char ch [PMT_BYTES];
};

struct Element_t {
	char *data;
	unsigned int len;
	unsigned int id;
	Element *next, *prev;
	Element *ngrp, *pgrp;
	Link *link;
	Group *group;
	polymorphic_bits pmt_bool;
};

struct Link_t {
	Element *e;
	Link *next;
	short int lid;
};

struct Group_t {
	unsigned int cnt;
	char *node_name;
	Group *parent, *child;
	Group *more, *less;
	Element *e;
};

extern char *datafile, *groupfile, *linkfile;
extern Group root;
extern unsigned int Elements, FREE_ID;
extern Element **element;

extern Group		*find_group (Group*, char*[]);
extern Group		*add_group (Group*, const char*);
extern void		del_group (Group*);
extern int		ch_parent (Group*, Group*, const char*);
extern void		chgrp (Element*, Group*);
extern Element		*new_element (Group*, char*, unsigned int);
extern unsigned	int	eexists (char*, unsigned int);
extern Link		*find_link (Element*, Element*);
extern void		link_elems (unsigned int, unsigned int, short);
extern void		break_link (unsigned int, unsigned int);
extern void		del_elem (unsigned int);
extern unsigned int	*find_cistr (char*);
extern unsigned int	*locate (char*[], char*, unsigned int, char*);
extern void		change_dataof (Element*, char*, unsigned int);
extern char		*show_pmts (Element*, short int*);
extern short int	pmt_byname (const char*);
extern int		register_type (Element*, short int);
extern int		unregister_type (Element*, short int);
extern unsigned int	count_links (unsigned int);

extern void save_all (), load_all (unsigned int, unsigned int, char*);

extern void data_to_stream (Element*, FILE*);
extern void datato (Element*, char*, unsigned int);

#ifdef USE_SFMALLOC
extern void init_sfmalloc (void);
#endif
