#include <sys/socket.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "common.h"

extern int connectlnsh ();

int main (int argc, char **argv)
{
#define BUF_LEN 1024
	FILE *f;
	char tmp [BUF_LEN], *c;
	int i, cl, HTML = 0;

	if (argc == 1)
	{
		fputs ("No arguments!\n", stderr);
		return 1;
	} else if (argc > 3
               || (argc == 3 && !(HTML = strcmp (argv [1], "-h") == 0))) {
		fputs ("More than one argument.\n"
		       "The usage is: show [-h] ID\n", stderr);
		return 1;
	}

	f = fdopen (connectlnsh (), "r+");
	fprintf (f, "sh %u\n", atoi (argv [1 + HTML]));
	fflush (f);
	if (!fgets (tmp, BUF_LEN, f))
	{
		perror ("show::fgets");
		return 1;
	}

	if (tmp [0] == '-')
	{
		fprintf ((HTML) ? stdout : stderr, 
			"Failure reply: %s", tmp);
		return 1;
	}
	tmp [strlen (tmp) - 1] = 0;

	if (HTML)
		printf ("Content-Length: %u\r\n\r\n", atoi (tmp + 4));

	// Get content length
	if (!(c = strchr (tmp, ':')))
	{
		fprintf (stderr, "Bad reply: `%s'\n", tmp);
		return 1;
	}

	for (cl = atoi (c + 2); cl > 0; cl -= i)
		fwrite (tmp, 1, 
		i = fread (tmp, 1, (cl > BUF_LEN) ? BUF_LEN : cl, f), stdout);

	// Get trailing newline and reply line.
	fgetc (f);
	fgets (tmp, BUF_LEN, f);
	
	return 0;
}
