#include <sys/stat.h>
#include <sys/socket.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include "common.h"

extern int connectlnsh ();

FILE *f;

void F2F (FILE *from, FILE *to)
{
#define BUF_LEN 2048
	char tmp [BUF_LEN];

	do fwrite (tmp, 1, fread (tmp, 1, BUF_LEN, from), to);
	while (!feof (from));
}

char *stdin_tmp ()
{
	FILE *f;
	char *c = tmpnam (NULL);

	F2F (stdin, f = fopen (c, "w"));
	fclose (f);
	return c;
}

void checkid_file (char *c)
{
	struct stat buf;
	FILE *cur;

	if (stat (c, &buf) == -1)
	{
		perror ("stat");
		fprintf (stderr, "Error Opening: %s\n", c);
		exit (1);
	}

	if (!(cur = fopen (c, "r")))
	{
		perror ("fopen");
		fprintf (stderr, "Error Opening: %s\n", c);
		exit (1);
	}
	f = fdopen (connectlnsh (), "r+");
	fprintf (f, "idofcl %lu\n", buf.st_size);
	F2F (cur, f);
	fputs ("\n", f);
	fflush (f);
	fclose (cur);
}

void checkid_str (char *c)
{
	f = fdopen (connectlnsh (), "r+");
	fprintf (f, "idofcl %u\n%s\n", strlen (c), c);
	fflush (f);
}

int check_reply ()
{
	char reply [100];
	unsigned int id;

	if (!fgets (reply, 100, f))
	{
		perror ("query::fgets");
		return 1;
	}
	if (reply [0] == '-')
	{
		fprintf (stderr, "Not found\n");
		return 1;
	}
	id = atoi (reply);
	fgets (reply, 100, f);
	printf ("%u\n", id);

	return 0;
}

int main (int argc, char **argv)
{
	char *c = NULL;

	if (argc == 1)
		checkid_file (c = stdin_tmp ());
	else if (getopt (argc, argv, "s:") == -1)
		checkid_file (argv [optind]);
	else
		checkid_str (optarg);

	if (c) unlink (c);
	return check_reply ();
}
