#include <sys/socket.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <unistd.h>
#include "common.h"

extern int connectlnsh ();
int showdata = 1, HTML;
FILE *f;
#define BUF_LEN 100

struct el {
	unsigned int id;
	struct el *next;
} *first;

int get_id ()
{
	char tmp [BUF_LEN];
	struct el *lp;

	if (!fgets (tmp, BUF_LEN, f))
	{
		perror ("lls::fgets");
		exit (1);
	}
	switch (tmp [0]) {
	case '-':
		if (!HTML) fprintf (stderr, "Lndbase reply: %s", tmp);
		else printf ("Request fail: %s\n", tmp);
		exit (1);
	case '*':
		return 0;
	default: break;
	}

	if (!first)
		first = lp = (struct el*) malloc (sizeof (struct el));
	else
	{
		for (lp = first; lp->next; lp = lp->next);
		lp->next = (struct el*) malloc (sizeof (struct el));
		lp = lp->next;
	}

	// Each link has the form:
	// "group: [id]" or "group: [id] / lid"
	lp->next = NULL;
	lp->id = atoi (tmp);
	return 1;
}

/*
 * Get an id and check:
 *  if its a small element.
 *  if its a oneline element.
 *  if its printable.
 */
#define MAX_SHOW 50
char *check_data (unsigned int id)
{
	char tmp [BUF_LEN], *c;
	unsigned int len;

	f = fdopen (connectlnsh (), "r+");
	fprintf (f, "lenof %u\n", id);
	fflush (f);
	fgets (tmp, BUF_LEN, f);
	if (tmp [0] == '-')
	{
		fprintf (stderr, "Unexpected reply: %s", tmp);
		return NULL;
	}
	len = atoi (tmp);
	fgets (tmp, BUF_LEN, f); // the reply status line
	fclose (f);
	if (len > MAX_SHOW)
		return NULL;
	c = (char*) malloc (len + 1);
	f = fdopen (connectlnsh (), "r+");
	fprintf (f, "sh %u\n", id);
	fflush (f);
	fgets (tmp, BUF_LEN, f);
	fread (c, 1, len + 1, f);
	fgets (tmp, BUF_LEN, f);
	c [len--] = 0;
	for (id = 0; id < len; id++)
		if (!isprint (c [id]))
		{
			free (c);
			return NULL;
		}
	return c;
}

void print_el (struct el *lp)
{
	char rawp [] = "%u\n";
	char httpp [] = "<TR><TD>[<A HREF=/%u> %u </A>]\n";
	char rawd [] = "%s [%u]\n";
	char httpd [] = "<TR><TD> %s <TD> [<A HREF=/%u>%u</A>]\n";
	char *c;

	if ((showdata) && (c = check_data (lp->id)))
		if (HTML) printf (httpd, c, lp->id, lp->id);
		else  printf (rawd, c, lp->id);
	else
		if (HTML) printf (httpp, lp->id, lp->id);
		else  printf (rawp, lp->id);
}

int main (int argc, char **argv)
{
	int i;
	struct el *lp;

	while ((i = getopt (argc, argv, "ih")) != -1)
		switch (i) {
		case 'i':
			showdata = 0;
			break;
		case 'h':
			HTML = 1;
			break;
		default:
			fprintf (stderr, "unknown option\n");
			return 1;
		}

	f = fdopen (connectlnsh (), "r+");
	if (argv [optind] == NULL)
		fputs ("ls\n", f);
	else
		fprintf (f, "ls %s\n", argv [optind]);
	fflush (f);

	if (HTML)
		printf ("Content-Type: text/html\r\n\r\n"
			"<HTML><H2><HEAD>"
		      	"<TITLE> Elements of group: %s"
			"</TITLE></HEAD><BODY><TABLE>\n",
			 (argv [optind] == NULL) ?
			"<I>cwd</I>" : argv [optind]);

	while (get_id ());
	fclose (f);

	for (lp = first; lp; lp = lp->next)
		print_el (lp);
	if (HTML) puts ("</TABLE></BODDY></H2></HTML>");

	return 0;
}
