/*****************************************************************************

 Web browser connectivity.

 This is nothing more than a full featured, highly advanced, state of the art,
 powerful, professional strength, robhust web server.
 
 It just transforms URLs to Lndbase IDs, and calls links.

****************************************************************************/

#include <sys/types.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <string.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <ctype.h>

#define BUF 512

const char bad_request [] = "HTTP/1.0 400 Bad Request\r\n\r\n";
const char ok [] = "HTTP/1.0 200 Ok\r\n";

int server (short int port)
{
	int fd;
	struct sockaddr_in socka;

	fd = socket (AF_INET, SOCK_STREAM, 0);

	socka.sin_family = AF_INET;
	socka.sin_port = htons (port);
	socka.sin_addr.s_addr = htonl (INADDR_ANY);

	if (bind (fd, (struct sockaddr*)&socka, sizeof socka))
	{
		fprintf (stderr, "Can't bind at port %i\n", port);
		perror ("Bind");
		exit (1);
	}

	listen (fd, 1);

	return fd;
}

void fixstr (char *dest, char *sou)
{
	// Per RFC1738
	char tmp [BUF], *p, *c, hex [3];

	for (hex [2] = 0, p = sou, c = tmp; *p != ' '; p++)
		switch (*p) {
		case '+': *c++ = ' '; break;
		case '%':
			hex [0] = *++p, hex [1] = *++p;
			*c++ = strtoul (hex, NULL, 16);
			break;
		default:  *c++ = *p;
		}

	*c = 0;

	sprintf (dest, "lnshfind -h '%s'", tmp);
}

int accept_client (int s)
{
	int c, i;
	struct sockaddr_in foo;

	c = accept (s, (struct sockaddr*)&foo, &i);
	if (c == -1)
	{
		perror ("Accept");
		exit (1);
	}

	return c;
}

void do_stuff (int fd)
{
	char tmp [200];
	char buf [BUF];
	FILE *ff;
	int i;
	FILE *f = fdopen (fd, "r");

	//
	// The request line is all we'll ever want.
	// Per RFC 2068 it should be :
	// GET /2 HTTP/1.0
	//
	fgets (tmp, BUF, f);

	{ char tmp [BUF];
	  while (tmp [0] != '\n' && tmp [0] != '\r')
		fgets (tmp, BUF, f); }

	if (!strncmp (tmp, "GET /", 5))
		if (!strncmp (tmp + 5, "find", 4))
			if (tmp [9] == '?')
				fixstr (tmp, tmp + 10);
			else strcpy (tmp, "lnshfind -h");
		else if (isdigit (tmp [5]))
			sprintf (tmp, "links -h %u", (unsigned int)
				 strtoul (tmp + 5, NULL, 10));
		else if ((!strncmp (tmp + 5, "sh/", 3)) && (isdigit (tmp [8])))
			sprintf (tmp, "lnshdisplay -h %u", (unsigned int)
				 strtoul (tmp + 8, NULL, 10));
		else if (!strncmp (tmp + 5, "ls/", 3))
		{
			char *c = strchr (tmp + 8, ' ');
			*c = 0;
			sprintf (tmp, "lls -h %s", tmp + 8);
		}
		else goto Else;
	else
	{
Else:				// what a complicated webserver...
		write (fd, bad_request, sizeof bad_request - 1);
		shutdown (fd, 2);
		return;
	}

	write (fd, ok, sizeof ok - 1);
	ff = popen (tmp, "r");
	do write (fd, buf, i = fread (buf, 1, BUF, ff));
	while (i == BUF);

	fflush (f);
	pclose (ff);
	fclose (f);
	shutdown (fd, 2);
}

int main (int argc, char **argv)
{
	int s = server (argc == 1 ? 8080 : atoi (argv [1]));

	signal (SIGPIPE, SIG_IGN);
	for (;;) do_stuff (accept_client (s));

	return 0;
}
