/******************************************************************************

	The the-user-is-my-hated-enemy text interface

	Really, this interface does not offer some basic things.
	All the scrollable areas including : macro defs, variables, objects,
	argument stack examine; are not available.

	Just a prompt

******************************************************************************/
/**************************************************************************
 Copyright (C) 2000 Stelios Xantkakis
**************************************************************************/

#include <stdio.h>
#include <termios.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>

#include "INIT.h"
#include "readline++.h"
#include "epil.h"
#include "priv.h"

#define VP virtual public

class tty_readline : VP breadline, VP history, VP normtab
{
   public:
	tty_readline () : history (100) { Vcur = 0; Width = 60; }
	void present ();
};

void tty_readline::present ()
{
	int j, k;

	write (1, prompt, strlen (prompt));

	k = j = (line.linelen - Vcur < Width) ?  (line.linelen - Vcur) : Width;

	write (1, line.line + Vcur, j);

	while (k < Width) {
		write (1, " ", 1);
		k++;
	}

	while (k > j) {
		write (1, "\b", 1);
		k--;
	}

	while (Vcur + j > line.cursor) {
		write (1, "\b", 1);
		j--;
	}
}

class eprl : public tty_readline
{
   public:
	eprl () : tty_readline (), history (100) { prompt = "\r[epil] $ "; }
	void do_enter ();
};

void eprl::do_enter ()
{
	addl ();
	write (1, "\n", 1);

	fputs (">>>>>>>>> <<<<<<<<<<\n", stderr);
	Zexec_unit (line.line);
	line.reset ();
	Vcur = 0;
	present ();
}

static int tty_translate (int c)
{
	// it sais that in ttys control characters are escaped with 27-91-xx
	if (c == 127) return '\b';
	if (c == 27) {
		if (read (0, &c, 1) == 0)
			return K_SKIP;
		if (c != 91)
			return K_SKIP;
		if (read (0, &c, 1) == 0)
			return K_SKIP;
		int c2 = 0;
		switch (c) {
		case 65: return K_UP;
		case 66: return K_DOWN;
		case 67: return K_RIGHT;
		case 68: return K_LEFT;
		case 49:
		case 51:
		case 52:
		case 53:
		case 54:
			if (read (0, &c2, 1) == 0 || c2 != 126)
				return K_SKIP;
			switch (c) {
			case 49: return K_HOME;
			case 51: return K_DEL;
			case 52: return K_END;
			case 53: return K_PGUP;
			case 54: return K_PGDOWN;
			}
		default: return K_SKIP;
		}
	}
	return c;
}

static void runinitcode ()
{
	char *ecode;
	TMP_POP_ALLOC(ecode)

	Zexec_unit (ecode);
}

void coded_starttty ()
{
static	bool Block = false;
	struct termios initt, newt;

	if (Block || tcgetattr (0, &initt) == -1) {
		ep_boolean = false;
		return;
	}
	Block = true;

	int ch = 0;
	fd_set Fset;

	eprl Line;

	newt = initt;
	newt.c_lflag &= ~ICANON;
	newt.c_lflag &= ~ECHO;
	newt.c_lflag &= ~ISIG;
	newt.c_cc [VMIN] = newt.c_cc [VTIME] = 0;
	tcsetattr (0, TCSANOW, &newt);

	FD_ZERO (&Fset);
	FD_SET (0, &Fset);

	Line.present ();

	runinitcode ();

	while (!ExitRequested) {
		select (FD_SETSIZE, &Fset, NULL, NULL, NULL);
		read (0, &ch, 1);
		if (ch == 4) break;
		Line.do_char (tty_translate (ch));
	}

	tcsetattr (0, TCSANOW, &initt);
}
