/*****************************************************************************
 *                             gui.c - source of the GUI                     *
 *                             -------------------------                     *
 *          begin:             Sat Aug 3  13:08:46 CEST 1999                 *
 *          copyright:         (C) 1999 by Rene van Bevern                   *
 *          eMail:             RvB@pro-linux.de                              *
 *          ICQ #:             42438601                                      *
 *****************************************************************************/

/*****************************************************************************
 * This program is free software; you can redistribute and/or modify it      *
 * under the terms of the GNU General Public Licence as published by the     *
 * Free Software Foudation (FSF); either version 2 of the License or (at     *
 * your opinion) any later version,                                          *
 *****************************************************************************/


#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>

GtkWidget *infile;
GtkWidget *outfile;
GtkWidget *password;
GtkWidget *do_encode;
GtkWidget *do_decode;

int quitfunc( GtkWidget *widget,
              gpointer data )
{
    gtk_main_quit();
}

void xrcode_failed( void )
{
    GtkWidget *window;
    GtkWidget *table;
    GtkWidget *label;
    GtkWidget *button;
    GtkWidget *pixmapwg;
    GtkWidget *pixmap;
    GdkBitmap *mask;
    GtkStyle *style;
    window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
    table = gtk_table_new( 2, 2, FALSE );
    label = gtk_label_new( "The operation failed ;o[, change to the console,\n where you startet me from, to find out why" );
    button = gtk_button_new_with_label( "Close" );
    style = gtk_widget_get_style( window );
    pixmap = gdk_pixmap_create_from_xpm (window->window, &mask,
                                         &style->bg[GTK_STATE_NORMAL],
                                         __FAILEDXPM__);
    pixmapwg = gtk_pixmap_new (pixmap, mask);
    gtk_container_set_border_width( GTK_CONTAINER( window ), 10 );
    gtk_table_attach_defaults( GTK_TABLE( table ), label, 1, 2, 0, 1);
    gtk_table_attach_defaults( GTK_TABLE( table ), button, 1, 2, 1, 2);
    gtk_table_attach_defaults( GTK_TABLE( table ), pixmapwg, 0, 1, 0, 1);

    gtk_signal_connect_object( GTK_OBJECT( button ), "clicked",
                               (GtkSignalFunc)gtk_widget_destroy, GTK_OBJECT( window ));
    
    gtk_window_set_title( GTK_WINDOW( window ), "ERROR!" );
    gtk_container_add( GTK_CONTAINER( window ), table );
    gtk_widget_show( label );
    gtk_widget_show( button );
    gtk_widget_show( pixmapwg );
    gtk_widget_show( table );
    gtk_widget_show( window );
}

void xrcode_succeed( void )
{
    GtkWidget *window;
    GtkWidget *table;
    GtkWidget *label;
    GtkWidget *button;
    GtkWidget *pixmapwg;
    GtkWidget *pixmap;
    GdkBitmap *mask;
    GtkStyle *style;
    window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
    table = gtk_table_new( 2, 2, FALSE );
    label = gtk_label_new( "Operation succeeded :-)");
    button = gtk_button_new_with_label( "Close" );
    style = gtk_widget_get_style( window );
    pixmap = gdk_pixmap_create_from_xpm (window->window, &mask,
                                         &style->bg[GTK_STATE_NORMAL],
                                         __SUCCEEDXPM__);
    pixmapwg = gtk_pixmap_new (pixmap, mask);
    gtk_container_set_border_width( GTK_CONTAINER( window ), 10 );
    gtk_table_attach_defaults( GTK_TABLE( table ), label, 1, 2, 0, 1);
    gtk_table_attach_defaults( GTK_TABLE( table ), button, 1, 2, 1, 2);
    gtk_table_attach_defaults( GTK_TABLE( table ), pixmapwg, 0, 1, 0, 1);
    gtk_signal_connect_object( GTK_OBJECT( button ), "clicked",
                               (GtkSignalFunc)gtk_widget_destroy, GTK_OBJECT( window ));

    gtk_window_set_title( GTK_WINDOW( window ), "ERROR!" );
    gtk_container_add( GTK_CONTAINER( window ), table );
    gtk_widget_show( label );
    gtk_widget_show( pixmapwg );
    gtk_widget_show( table );
    gtk_widget_show( button );
    gtk_window_set_title( GTK_WINDOW( window ), "Succeded!" );
    gtk_widget_show( window );
}

void go( GtkWidget *widget,
         gpointer data )
{
    char infileval[255];
    char outfileval[255];
    char passwordval[255];
    char cmdlin[4096];
    char kind[31];
    int status;
    sprintf(infileval, "%s", gtk_entry_get_text( GTK_ENTRY( infile ) ) );
    sprintf(outfileval, "%s", gtk_entry_get_text( GTK_ENTRY( outfile ) ) );
    sprintf(passwordval, "%s", gtk_entry_get_text( GTK_ENTRY( password ) ) );
    if( GTK_TOGGLE_BUTTON(do_encode)->active )
    {
        sprintf(kind, "rencode");
    }
    if( GTK_TOGGLE_BUTTON(do_decode)->active )
    {
        sprintf(kind, "rdecode");
    }
    sprintf(cmdlin, "%s \"%s\" \"%s\" \"%s\"", kind, infileval, outfileval, passwordval );
    status=system(cmdlin);
    if( status != 0 )
    {
        g_print("XRcode: hmmm, %s returned %i, that means that something\nis failed! I'm afraid I have to display the error message", kind, status);
        xrcode_failed();
    }
    if( status == 0 )
    {
        g_print("XRcode: ok, %i was returned by %s. Evering runned correctly.\n Displaying succeed message...", kind, status);
        xrcode_succeed();
    }
}

void file_ok_infile( GtkWidget *widget,
                     GtkFileSelection *fs )
{
    gtk_entry_set_text( GTK_ENTRY( infile ), gtk_file_selection_get_filename( GTK_FILE_SELECTION(fs)));
}

void file_ok_outfile( GtkWidget *widget,
                      GtkFileSelection *fs )
{
    gtk_entry_set_text( GTK_ENTRY( outfile ), gtk_file_selection_get_filename( GTK_FILE_SELECTION(fs)));
}


void browse_infile( GtkWidget *widget,
                    gpointer data )
{
    GtkWidget *filesel;
    filesel = gtk_file_selection_new( "Input file selection" );
    gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION (filesel)->cancel_button), "clicked",
                               (GtkSignalFunc) gtk_widget_destroy, GTK_OBJECT (filesel));
    gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (filesel)->ok_button),
                        "clicked", (GtkSignalFunc) file_ok_infile, filesel );
    gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION (filesel)->ok_button), "clicked",
                               (GtkSignalFunc) gtk_widget_destroy, GTK_OBJECT (filesel));
    
    gtk_widget_show( filesel );
}

void browse_outfile( GtkWidget *widget,
                    gpointer data )
{
    GtkWidget *filesel;
    filesel = gtk_file_selection_new( "Output file selection" );
    gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION (filesel)->cancel_button), "clicked",
                               (GtkSignalFunc) gtk_widget_destroy, GTK_OBJECT (filesel));
    gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (filesel)->ok_button),
                        "clicked", (GtkSignalFunc) file_ok_outfile, filesel );
    gtk_signal_connect_object (GTK_OBJECT (GTK_FILE_SELECTION (filesel)->ok_button), "clicked",
                               (GtkSignalFunc) gtk_widget_destroy, GTK_OBJECT (filesel));

    gtk_widget_show( filesel );
}

int main( int argc,
          char *argv[] )
{
    char title[80];
    GtkWidget *window;
    GtkWidget *table;
    GtkWidget *label;
    GtkWidget *gobutton;
    GtkWidget *cancelbutton;
    GtkWidget *label_in;
    GtkWidget *label_out;
    GtkWidget *label_pass;
    GtkWidget *browserbutton_infile;
    GtkWidget *browserbutton_outfile;
    GtkWidget *sep;

    gtk_init( &argc, &argv );
    g_print("\nXRCode %s by Rene van Bevern aka RvB <RvB@pro-linux.de> ICQ# 42438601\n", __TITLE__);
    window = gtk_window_new( GTK_WINDOW_TOPLEVEL );
    table = gtk_table_new(3, 8, FALSE);
    label = gtk_label_new( __LABELTEXT__ );
    label_in = gtk_label_new(   "Input file" );
    label_out = gtk_label_new(  "Output file" );
    label_pass = gtk_label_new( "Password" );
    gobutton = xpmbutton( window, __GOXPM__, "Start!" );
    cancelbutton = xpmbutton( window, __CANCELXPM__, "Quit" );
    infile = gtk_entry_new();
    outfile = gtk_entry_new();
    password = gtk_entry_new();
    browserbutton_infile = gtk_button_new_with_label( "Browse...");
    browserbutton_outfile = gtk_button_new_with_label( "Browse...");
    do_encode = gtk_radio_button_new_with_label(NULL, "Encode file");
    do_decode = gtk_radio_button_new_with_label(gtk_radio_button_group( GTK_RADIO_BUTTON( do_encode ) ), "Decode file");
    sep = gtk_hseparator_new();
    gtk_entry_set_visibility( GTK_ENTRY( password ), FALSE );
    gtk_container_set_border_width( GTK_CONTAINER(window), 10 );
    sprintf( title, "%s by Rene van Bevern aka RvB", __TITLE__ );
    gtk_window_set_title(GTK_WINDOW( window ), title );
    gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( do_encode ), TRUE );
    gtk_toggle_button_set_active( GTK_TOGGLE_BUTTON( do_decode ), FALSE );
    gtk_label_set_justify( GTK_LABEL( label_in ), GTK_JUSTIFY_LEFT );
    gtk_label_set_justify( GTK_LABEL( label_out ), GTK_JUSTIFY_LEFT );
    gtk_label_set_justify( GTK_LABEL( label_pass ), GTK_JUSTIFY_LEFT );
    gtk_label_set_justify( GTK_LABEL( label ), GTK_JUSTIFY_LEFT );
    gtk_signal_connect( GTK_OBJECT( window ), "delete_event",
                        GTK_SIGNAL_FUNC( gtk_widget_destroy ), GTK_WIDGET( window ) );
    gtk_signal_connect( GTK_OBJECT( window ), "destroy",
                        GTK_SIGNAL_FUNC( quitfunc ), NULL );
    gtk_signal_connect( GTK_OBJECT( gobutton ), "clicked",
                        GTK_SIGNAL_FUNC( go ), NULL );
    gtk_signal_connect( GTK_OBJECT( cancelbutton ), "clicked",
                        GTK_SIGNAL_FUNC( quitfunc ), NULL );
    gtk_signal_connect( GTK_OBJECT( browserbutton_infile ), "clicked",
                        GTK_SIGNAL_FUNC( browse_infile ), NULL );
    gtk_signal_connect( GTK_OBJECT( browserbutton_outfile ), "clicked",
                        GTK_SIGNAL_FUNC( browse_outfile ), NULL );
    gtk_container_add( GTK_CONTAINER( window ), table );
    gtk_table_attach_defaults( GTK_TABLE( table ), gobutton, 1, 2, 6, 7 );
    gtk_table_attach_defaults( GTK_TABLE( table ), cancelbutton, 0, 1, 6, 7 );
    gtk_table_attach_defaults( GTK_TABLE( table ), do_encode, 0, 1, 4, 5 );
    gtk_table_attach_defaults( GTK_TABLE( table ), do_decode, 1, 2, 4, 5 );
    gtk_table_attach_defaults( GTK_TABLE( table ), label, 0, 2, 7, 8 );
    gtk_table_attach_defaults( GTK_TABLE( table ), infile, 1, 2, 0 ,1 );
    gtk_table_attach_defaults( GTK_TABLE( table ), outfile, 1, 2, 1, 2 );
    gtk_table_attach_defaults( GTK_TABLE( table ), password, 1, 2, 2, 3 );
    gtk_table_attach_defaults( GTK_TABLE( table ), label_in, 0, 1, 0, 1 );
    gtk_table_attach_defaults( GTK_TABLE( table ), label_out, 0, 1, 1, 2 );
    gtk_table_attach_defaults( GTK_TABLE( table ), label_pass, 0, 1, 2, 3 );
    gtk_table_attach_defaults( GTK_TABLE( table ), sep, 0, 3, 3, 4); gtk_widget_show( sep ); sep = gtk_hseparator_new();
    gtk_table_attach_defaults( GTK_TABLE( table ), sep, 0, 3, 5, 6); gtk_widget_show( sep );
    gtk_table_attach_defaults( GTK_TABLE( table ), browserbutton_infile, 2, 3, 0, 1 );
    gtk_table_attach_defaults( GTK_TABLE( table ), browserbutton_outfile, 2, 3, 1, 2 );
    gtk_widget_show( gobutton );
    gtk_widget_show( cancelbutton );
    gtk_widget_show( infile );
    gtk_widget_show( outfile );
    gtk_widget_show( password );
    gtk_widget_show( label_in );
    gtk_widget_show( label_out );
    gtk_widget_show( label_pass );
    gtk_widget_show( browserbutton_infile );
    gtk_widget_show( browserbutton_outfile );
    gtk_widget_show( do_encode );
    gtk_widget_show( do_decode );
    gtk_widget_show( table );
    gtk_widget_show( label );
    gtk_widget_show( window );
    gtk_main();
    return(0);
}