/*
 * 
 * servidor_sock.c - Suporte para rede para o servidor
 * 
 * 
 * (c) 1998 Nuno Sucena Almeida <slug@student.dee.uc.pt>
 * 
 */

#include <netdb.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>

#include "config.h"
#include "servidor_file.h"
#include "servidor_sock.h"
#include "servidor_util.h"


char *V_servico;
char *V_endereco;
int V_max_ligacao;

int cria_socket ( int *soquete , char *protocolo , char *servico ,
		 char *endereco , int tipo )
{
   struct protoent *Pprotocolo;
   struct servent *Pservico;
   struct sockaddr_in Endereco;
   int temp;
   if (( Pprotocolo = getprotobyname ( protocolo )) == NULL )
     {
	fprintf ( stderr , "Problem using protocol %s!\n" , protocolo );
	return ( ERRO);
     }
   if ( ( Pservico = getservbyname ( servico , Pprotocolo->p_name )) == NULL )
     {
	fprintf ( stderr , "Problem using service %s!\n" , servico );
	return ( ERRO);
     }
   if ( (*soquete = socket ( AF_INET , SOCK_STREAM , Pprotocolo->p_proto )) == -1 )
     {
	perror ("socket");
	return ( ERRO);
     }
   Endereco.sin_family = AF_INET;
   Endereco.sin_port = Pservico->s_port;
   Endereco.sin_addr.s_addr = inet_addr ( endereco );
   memset ( &(Endereco.sin_zero), 0 , sizeof ( Endereco.sin_zero ));
   switch ( tipo )
     {
      case BIND_TYPE:
	temp=1;
	setsockopt(*soquete, SOL_SOCKET, SO_REUSEADDR, &temp, sizeof(temp));
	if (bind( *soquete, (struct sockaddr *) &Endereco, sizeof(struct sockaddr)) == -1 )
	  {
	     perror ("bind");
	     return(ERRO);
	  }
	break;
      case CONNECT_TYPE:
	if (connect ( *soquete, (struct sockaddr *) &Endereco, sizeof(struct sockaddr)) == -1 )
	  {
	     perror ("connect");
	     return(ERRO);
	  }	
	break;
     }
   return (OK);
}

char *nome_maquina ( int soquete )
{
   struct sockaddr_in endereco;
   struct hostent *hostname;
   int comprimento = sizeof ( struct sockaddr_in );
   if ( getpeername ( soquete , (struct sockaddr *)&endereco, &comprimento))
     {
	perror("getpeername");
	return(NULL);
     }
   else
     if ( (hostname = gethostbyaddr ( (char *)&endereco.sin_addr ,sizeof(struct in_addr ),AF_INET ))==NULL)
     {
	herror(inet_ntoa(endereco.sin_addr));
	return(NULL);
     }
   else
     return((char*)strdup(hostname->h_name));
}

char *endereco_maquina ( int soquete )
{
   struct sockaddr_in endereco;
   int comprimento = sizeof ( struct sockaddr_in );
   if ( getpeername ( soquete , (struct sockaddr *)&endereco, &comprimento))
     {
	perror("getpeername");
	return(NULL);
     }
   else return ( strdup ( inet_ntoa ( endereco.sin_addr )));
}

int envia_mensagem ( int soquete , char *mensagem )
{
   int comprimento;
   comprimento = send ( soquete , mensagem , strlen (mensagem) ,0 );
   if (comprimento<0)
     {
	perror ("send");
	return (ERRO);
     }
   if (comprimento == strlen(mensagem))
     return(OK);
   else
     return (ERRO);
}

int server_loop ( int soquete , void *command_list , void *port_list )
{
   status *status_list=NULL, *status_current;
   int novo_soquete, n, comprimento, ligacoes=0;
   char buffer[MAX_BUFFER];
   char *comando=NULL , *temp=NULL;
   fd_set active_fd_set, read_fd_set;
   struct sockaddr_in endereco;
   
   FD_ZERO ( &active_fd_set );
   FD_SET ( soquete , &active_fd_set );
/*   FD_SET ( STDIN_FILENO , &active_fd_set ); */
   while (1)
     {
	read_fd_set = active_fd_set;
	if ( select ( FD_SETSIZE, &read_fd_set , NULL , NULL , NULL ) < 0 )
	  {
	     perror ("select");
	     return ( EXIT_FAILURE );
	  }
/*	printf ( "Ligacoes activas: %d\n" , ligacoes );*/
	for ( n=0; n < FD_SETSIZE; ++n)
	  {
	     if (FD_ISSET (n, &read_fd_set))
               {
		  /* nova ligacao */
		  if ( n == soquete )
		    {
		       comprimento = sizeof(struct sockaddr);
		       novo_soquete = accept ( soquete , (struct sockaddr *)&endereco, &comprimento);
		       if ( novo_soquete < 0 )
			 {
			    perror ("accept");
			    return(EXIT_FAILURE);
			 }
		       if ( ligacoes < V_max_ligacao )
			 {
			    ligacoes++;
			    create_new_connection ( &status_list , &status_current);
			    status_current->hostname = nome_maquina ( novo_soquete);
			    status_current->hostip = endereco_maquina ( novo_soquete);
			    status_current->soquete = novo_soquete;
			    FD_SET (novo_soquete, &active_fd_set);
			    printf ( "Connect from %s (%s)\n" ,
				     status_current->hostname , status_current->hostip );
			    /* Verificacao do endereco: */
			    if (verify_connect_address ( V_address_file , status_current )==ERRO)
			      {
				 envia_mensagem ( novo_soquete , "\n\nYou don't belong here...\n\n");
				 close ( novo_soquete );
				 printf ( "Connection refused from %s (%s)\n", 
					  status_current->hostname , status_current->hostip);
				 free_new_connection ( &status_list , novo_soquete );
				 ligacoes--;
				 FD_CLR (novo_soquete , &active_fd_set);
			      }
			 }
		       else
			 {
			    envia_mensagem (novo_soquete, "\n\nToo many connections.Sorry...\n\n" );
			    close ( novo_soquete );
			 }
		    }
		  else
		    {
		       /* ligacao ja' estabelecida */
		       memset ( buffer , '\0' , sizeof ( buffer ));
		       comprimento = recv ( n , buffer , MAX_BUFFER , 0);
		       if ( comprimento > 0)
			 {
			    comando = strtok_r ( buffer , LINE_COMMAND_SEPARATOR , &temp);
			    while ( comando != NULL )
			      {
				 if ( parse_user_commands ( n , comando , status_list , command_list , port_list)==SAI)
				   {
				      /* Fim de ligacao pelo servidor */
				      free_new_connection ( &status_list , n );
				      close ( n );
				      ligacoes--;
				      FD_CLR ( n, &active_fd_set );
				   }
				 comando = strtok_r ( NULL , LINE_COMMAND_SEPARATOR , &temp);
			      }
			 }
		       else
			 {
			    /* fim da ligacao pelo cliente */
			    free_new_connection ( &status_list , n );
			    ligacoes--;
			    close (n);
			    FD_CLR (n, &active_fd_set);
			 }
		    }
	       }
	  }
     }
   return ( OK );
}
