/*
 * PROGRAM  : xchange.c 
 * VERSION  : v0.9
 * LANGUAGE : (GNU) C        (any other sould do it too)
 * AUTHOR   : Amin Hamdan
 * LAST CHANGED : 31.12.1996
 * 
 * DESCRIPTION:
 * xchange - scans a file automaticly for its contens and then decides
 * weather it is a UNIX or a DOS text file to convert it automaticaly
 * the right way....(I hope  8-)
 */


#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/*
 * deklaration of the functions...
 */
void printInf(void);  /* print the help text */
void scanArgs(int argNumber,char *Args[]);  /* scans for the arguments at the
			     * shell prompt and invokes printUsage if necesarry
			     * to display the correct syntax */

void printUsage(void); /* prints out the right syntax */
void dos2unix(char *srcfile,char *destfile); /* the function for converting
					        DOS to UNIX */
void unix2dos(char *srcfile,char *destfile); /* UNIX to DOS converting */
int scanFile(char *filetoscan); /* function to scan for the contents of a
				   so that it can be converted automaticly */

/*
 * pointer to some functions...for easy acces of dos2unix and unix2dos 
 * the first one (exit) is not used! it's just for pushing dos2unix and
 * unix2dos to the right position in the array...
 */
void (*t[3])()={exit,dos2unix, unix2dos};

/*
 * the function scanArgs scans for the args of the programm and sets them
 * globaly,so they can be used everywhere in the programm
 * actually it is not necesary to have this global vars, but i think its
 * easier to scan once for the correct arguments and then set this vars
 *
 * paramS - String with the parameter (if there is one)
 * srcfileS - String with the name of the source file
 * destfileS - String with the name of the destination file
 */
char paramS[10]={0},srcfileS[81]={0},destfileS[81]={0};


main(int argc,char *argv[])
{
  /* need to check for the correct syntax */
  scanArgs(argc,argv);

  /* if the first parameter is -h print some information */
  if (!strcmp(paramS,"-h"))
    {
      printInf();
      exit(0);
    }
  /* if the switch -fd2u is set don't scan the file, 
   * just convert DOS to UNIX */
  else
    if (!strcmp(paramS,"-fd2u"))
      {
	(*t[1])(srcfileS, destfileS);
	exit(0);
      }
  /* if -fu2d is set, convert UNIX to DOS */
  else
    if(!strcmp(paramS,"-fu2d"))
      {
	(*t[2])(srcfileS, destfileS);
	exit(0);
      };

  /* if no switch is set, just scan the file and then convert it */
  (*t[scanFile(srcfileS)])(srcfileS, destfileS);
};


/*
 * this function scans for the arguments an sets the global vars
 * paramS, srcfileS and destfileS
 */
void scanArgs(int argNumber,char *Args[])
{
  switch(argNumber-1)
    {
      /* if there is only one arg it must be a parameter....or stop */
    case 1 :
      /* one argument can only be the help parameter! */
      if(!strcmp(Args[1],"-h"))
	strcpy(paramS,Args[1]);
      else
	printUsage();
      break;
      
      /* two arguments....got to be 2 filenames */
    case 2 :
      /* two arguments where on of is a parameter? wrong! stop the program */
      if(*(Args[1])=='-')
	printUsage();
      strcpy(srcfileS,Args[1]);
      strcpy(destfileS,Args[2]);
      break;
      
      /* three : one param and two filenames....or stop */
    case 3 :
      /* if there is no parameter....show some information and stop */
      if(*Args[1]!='-')
	printUsage();
      /* and if not....store the arguments in the global vars */
      else
	{
	  strcpy(paramS, Args[1]);
	  strcpy(srcfileS, Args[2]);
	  strcpy(destfileS, Args[3]);
	};
      break;
    default :
      printUsage();
    };
};


/*
 * scanFile looks deeply at the file and returns
 *     0 if the file seems to be a binary file (actually the programm wil
 *       stop if this is the case (if the -nb is not set))
 *     1 if the file seems to be a DOS text file
 *     2 if the file seems to be a UNIX text file
 */

int scanFile(char *filetoscan)
{
  int i=0,lfcnt=0,noASCII=0,scanForBin=1;
  FILE *inFile;
  char currentChar;


  /* 
   * if the scanning for a binary file content is deactivated 
   * set the scanForBin var to FALSE
   */
  if (!strcmp(paramS,"-nb"))
    scanForBin=0;

  if((inFile = fopen(filetoscan,"r"))==NULL)
    {
      /* if the file couldn't be opened write a error message to stderr */
      fputs("ERORR: couldn't open the source file for input.\n",stderr);
      exit(1);
    };

  printf("scanning file...");

  /* 
   * scan the beginning of the file (maximum 500 chars) for a 
   *  carriage return (DOS text file standard) or for non ascii chars
   */
  while(!feof(inFile) && !(i>500))
    {
      /* just to be sure that the it's not the end of the file */
      if((currentChar=fgetc(inFile))!=-1)
	{
	  /* cr char ist dec 13 */
	  if(currentChar==13)
	    lfcnt++;
	  /* i choose this range should be enough for ascii chars */
	  if((currentChar>126 || currentChar<7) && scanForBin)
	    noASCII++;
	  i++;
	  /* 
	   * this one prints some dots on the screens just to give the user
	   * a feedback....but on fast machines you don't even one of the
	   * dropped on the screen: just to fast...but i keept this part
	   * two lines that don't hurt anyone.
	   */
	  if((i%50)==0)
	    printf(".");
	};
    };

  fclose(inFile);

  /* now look what the result of the scans is. */
  if (noASCII>2)
    {
      printf("\nERORR: the given file doesn't seem to be a text file.\n"
	     "Failed to convert text. If you want to convert the file\n"
	     "overriding the binary file content scan, use the "
	     "\033[1m-nb\033[0m paramteter.\n");
      exit(1);
      return(0);
    }
  else if(lfcnt>2)
    {
      printf("looks like a DOS text file.\n");
      return(1);
    }
  else
    {
      printf("looks like a UNIX text file.\n");
      return(2);
    };
}


/* this function converts DOS to UNIX...nuttin more, nuttin less */
void dos2unix(char *srcfile, char *destfile)
{
  FILE *inFile, *outFile;
  char currentChar;

  if((inFile=fopen(srcfile,"r"))==NULL)
    {
      fputs("ERROR: couldn't open source file.\n",stderr);
      exit(1);
    };

  if((outFile=fopen(destfile,"w"))==NULL)
    {
      fputs("ERROR: couldn't open destination file.\n",stderr);
      exit(1);
    };

  printf("Converting DOS to UNIX...");

  /* if the file is not empty start to convert it */
  if(!feof(inFile))
    while((currentChar=fgetc(inFile))!=-1)
      {
	if(currentChar!=13 && currentChar!=-1)
	  fputc(currentChar, outFile);
      };

  fclose(inFile);
  fclose(outFile);

  printf("done!\n");
};


/* converts unix to dos */
void unix2dos(char *srcfile,char *destfile)
{
  FILE *inFile, *outFile;
  char currentChar;

  if((inFile=fopen(srcfile,"r"))==NULL)
    {
      fputs("ERROR: couldn't open source file.\n",stderr);
      exit(1);
    };

  if((outFile=fopen(destfile,"w"))==NULL)
    {
      fputs("ERROR: couldn't open destination file.\n",stderr);
      exit(1);
    };

  printf("Converting UNIX to DOS...");


  if(!feof(inFile))
    while((currentChar=fgetc(inFile))!=-1)
      {
	if(currentChar==10)
	  {
	    fputc(13, outFile);
	    fputc(10, outFile);
	  }
	else
	  fputc(currentChar, outFile);
      };

  fclose(inFile);
  fclose(outFile);

  printf("done!\n");

};

/* prints the correct syntax of the program */
void printUsage(void)
{
  printf("usage: \033[1mxchange [<parameter>] <source file> "
	 "<destination file>\n\033[0m"
	 "type xchange -h for more information\n");
  exit(1);
};


/* prints the help for the progamm */
void printInf(void)
{
  printf("xchange converts DOS text files into UNIX text files and the "
	 "other way back.\n\nusage:\n\txchange [<parameter>] <source file> "
	 "<destination file>\n\n"
	 "Where \033[1m<parameter>\033[0m is one of:\n"
	 "\t-h\tfor this help text\n"
	 "\t-nb\tto surpress the scan for a binary file content\n"
	 "\t-fd2u\tforces converting DOS to UNIX (no file scan!)\n"
	 "\t-fu2d\tforces converting UNIX to DOS (no file scan!)\n"
	 "not known parameters are ignored.\n"
	 "\n\033[1m<source file>\033[0m - the file to be converted\n"
	 "\033[1m<destination file>\033[0m - the file to which the output "
	 "is written to\n");
};







