/*
 * Copyright (c) 1993-1996 Sun Microsystems, Inc. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software
 * and its documentation for NON-COMMERCIAL purposes and without
 * fee is hereby granted provided that this copyright notice
 * appears in all copies. Please refer to the file "copyright.html"
 * for further important copyright and licensing information.
 *
 * The Java source code is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You shall
 * not disclose such Confidential Information and shall use it only in
 * accordance with the terms of the license agreement you entered into
 * with Sun.

 * SUN MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF
 * THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
 * TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
 * PARTICULAR PURPOSE, OR NON-INFRINGEMENT. SUN SHALL NOT BE LIABLE FOR
 * ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING, MODIFYING OR
 * DISTRIBUTING THIS SOFTWARE OR ITS DERIVATIVES.
 */
/*
 * @(#)Enumeration.java	1.1 1997-01-25  
 *
 */

/**
 * The Enumeration interface specifies a set of methods that may be used
 * to enumerate, or count through, a set of values. The enumeration is
 * consumed by use; its values may only be counted once.<p>
 *
 * For example, to print all elements of a Vector v:
 * <pre>
 *	for (Enumeration e = v.elements() ; e.hasMoreElements() ;) {
 *	    System.out.println(e.nextElement());
 *	}
 * </pre>
 * @see Vector
 * @see Hashtable
 * @version 	1.1 1997-01-25
 * @author	Lee Boynton
 * @author	Bruno Haible
 */
public interface StringEnumeration {
    /**
     * Returns true if the enumeration contains more elements; false
     * if its empty.
     */
    boolean hasMoreElements();

    /**
     * Returns the next element of the enumeration. Calls to this
     * method will enumerate successive elements.
     * @exception NoSuchElementException If no more elements exist.
     */
    String nextElement();
}
