/*
 * Copyright (C) 2000, 2001 by Dmitry Morozhnikov, 
 * under the terms of the GNU General Public License, version 2.
 */

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <sysexits.h>
#include <assert.h>
#include <ctype.h>

unsigned char *quotestrn(unsigned char *str, int len, char q)
{
	static unsigned char *buf = NULL;
	static int buflen = 0;
	unsigned char *pos;
	int len2 = 0;
	
	if(len >= buflen - 2)
	{
		buflen += 2048;
		buf = (unsigned char *) realloc(buf, buflen);
		assert(buf);
	};
	pos = buf;
	*pos++ = q;
	len2++;
	while(len > 0 && *str != '\0')
	{
		if(*str == q || *str == '\\')
		{
			*pos++ = '\\';
			len2++;
		};
		*pos++ = *str++;
		len2++;
		len--;
		if(len2 >= buflen - 2)
		{
			buflen += 2048;
			buf = (unsigned char *) realloc(buf, buflen);
		};
	};
	*pos++ = q;
	*pos = '\0';
	return buf;
};

unsigned char *sqlquotestrn(unsigned char *str, int len)
{
	static unsigned char *buf = NULL;
	static int buflen = 0;
	unsigned char *pos;
	int len2 = 0;
	
	if(len >= buflen - 2)
	{
		buflen += 2048;
		buf = (unsigned char *) realloc(buf, buflen);
		assert(buf);
	};
	pos = buf;
	*pos++ = '\'';
	len2++;
	while(len > 0 && *str != '\0')
	{
		if(*str == '\'')
		{
			*pos++ = '\'';
			len2++;
		};
		*pos++ = *str++;
		len2++;
		len--;
		if(len2 >= buflen - 2)
		{
			buflen += 2048;
			buf = (unsigned char *) realloc(buf, buflen);
		};
	};
	*pos++ = '\'';
	*pos = '\0';
	return buf;
};

void stripspaces(unsigned char *str)
{
	unsigned char *p;
	p = str + strlen(str);
	p--;
	while(*p == ' ' && p >= str)
	{
		*p-- = '\0';
	};
};

int isdigits(char *str)
{
	while(*str)
	{
		if(!isdigit(*str++))
		  return 0;
	};
	return 1;
};
