/*
 * Copyright (C) 2000, 2001 by Dmitry Morozhnikov, 
 * under the terms of the GNU General Public License, version 2.
 */

#include <stdio.h>
#include <time.h>
#include <string.h>
#include <sysexits.h>
#include <errno.h>
#include <assert.h>
#include "datfile2.h"
#include "datview.h"

int info(dat_header_t *h, datview_opts_t *opts)
{
	struct tm *tm;
	time_t t;
	unsigned char buf[256];
	int rc;
	printf("signature:          0x%04x\n", h->filesig);
	printf("attribute:          0x%04x", h->sfatr);
	if(h->sfatr & DAT_SFATR_LOCKED) printf(", locked");
	if(h->sfatr & DAT_SFATR_OWNED) printf(", owned");
	if(h->sfatr & DAT_SFATR_ENCRYPTED) printf(", encrypted");
	if(h->sfatr & DAT_SFATR_MEMO) printf(", has memo");
	if(h->sfatr & DAT_SFATR_COMPRESS) printf(", compressed");
	if(h->sfatr & DAT_SFATR_DELETED) printf(", has deleted records");
	if(h->sfatr & DAT_SFATR_RO) printf(", read only");
	if(h->sfatr & DAT_SFATR_CREATED) printf(", may be created");
	printf("\n");
	printf("keys:               %u\n", h->numbkeys);
	printf("records:            %lu\n", h->numrecs);
	printf("deleted:            %lu\n", h->numdels);
	printf("fields:             %u\n", h->numflds);
	printf("pictures:           %u\n", h->numpics);
	printf("array descs:        %u\n", h->nummars);
	printf("record length:      %u\n", h->reclen);
	printf("start of data:      0x%08lx\n", h->offset);
	printf("logical end:        %lu\n", h->logoef);
	printf("logical begin:      %lu\n", h->logbof);
	printf("first deleted:      %lu\n", h->freerec);
	printf("record name:        %.12s\n", h->recname);
	printf("memo name:          %.12s\n", h->memnam);
	printf("file name:          %.3s\n", h->filpre);
	printf("record prefix:      %.3s\n", h->recpre);
	printf("size of memo:       %u\n", h->memolen);
	printf("width of memo:      %u\n", h->memowid);
	printf("reserved:           0x%08lx\n", h->reserved);
	t = abstime(h->chgtime, opts->forcedt);
	if(t == -1)
	{
		exit(EX_DATAERR);
	};
	tm = localtime(&t);
	assert(tm);
	rc = strftime(buf, 255, "%X", tm);
	if(rc == 0)
	{
		fprintf(stderr, "Can`t strftime: %s", strerror(errno));
		exit(EX_DATAERR);
	};
	printf("last change time:   %s\n", buf);
	t = absdate(h->chgdate, opts->forcedt);
	if(t == -1)
	{
		exit(EX_DATAERR);
	};
	tm = localtime(&t);
	assert(tm);
	rc = strftime(buf, 255, "%x", tm);
	if(rc == 0)
	{
		fprintf(stderr, "Can`t strftime: %s", strerror(errno));
		exit(EX_DATAERR);
	};
	printf("last change date:   %s\n", buf);
	printf("reserved2:          0x%04x\n", h->reserved2);
	return 0;
};
