/*
 * Copyright (C) 2000, 2001 by Dmitry Morozhnikov, 
 * under the terms of the GNU General Public License, version 2.
 */

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <sysexits.h>
#include <errno.h>
#include <time.h>
#include "datfile2.h"
#include "datview.h"

char *dat_fldtype[] =
{
	"", "LONG", "REAL", "STRING",
	  "STRINGP", "BYTE", "SHORT",
	  "GROUP", "DECIMAL", ""
};

int desc(dat_header_t *h, dat_field_t *f, int fd, datview_opts_t *opts)
{
	int i, namelen;
	unsigned char name[17], *qname;
	dat_field_t fld;
	int width;
	width = 0;
	for(i = 0 ; i < h->numflds ; i++)
	{
		memcpy(&fld, &f[i], sizeof(dat_field_t));
		if(opts->group == 'n' && fld.fldtype == DAT_FLDTYPE_GROUP)
		{
			continue;
		};
		if(opts->group == 'u')
		{
			if(fld.fldtype == DAT_FLDTYPE_GROUP)
			{
				width = fld.length;
			}
			else
			{
				if(width > 0)
				{
					width -= fld.length;
					if(width < 0)
					{
						fprintf(stderr,
								"Wrong field length in position %u",
								i + 1);
						exit(EX_DATAERR);
					};
					continue;
				};
			};
		};
		if(opts->browsedesc == 0)
		{
			printf("%u:\n", i + 1);
			printf("  type:          0x%x (%s)\n", fld.fldtype,
				   dat_fldtype[fld.fldtype]);
			if(opts->strippref == 0)
			{
				printf("  name:          %.16s\n", fld.fldname);
			}
			else
			{
				printf("  name:          %.12s\n", fld.fldname + 4);
			};
			printf("  offset:        0x%04x\n", fld.foffset);
			printf("  length:        %u\n", fld.length);
			printf("  decimal sign:  %u\n", fld.decsig);
			printf("  decimal plac:  %u\n", fld.decdec);
			printf("  array num:     %u\n", fld.arrnum);
			printf("  picture num:   %u\n", fld.picnum);
		}
		else
		{
			memset(name, '\0', 17);
			if(opts->strippref == 0)
			{
				strncpy(name, fld.fldname, 16);
				namelen = 16;
			}
			else
			{
				strncpy(name, fld.fldname + 4, 12);
				namelen = 12;
			};
			if(opts->nostripsp != 1)
			{
				stripspaces(name);
			};
			if(opts->quotestr == 1)
			{
				qname = quotestrn(name, namelen, opts->quotechar);
			}
			else
			{
				qname = name;
			};
			if(i == 0)
			{
				printf("%s", qname);
			}
			else
			{
				printf("%c%s", opts->separator, qname);
			};
			if(i + 1 >= h->numflds)
			{
				printf("\n");
			};
		};
	};
	return 0;
};
