/*
 * Copyright (C) 2000, 2001 by Dmitry Morozhnikov, 
 * under the terms of the GNU General Public License, version 2.
 */

#ifndef _DATVIEW_H
# define _DATVIEW_H

struct _datview_opts_t
{
	int strippref;
	int browsedesc;
	int quotestr;
	int quotedt;
	char quotechar;
	int nostripsp;
	char separator;
	char group;
	char deleted;
	char locked;
	int nostripzdec;
	int showdot;
	int unixdt;
	int forcedt;
	char datefmt;
	int ignsign;
	int withmemo;
	int cutmemo;
	int sqlquote;
};
typedef struct _datview_opts_t datview_opts_t;

struct _dat_field_int_t
{
	int isdate;
	int istime;
};
typedef struct _dat_field_int_t dat_field_int_t;

extern time_t abstime(unsigned long clartime, int force);
extern time_t absdate(unsigned long clardate, int force);

extern unsigned char *quotestrn(unsigned char *str, int len, char q);
extern unsigned char *sqlquotestrn(unsigned char *str, int len);
extern void stripspaces(unsigned char *str);
extern int isdigits(char *str);

extern int info(dat_header_t *h, datview_opts_t *opts);

extern int desc(dat_header_t *h, dat_field_t *f, 
				int fd, datview_opts_t *opts);

extern int browse(dat_header_t *h, dat_field_t *f, datview_opts_t *opts,
				  int fd, int memofd, dat_field_int_t *fint);

extern int memo_info(int fd, datview_opts_t *opts);

extern unsigned char *memo_read(dat_header_t *h, int fd, int memo_no, 
								datview_opts_t *opts);

#endif /* _DATVIEW_H */
