/*
 * Copyright (C) 2000, 2001 by Dmitry Morozhnikov, 
 * under the terms of the GNU General Public License, version 2.
 */

#include <stdio.h>
#include <time.h>
#include <errno.h>
#include <string.h>
#include "datfile2.h"

time_t abstime(unsigned long clartime, int force)
{
	if(clartime > 8640000)
	{
		if(!force)
		{
			fprintf(stderr, "Wrong clartime: %#08lx\n", clartime);
			return (time_t) -1;
		}
		else
		{
			return 0;
		};
	};
	clartime--;
	return clartime / 100;
};

time_t absdate(unsigned long clardate, int force)
{
	int year, month, day;
	time_t date;
	static int year_months[] =
	{ 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
	static struct tm tm;
	struct tm *tm1;
	if(clardate < 3 || clardate > 109211)
	{
		if(!force)
		{
			fprintf(stderr, "Wrong clardate: %#08lx\n", clardate);
			return (time_t) -1;
		}
		else
		{
			return 0;
		};
	};
	if(clardate > 36527)
	{
		clardate -= 3;
	}
	else
	{
		clardate -= 4;
	};
	year = (1801 + (4 * (clardate / 1461)));
	clardate %= 1461;
	if(clardate != 1460)
	{
		year += (clardate / 365);
		day = clardate % 365;
	}
	else
	{
		year += 3;
		day = 365;
	};
	if(year % 4 == 0 && (year % 100 != 0 || year % 400 == 0))
	{
		year_months[1] = 29;
	}
	else
	{
		year_months[1] = 28;
	};
	if(year > 100)
	{
		year -= 1900;
	};
	for(month = 0 ; month < 12 ; month++)
	{
		day -= year_months[month];
		if(day < 0)
		{
			day += (year_months[month] + 1);
			break;
		};
	};
	memset(&tm, '\0', sizeof(struct tm));
	date = time(NULL);
	tm1 = localtime(&date);
	if(!tm1)
	{
		fprintf(stderr, "Can`t get localtime: %s\n", strerror(errno));
		return (time_t) -1;
	};
	tm.tm_isdst = tm1->tm_isdst;
	tm.tm_mday = day;
	tm.tm_mon = month;
	tm.tm_year = year;
	date = mktime(&tm);
	return date;
};
