# ----------------------------------------------------------------------------
# Makefile for building AWK-to-C Translator/Driver for WIN32 with Visual C++ 
# ---------------------------------------------------------------------------- 


# For MSC 5.1
#DEFS = -D_MSC_VER=510

# MSC 6.00A has _MSC_VER predefined
#DEFS =

DEFS = $(DEFS) -DMSDOS -DENV_16bit

#DEBUG = -W3 -Zi -Od
DEBUG=

MODEL = L
CC=cl -nologo -A$(MODEL)
O=.obj

# Disable MSC extensions with -Za so that __STDC__ is defined for MSC 6.00A
# MSC 5.1 defines __STDC__=0 regardless of the ANSI flag
CFLAGS = $(DEFS) $(DEBUG) -Ox -O2 

LIBS = /NOD:$(MODEL)libce $(MODEL)libcer.lib

 
# Object files definitions

AWKOBJS = main$O eval$O eval2$O builtin$O msg$O iop$O io$O field$O array$O \
	node$O version$O missing$O re$O getopt$O getopt1$O

AWKOBJS_DRIVER = driver$O eval2$O builtin$O msg$O iop$O io$O field$O array$O \
        node$O version$O missing$O re$O getopt$O getopt1$O a2c_cprg$O

OBJ_DOS = getid$O popen$O

GNUOBJS = regex$O dfa$O
 
ALLOBJS = $(AWKOBJS) $(GNUOBJS) awktab$O $(OBJ_DOS)

ALLOBJS_DRIVER = $(AWKOBJS_DRIVER) $(GNUOBJS) awktab2$O $(OBJ_DOS)


# Rules and dependencies

.SUFFIXES: $O .c .y

.c$O:
	$(CC) $(CFLAGS) -DGAWK -DHAVE_CONFIG_H -c $<

all: awk2c.exe  

awk2c.exe: $(ALLOBJS)
	link @obj_a2c.lnk, $@,,$(LIBS) /NOE /st:30000

driver.exe: $(ALLOBJS_DRIVER)
	link @obj_drvr.lnk, $@,,$(LIBS) /NOE /st:30000

$(AWKOBJS) awktab2$O driver$O a2c_cprg$O : awk.h config.h

dfa$O: awk.h config.h dfa.h

regex$O: awk.h config.h regex.h 

main$O driver$O: patchlev.h

getopt$O getopt1$O:	getopt.h


 A bug in ndmake requires the following rule
awktab$O: awk.h awktab.c
	$(CC) $(CFLAGS) -DGAWK -c awktab.c
awktab2$O: awk.h awktab2.c
	$(CC) $(CFLAGS) -DGAWK -c awktab2.c

#awktab.c: awk.y
#	bison -o $@ awk.y

clean:
	rm -f *.o *.obj core awk.output gmon.out make.out y.output

.PHONY: test
test:
	@echo Both dmake and GNU make require modifications to test/Makefile,
	@echo but here we go...
	cd test && $(MAKE) -k
