# ----------------------------------------------------------------------------
# Makefile for building AWK-to-C Translator/Driver for DOS32 with Watcom C/C++ 
# ---------------------------------------------------------------------------- 

DEFS = -DMSDOS -DWATC -D_MSC_VER=1000 -DENV_32bit

DEBUG=

CC=wcl386
O=.obj

CFLAGS = $(DEFS) $(DEBUG) -l=dos4g -cc -oetx -zp4 -fpi87 -fp5 -5r -5s

LIBS =

 
# Object files definitions

AWKOBJS = main$O eval$O eval2$O builtin$O msg$O iop$O io$O field$O array$O \
	node$O version$O missing$O re$O getopt$O getopt1$O

AWKOBJS_DRIVER = driver$O eval2$O builtin$O msg$O iop$O io$O field$O array$O \
        node$O version$O missing$O re$O getopt$O getopt1$O a2c_cprg$O

OBJ_DOS = getid$O popen$O

GNUOBJS = regex$O dfa$O
 
ALLOBJS = $(AWKOBJS) $(GNUOBJS) awktab$O $(OBJ_DOS)

ALLOBJS_DRIVER = $(AWKOBJS_DRIVER) $(GNUOBJS) awktab2$O $(OBJ_DOS)


# Rules and dependencies

#.SUFFIXES: $O .c .y

.c$O:
	$(CC) $(CFLAGS) -DGAWK -DHAVE_CONFIG_H -c $<

all: awk2c.exe  

awk2c.exe: $(ALLOBJS)
	$(CC) -l=dos4g -k1m -feawk2c.exe @obj_a2c.lnk 

driver.exe: $(ALLOBJS_DRIVER)
	$(CC) -l=dos4g -k1m -fedriver.exe @obj_drvr.lnk 

$(AWKOBJS) awktab2$O driver$O a2c_cprg$O : awk.h config.h

dfa$O: awk.h config.h dfa.h

regex$O: awk.h config.h regex.h 

main$O driver$O: patchlev.h

getopt$O getopt1$O:	getopt.h


# A bug in ndmake requires the following rule
#awktab$O: awk.h awktab.c
#	$(CC) $(CFLAGS) -DGAWK -c awktab.c

#awktab.c: awk.y
#	bison -o $@ awk.y

clean:
	rm -f *.o *.obj core awk.output gmon.out make.out y.output
