#define _POSIX_C_SOURCE 2
#include <ctype.h>
#include <errno.h>
#include <glob.h>
/*#include <printf.h>*/
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include <values.h>
#include <errno.h>

#ifndef __BYTE_ORDER

#ifdef BYTE_ORDER
#define __BYTE_ORDER    BYTE_ORDER
#define	__LITTLE_ENDIAN	LITTLE_ENDIAN
#define	__BIG_ENDIAN	BIG_ENDIAN
#define	__PDP_ENDIAN	PDP_ENDIAN
#else
#error __BYTE_ORDER undefined.
#endif

#endif


#include "2UTF.h"

static char version[] = "   2UTF  V" VERSION " \n";
static char blurb[] =
" © Copyright 1997, 1998, 2000 by Ričardas Čepas <rch@richard.eu.org> and others. \n"
" Copying policy: BSD style. \n"
" See file 'copyright' provided with the 2UTF distribution. \n"
" No warranty. Use at your own risk. \n";

#ifndef USE_LIBC
#define mbtowc our_mbtowc
#define wctomb our_wctomb
#endif

#ifndef CONFIG_PATHNAMES
#define CONFIG_PATHNAMES "/usr/local/etc/2UTF.config /usr/etc/2UTF.config /etc/2UTF.config"
#endif

#define max_string_length 1178
#ifndef ALIASES
#define ALIASES "/var/local/lib/2UTF.aliases"
#endif
#ifndef PATH
#define PATH "/usr/local/share/i18n/charmaps/"
#endif
#ifndef PATH2
#define PATH2 "/usr/share/i18n/charmaps/"
#endif
#ifndef PATH3
#define PATH3 "/usr/share/i18n/charmap/"
#endif
#ifndef MAX_PATHNAMES
#define MAX_PATHNAMES 24
#endif
#ifndef MAX_EXT_CHARSETS
#define MAX_EXT_CHARSETS 50
#endif
char aliases_pathname[] = ALIASES;
char default_charmap_format[] = " %*s /x%2x <U%X> ";
char *charmap_format[] =
{default_charmap_format, " 0x%x 0x%X ", " 0x%x 0x%X "};
unsigned char *compiled_paths[] =
{PATH, PATH2, PATH3, ""};
const int compiled_paths_number = 3;
int paths_number = 3;
unsigned char *read_paths[MAX_PATHNAMES];
unsigned char **paths = compiled_paths;
int ext_charsets_number = 0;
const char FILENAME[] = "FILENAME";
const char IO_err[] = "I/O error.";
const char IO_err_reading_config[] = "I/O error reading configuration file.";
const char add_iconv_only[] = "This option can only be used with --iconv=only.";
const char ambig_opt[] = "ambiguous option.";
const char avail_charmaps[] = "charmaps and aliases I can handle beyond iconv(3) and available in cache:";
const char avail_ext_charsets[] = "charsets I can handle via external filters:";
const char bad_charmap_format[] = "charmap file format error ?";
const char bad_line[] = "BAD LINE in aliases file:";
const char buffer_overflow[] = "buffer overflow by";

/*const char bad_sscanf_format_string[]= "bad sscanf(3) format string"; */
const char can_not_exec[] = "can't execute such command or fork subprocess:";
const char can_not_find_alias[] = "can't find such alias:";
const char can_not_open[] = "can't open for reading file";
const char can_not_open_any[] = "    -- can't open matching files.";
const char can_not_create[] = "can't create file";
const char for_[] = "for";
const char help[] = "%s"
"  Converts char-sets to and from Unicode. Decodes MIME text messages. \n"
"\n"
"  Usage: \n"
"2UTF [-short_options] [--long_option ...] [charmap_file_or_alias] <input >output \n"
"fromUTF ... \n"
"  If exact match for <charmap_file_or_alias> (converted to uppercase, \n" \
"`-' and '_' ignored) isn't found *<charmap_file_or_alias>* glob pattern \n" \
"is used. Without <charmap_file_or_alias> mail message is assumed.\n"
"  Options: \n"
" --   stops option checking for the rest of the command line \n"
" -2 --UCS-2 --ucs-2              2 byte wide characters \n"
" -4 --UCS-4 --ucs-4              4 byte wide characters \n"
/*" -w --UCS-wchar_t --ucs-wchar_t  sizeof(wchar_t) byte wide characters \n" */
" -8 --UTF-8 --utf-8    (default) multibyte characters \n"
" -C --create-aliases             (re)creates aliases database \n"
" -c FILENAME  --charmap-file=FILENAME \n"
" -d[N] --debug[=N]               debug level (1-9), default 1 \n"
" -f[FORMAT] --format[=FORMAT]    sscanf(3) format string for reading charmap \n"
"file. Lines beginning with %% or # are ignored. Default is \"%s\" \n"
" -e --encode-headers             reencode MIME encoded headers \n"
" -o --forward      (default for 2UTF) converts to Unicode \n"
" -H --html                       &<>\" appeared after approximations are escaped\n"
" -h -? --? -help --help          this help \n"
" -i only --iconv=only            don't read configuration file and use iconv() only \n"
" -i first --iconv=last           attempt to use iconv before or after charmap files \n"
" -l --list-charmaps              lists charmaps & aliases and exits \n"
" -p --pathnames                  outputs various pathnames and directories \n"
" -r --reverse      (default for fromUTF) tries convert back to the legacy encodings \n"
" -W --show-charmap               shows glyphs in charmap order \n"
" -S --spit-glyphs                shows glyphs in console font (F000-F1FF) \n"
" -S... --spit-glyphs=[min][-][max]  shows glyphs at given hex range. \n"
"Allowed range is from 0 to 7FFFFFFF. \n"
" -s --switch-to-UTF-8            outputs <ESC>%%G to stderr for switching \n"
"current virtual terminal to UTF-8 mode \n"
" -u[X]   --unknown-char[=X]      substitute X for unknown characters. \n"
"Default is '%c' (0x%.2X). \n"
" -v --verbose  \n"
" -V --version --blurb            shows version and copyright info. \n"
"  Rightmost option takes precedence. Long options may be abbreviated. \n"
;
const char incomplete_charmap[] = "warning: incomplete charmap definiton";
const char internal_err[] = "internal error ?";
const char long_file[] = "warning: long charmap file.";
const char another_match[] = "warning: another match for this alias";
const char more_help[] = "``2UTF -h'' gives more information. \n";
const char multiply_matches[] = "warning: multiply matches for glob pattern";
const char needs_update[] = "aliases database needs update.";
const char no_charmaps[] = "no charmap files found.";
const char no_pathnames[] = "no pathnames found in configuration file.";
const char out_of_mem[] = "out of memory !";
const char paths_help_config_pathname[] = " Looks for configuration file as: \n";
const char paths_help_compiled[] = " If no directories in configuration file " \
"are found looks for charmap files in: \n";
const char paths_help_used[] = " Currently looks for charmap files in: \n";
const char paths_help_aliases[] =
"  Aliases are cached in: \n"
"``" ALIASES "'' \n"
"  \n";
const char short_help[] = \
"Usage: 2UTF|fromUTF [-short_options] [--long_option ...] [charset] <in >out \n";
const char too_many_pathnames[] = "too many pathnames in configuration file.";
const char too_many_ext_charsets[] = \
"too many charset definitions in configuration file.";
const char unexp_EOF[] = "unexpected end of file.";
const char unimplemented[] = "Sorry, this is not implemented.";
const char unknown_opt[] = "unknown option.";
const char using[] = "using";
const char will_use[] = "will use";
int Debug = FALSE, Mail = FALSE, encode = FALSE, iconv_first = TRUE, iconv_only = FALSE, reverse = FALSE, show_charmap = FALSE, verbose = FALSE;
/* stdout may be variable */
struct charset_type
unknown_charset = {NULL, "", NO, UNKNOWN, NULL, NULL},
USASCII_charset = {NULL, "us-ascii", IS, USASCII, NULL, NULL},
UTF8_charset = {NULL, "UTF-8", IS, UTF8, NULL, NULL};
struct charset_type *charset_p = &unknown_charset;
struct line_buf_type line =
{NULL, 0};
struct
{
  unsigned char *names, *to_UTF, *from_UTF;
  enum USASCII_is_subset_type USASCII_is_subset;
}
ext_charsets[MAX_EXT_CHARSETS + 1];
wchar_t unknown_wchar = 0xFFFD;

inline int our_wctomb (char *s, unsigned long wc);
inline int our_mbtowc (wchar_t *p, char *s, unsigned n);

  inline enum charmap_file_format_type
Charmap_file_format_type (char *pathname)
{
  char *ptr;

  if (pathname && (ptr = strrchr (pathname, '.')))
  {
    if (strcmp (".TXT", ptr) == 0 || Strcasecmp (".x", ptr) == 0)
      return (TXT);
  }
  return (DEFAULT);
}

  void
Close_pipe (void)
{
  if (charset_p->type == BUF_PIPE || charset_p->type == NON_BUF_PIPE)
    pclose (charset_p->pipe);
}


  char *
Convert (char *to, char *from)
{
  register int length;

  if (charset_p->type == KNOWN)
  {
    while (*from)
    {
      length = wctomb (to, charset_p->charmap[(int) (unsigned char) *from]);
      if (length != -1)
	to += length;
      else if (*(to += wctomb (to, unknown_wchar)) == -1)
	Error ("Bad unknown_wchar value");
      from++;
    }
    return (to);
  }
  else
    return (Stpcpy (to, from));
}

  char *
Encode_MIME_word (char *from, size_t sz)
{
  unsigned char *f, *t, *to;
  const char b64[64] = {
    'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z',
    'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z',
    '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'
  };

  /* =?UTF-8?B?..?= */
  to = xmalloc(24 + 4*strlen(f=from) / 3);
  strcpy(to, "=?UTF-8?B?");
  t = to + 10;
  while (sz)
  {
    /* 765432 10:7654 3210:76 543210
       543210 54:3210 5432:10 543210
     */
    *t++ = b64[*f>>2 & (1<<6)-1];
    if (sz == 1) {
      *t++ = b64[(*f & (1<<2)-1) << 4];
      *t++ = '=';
      *t++ = '=';
      sz=0;
    } else {
      *t++ = b64[(*f & (1<<2)-1) << 4 | f[1] >> 4];
      if (sz == 2) {
	*t++ = b64[(f[1] & (1<<4)-1) << 2];
	*t++ = '=';
	sz=0;
      } else {
	*t++ = b64[(f[1] & (1<<4)-1) << 2 | f[2] >> 6];
	*t++ = b64[f[2] & (1<<6)-1];
	sz -= 3;
	f += 3;
      }
    }
  }
  strcpy(t, "?=");
  return (to);
}

  int
Create_aliases (void)
{
  FILE *aliases_file;
  struct charmap_file_type charmap_file;
  char alias[max_string_length], *charmap_filename, *ptr, *pathname, s[max_string_length];

  glob_t glob_buffer =
  {0, NULL, 0, 0};
  int glob_flags = 0, length;
  register int c, index;
  wchar_t charmap[256], unknown_wchar = 0;

  if ((aliases_file = fopen (aliases_pathname, "wt")) == NULL)
  {
    /*      fprintf (stderr, "2UTF: %s '%s' \n", can_not_create, aliases_pathname); */
    return (0);
  }
  for (length = strlen (paths[0]), index = 1; index < paths_number; index++)
    if (strlen (paths[index]) > strlen (paths[index - 1]))
      length = strlen (paths[index]);
  pathname = xmalloc (length + 5);
  if (Debug >= 9)
    fprintf (stderr, "2UTF: malloc (%i) \n", (length + 5));
  for (index = 0; index < paths_number; index++)
  {
    strcat (strcpy (pathname, paths[index]), "*");
    c = glob (pathname, glob_flags, NULL, &glob_buffer);
    glob_flags |= GLOB_APPEND;
    switch (c)
    {
      case GLOB_NOSPACE:
	Error (out_of_mem);
      default:
	if (Debug >= 5)
	  fprintf (stderr, "2UTF: glob() returned %i \n", c);
    }
  }
  free (pathname);

  if (glob_buffer.gl_pathc < 1)
    Error (no_charmaps);
  for (index = 0; index < glob_buffer.gl_pathc; index++)
  {
    if ((charmap_file.stream = fopen (glob_buffer.gl_pathv[index], "rt")) == NULL)
    {
      if (verbose)
	fprintf (stderr, "2UTF: %s '%s' \n", can_not_open, glob_buffer.gl_pathv[index]);
    }
    else
    {
      charmap_file.format = Charmap_file_format_type (glob_buffer.gl_pathv[index]);
      c = Get_charmap (charmap, &charmap_file, unknown_wchar);
      switch (c)
      {
	case err_short:
	  if (verbose)
	    fprintf (stderr, "2UTF: %s: \n       '%s' \n", incomplete_charmap, glob_buffer.gl_pathv[index]);
	case err_long:
	  if (Debug >= 8 && c == err_long)
	    fprintf (stderr, "2UTF: %s '%s' \n", long_file, glob_buffer.gl_pathv[index]);
	case OK:
	  if (verbose)
	    fprintf (stderr, "2UTF: %s '%s' \n", using, glob_buffer.gl_pathv[index]);
	  if ((ptr = strrchr (glob_buffer.gl_pathv[index], '/')) == NULL)
	    ptr = glob_buffer.gl_pathv[index];
	  else
	    ptr++;
	  charmap_filename = xstrdup (ptr);
	  if (charmap_file.format != DEFAULT &&strrchr (charmap_filename, '.'))
	    *strrchr (charmap_filename, '.') = '\0';
	  fprintf (aliases_file, "%s %s ", glob_buffer.gl_pathv[index], Strtoupper (charmap_filename));
	  rewind (charmap_file.stream);
	  while (fgets (s, max_string_length, charmap_file.stream) != NULL)
	    if (s[0] == '%' && sscanf ((s + 1), " alias %s ", alias) >= 1)
	      fprintf (aliases_file, "%s ", Strtoupper (alias));
	  fputs (" \n", aliases_file);
	  if (!feof (charmap_file.stream))
	    fprintf (stderr, "\a2UTF: %s '%s' \n", IO_err, glob_buffer.gl_pathv[index]);
	  break;
	case err_few_chars:
	  if (verbose)
	    fprintf (stderr, "2UTF: %s '%s' \n", bad_charmap_format, glob_buffer.gl_pathv[index]);
	  break;
	case err_IO:
	  fprintf (stderr, "\a2UTF: %s '%s' \n", IO_err, glob_buffer.gl_pathv[index]);
	  break;
	case err_internal:
	  fprintf (stderr, "\a2UTF: %s '%s' \n", internal_err, glob_buffer.gl_pathv[index]);
	  break;
      }
      if (EOF == fclose (charmap_file.stream))
	Error (IO_err);
    }
  }
  if (EOF == fclose (aliases_file))
    Error (IO_err);
  globfree (&glob_buffer);
  return (1);
}

  void
Error (const char *message)
{
  register int c;

  fprintf (stderr, "2UTF: %s \n", message);
  if (Mail)
    while ((c = getc (stdin)) != EOF)
      putchar (c);
  exit (1);
}

inline  FILE *
Fopen_charmap (struct charset_type *charset_p, struct charmap_file_type *charmap_file_p)
{
  FILE *aliases_file;
  char *charmap_name, *pathname, *ptr, *s = NULL;
  glob_t glob_buffer =
  {0, NULL, 0, 0};
  int found_alias = FALSE, can_not_create_aliases_file = FALSE;
  register int c, index, length;
  size_t s_length = 0;

  charmap_file_p->stream = NULL;
  charmap_file_p->format = DEFAULT;
  if (strchr (charset_p->name, '/') != NULL)
  {
    charmap_file_p->stream = fopen (charset_p->name, "rt");
    charmap_file_p->format = Charmap_file_format_type (charset_p->name);
  } else {
    if ((aliases_file = fopen (aliases_pathname, "rt")) == NULL)
    {
      fprintf (stderr, "2UTF: %s %s \n", can_not_open, aliases_pathname);
      if (!Create_aliases ())
      {
	can_not_create_aliases_file = 1;
	fprintf (stderr, "2UTF: %s '%s' \n", can_not_create, aliases_pathname);
      }
      else if ((aliases_file = fopen (aliases_pathname, "rt")) == NULL)
	Error (internal_err);
    }
    charmap_name = xmalloc (strlen (charset_p->name) + 5);
    if (Debug >= 9)
      fprintf (stderr, "2UTF: malloc (%i) \n", (int)(strlen (charset_p->name) + 5));
    Strtoupper (strcat (strcat (strcpy (charmap_name, " "), charset_p->name), " "));
    if (aliases_file != NULL)
    {
      for (index = 0; index < 2; index++)
      {
	if (Debug >= 3)
	  fprintf (stderr, "2UTF: Looking for alias '%s' \n", charmap_name);
	while (Getline ((unsigned char **) &s, &s_length, aliases_file) != (size_t) -1)
	  if ((strchr (s, ' ') != NULL) && (Str_str (strchr (s, ' '), charmap_name) != NULL))
	  {
	    strtok (s, "\n");
	    if (!found_alias)
	    {
	      if (verbose)
		fprintf (stderr, "2UTF: %s - %s: \n   '%s' \n",
		    charmap_name, will_use, s);
	      charmap_file_p->stream = fopen (ptr = strtok (s, " "), "rt");
	      charmap_file_p->format = Charmap_file_format_type (ptr);
	    }
	    else if (verbose)
	      fprintf (stderr, "2UTF: %s - %s: \n   '%s' \n",
		  charmap_name, another_match, s);
	    else
	      fprintf (stderr, "2UTF: %s. \n", another_match);
	    found_alias = 1;
	  }
	if (!feof (aliases_file))
	  if (ferror (aliases_file))
	    Error (IO_err);
	  else
	    Error (out_of_mem);
	if (!found_alias)
	{
	  if (index == 0)
	  {
	    clearerr (aliases_file);
	    rewind (aliases_file);
	    memmove (charmap_name, &charmap_name[1], strlen (charmap_name) - 1);
	    strtok (charmap_name, " ");
	  }
	}
	else
	  break;
      }
      free (s);
      if (EOF == fclose (aliases_file))
	Error (IO_err);
    }
    if (!found_alias || charmap_file_p->stream == NULL)
    {
      if (charmap_name[0] == ' ')
      {
	memmove (charmap_name, &charmap_name[1], strlen (charmap_name) - 1);
	strtok (charmap_name, " ");
      }
      if (Debug >= 3)
	fprintf (stderr, "2UTF: Looking for file '%s' \n", charmap_name);
      for (length = strlen (paths[0]), index = 1; index < paths_number; index++)
	if (strlen (paths[index]) > strlen (paths[index - 1]))
	  length = strlen (paths[index]);
      pathname = xmalloc (length + strlen (charmap_name) + 5);
      if (Debug >= 9)
	fprintf (stderr, "2UTF: malloc (%i) \n", (int)(length + strlen (charmap_name) + 5));
      for (index = 0; index < paths_number; index++)
      {
	strcat (strcpy (pathname, paths[index]), charmap_name);
	if (Debug >= 3)
	  fprintf (stderr, "2UTF: Looking for '%s' \n", pathname);
	if ((charmap_file_p->stream = fopen (pathname, "rt")) != NULL)
	{
	  charmap_file_p->format = Charmap_file_format_type (pathname);
	  if (verbose)
	    fprintf (stderr, "2UTF: %s '%s' \n", using, pathname);
	  break;
	}
      }
      if (charmap_file_p->stream == NULL)
      {
	for (index = 0; index < paths_number; index++)
	{
	  strcat (strcpy (pathname, paths[index]), "*");
	  strcat (strcat (pathname, charmap_name), "*");
	  if (Debug >= 3)
	    fprintf (stderr, "2UTF: Looking for '%s' \n", pathname);
	  /*c = glob (pathname, GLOB_NOSORT, NULL, &glob_buffer); */
	  c = glob (pathname, 0, NULL, &glob_buffer);
	  switch (c)
	  {
	    case 0:
	      if (glob_buffer.gl_pathc >= 1)
	      {
		if (glob_buffer.gl_pathc >= 2)
		  fprintf (stderr, "2UTF: %s '%s' (%i). \n", multiply_matches, pathname, glob_buffer.gl_pathc);
		if ((charmap_file_p->stream = fopen (glob_buffer.gl_pathv[0], "rt")) != NULL)
		{
		  charmap_file_p->format = Charmap_file_format_type (glob_buffer.gl_pathv[0]);
		  if (glob_buffer.gl_pathc != 1)
		    fprintf (stderr, "2UTF: %s '%s' \n", using, glob_buffer.gl_pathv[0]);
		  goto break_for;
		}
		else if (verbose)
		  fprintf (stderr, "2UTF: %s '%s' \n", can_not_open, glob_buffer.gl_pathv[0]);
	      }
	      break;
	    case GLOB_NOSPACE:
	      Error (out_of_mem);
	    default:
	      if (Debug >= 5)
		fprintf (stderr, "2UTF: glob() returned %i \n", c);
	  }
	}
break_for:
	globfree (&glob_buffer);
      }
      free (pathname);
      free (charmap_name);
      if (!found_alias && verbose && charmap_file_p->stream != NULL)
	fprintf (stderr, "2UTF: %s \n", needs_update);
    }
    if (found_alias && charmap_file_p->stream == NULL)
      fprintf (stderr, "2UTF: %s \n", needs_update);
    if (((found_alias && charmap_file_p->stream == NULL) || (!found_alias && charmap_file_p->stream != NULL)) &&strcmp (charmap_format[0], default_charmap_format) == 0)
      if (!can_not_create_aliases_file)
	if (!Create_aliases ())
	{
	  if (verbose)
	    fprintf (stderr, "2UTF: %s '%s' \n", can_not_create, aliases_pathname);
	}
	else if ((aliases_file = fopen (aliases_pathname, "rt")) == NULL)
	  Error (internal_err);
	else if (EOF == fclose (aliases_file))
	  Error (IO_err);
  }
  return (charmap_file_p->stream);
}

/* Bits  Hex Min  Hex Max  Byte Sequence in Binary
 *   7  00000000 0000007f 0vvvvvvv
 *  11  00000080 000007FF 110vvvvv 10vvvvvv
 *  16  00000800 0000FFFF 1110vvvv 10vvvvvv 10vvvvvv
 *  21  00010000 001FFFFF 11110vvv 10vvvvvv 10vvvvvv 10vvvvvv
 *  26  00200000 03FFFFFF 111110vv 10vvvvvv 10vvvvvv 10vvvvvv 10vvvvvv
 *  31  04000000 7FFFFFFF 1111110v 10vvvvvv 10vvvvvv 10vvvvvv 10vvvvvv 10vvvvvv
 */
  inline int
Freadmb (wchar_t * wchar_p, FILE * stream)
{
  char mb[6];
  register int length, i, c;

  if ((c = getc (stream)) == EOF)
    return (EOF);
  else if ((c & 0x80) == 0)
  {
    *wchar_p = c;
    return (1);
  }
  else if ((c & 0x40) == 0)
    return (0);
  else if ((c & 0x20) == 0)
    length = 2;
  else if ((c & 0x10) == 0)
    length = 3;
  else if ((c & 0x8) == 0)
    length = 4;
  else if ((c & 0x4) == 0)
    length = 5;
  else if ((c & 0x2) == 0)
    length = 6;
  else
    return (0);
  mb[0] = c;
  for (i = 1; i < length; i++)
  {
    if ((c = getc (stream)) == EOF)
      return (EOF);
    else if ((c & 0xC0) != 0x80)	/* !=10xx xxxx */
    {
      ungetc (c, stream);
      return (0);
    }
    else
    {
      mb[i] = c;
    }
  }
  if (mbtowc (wchar_p, mb, length) != length)
    return (0);
  else
    return (1);
}

extern size_t Getdelim (unsigned char **linebuf_p, size_t *bufsize_p, int delimiter, FILE *stream)
{
  size_t current_ind = 0;
  int c;

  do
  {
    if (*bufsize_p <= current_ind + 10)
      *linebuf_p = xrealloc (*linebuf_p, *bufsize_p += 256);
    if ((c = getc (stream)) == EOF || ((*linebuf_p)[current_ind++] = c) == delimiter)
      break;
  }
  while (TRUE);
  (*linebuf_p)[current_ind] = '\0';
  return (current_ind ? current_ind : -1);
}

int
Get_charmap (wchar_t * charmap, struct charmap_file_type *charmap_file_p, wchar_t unknown_wchar)
{
  char s[max_string_length];
  int index;

  if (charmap_file_p->stream == NULL)
    return (err_internal);
  for (index = 0; index < 256; index++)
    charmap[index] = unknown_wchar;
  for (index = 0; index < MAXINT; index++)
  {
    do
      if (fgets (s, max_string_length, charmap_file_p->stream) == NULL)
	if (feof (charmap_file_p->stream))
	  if (index < 20)
	    return (err_few_chars);
	  else if (index < 256)
	    return (err_short);
	  else if (index == 256)
	    return (OK);
	  else
	    return (err_long);
	else
	  return (err_IO);
    while (!Parse_string (charmap_format[charmap_file_p->format], charmap, s));
  }
  return (err_internal);
}

  void
Help (unsigned char default_unknown_char)
{

  fprintf (stderr, help, version, charmap_format[DEFAULT], default_unknown_char, (unsigned int) default_unknown_char);

}

void
Long2short_options (int argc, char **argv, const struct long2short_options_type *long2short_options)
{
  char *equal_ptr;
  int arg, long_opt_ind, matched_long_opt;

  for (arg=1; arg < argc; arg++)
  {
    if (argv[arg][0]=='-')
      if (argv[arg][1]=='-')
      {
	if (argv[arg][2]=='\0')
	  break;
	if ((equal_ptr=strchr (argv[arg], '=')))
	  *(equal_ptr) = '\0';
	matched_long_opt = -1;
	for (long_opt_ind=0; long2short_options[long_opt_ind].long_option!=NULL; long_opt_ind++)
	{
	  if (Str_has_prefix (long2short_options[long_opt_ind].long_option, argv[arg]+2)==0)
	    if (matched_long_opt == -1)
	      matched_long_opt = long_opt_ind;
	    else if (long2short_options[long_opt_ind].short_option != long2short_options[matched_long_opt].short_option)
	    {
	      fprintf (stderr, "2UTF: '%s' - %s \n", argv[arg], ambig_opt);
	      exit (1);
	    }
	}
	if (matched_long_opt == -1)
	{
	  fprintf (stderr, "2UTF: '%s' - %s \n", argv[arg], unknown_opt);
	  exit (1);
	}
	else
	{
	  *(argv[arg]+1)=long2short_options[matched_long_opt].short_option;
	  if (equal_ptr)
	    memmove (argv[arg]+2, equal_ptr+1, strlen (equal_ptr+1) + 1);
	  else
	    *(argv[arg]+2)='\0';
	}
      }
      else if (argv[arg][1]=='?') argv[arg][1]='h';
      else if (strcmp (argv[arg]+1, "help")==0)
	argv[arg][1]='h', argv[arg][2]='\0';
  }
}

#define Print_approx_Macro(c, wchar, unknown_char) \
{ \
  /*#include "approx.c"*/ \
    int index = 257; \
    \
    if ((wchar) != 0xFEFF) /* skip byte order mark */ \
    { \
      if ((c) == 1) \
      { \
	for (index = 0; index < 256; index++) \
	  if (charset_p->charmap[index] == (wchar)) \
	  { \
	    if (putc (index, charset_p->pipe) == EOF) \
	      Error (IO_err); \
		break; \
	  } \
      } \
      if (index >= 256) \
	if ((size_t) (wchar) \
	    <NUM_OF_ELEM (approx2ascii) \
	    &&approx2ascii[wchar][0] != '\0') \
	{ \
	  for (index = 0; approx2ascii[wchar][index] != '\0' \
	      && index < (int) NUM_OF_ELEM (approx2ascii[0]); index++) \
	    if (charset_p->charmap[approx2ascii[wchar][index]] \
		!=approx2ascii[wchar][index]) \
	    { \
	      index = -1; \
		break; \
	    }			/* check for non US-ASCII compatibles */ \
	  if (index != -1) \
	    if (html_doc) \
	      for (index = 0; approx2ascii[wchar][index] != '\0' \
		  && index < (int) NUM_OF_ELEM (approx2ascii[0]); index++) \
		Putchar_html_Macro (approx2ascii[wchar][index]) \
	    else \
	      fprintf (charset_p->pipe, "%.*s", \
		  (int) NUM_OF_ELEM (approx2ascii[0]), approx2ascii[wchar]); \
	  else if (putc (unknown_char, charset_p->pipe) == EOF) \
	    Error (IO_err); \
	} \
	else if (putc (unknown_char, charset_p->pipe) == EOF) \
	  Error (IO_err); \
    } \
}

/*if ((((int)some) < 0x20) || ((((int)some) > 0x7F) && (((int)some) < 0xA0)))*/
#define Putchar_html_Macro(some) \
{ \
  int exit_code; \
    \
    switch (some) \
    { \
      case '"': \
		exit_code = fputs("&quot;", charset_p->pipe); \
		  break; \
      case '&': \
		exit_code = fputs("&amp;", charset_p->pipe); \
		  break; \
      case '<': \
		exit_code = fputs("&lt;", charset_p->pipe); \
		  break; \
      case '>': \
		exit_code = fputs("&gt;", charset_p->pipe); \
		  break; \
      default: \
	       exit_code = putc(some, charset_p->pipe); \
    } \
  if (exit_code == EOF) \
    Error (IO_err); \
}

  void
Print_paths (void)
{
  int i;
  unsigned char *config_pathname = CONFIG_PATHNAMES;

  fprintf (stderr, paths_help_config_pathname);
  do
    fprintf (stderr, "'%s' \n", config_pathname);
  /* check for double null terminator */
  while (*(config_pathname = strchr (config_pathname, '\0') + 1) != '\0');

  fprintf (stderr, paths_help_compiled);
  for (i = 0; i < compiled_paths_number; i++)
    fprintf (stderr, "'%s' \n", compiled_paths[i]);

  fprintf (stderr, paths_help_used);
  for (i = 0; i < paths_number; i++)
    fprintf (stderr, "'%s' \n", paths[i]);

  fprintf (stderr, paths_help_aliases);
}

  int
List_charmaps ()
{
  FILE *aliases_file;
  char *ptr, s[max_string_length];
  int index;

  if ((aliases_file = fopen (aliases_pathname, "rt")) == NULL)
  {
    fprintf (stderr, "2UTF: %s %s", can_not_open, aliases_pathname);
    if (!Create_aliases ())
      fprintf (stderr, "2UTF: %s '%s' \n", can_not_create, aliases_pathname);
    else if ((aliases_file = fopen (aliases_pathname, "rt")) == NULL)
      Error (internal_err);
  }
  if (aliases_file == NULL)
    return (0);
  fprintf (stderr, "\n2UTF: %s \n\n", avail_charmaps);
  while (fgets (s, max_string_length, aliases_file) != NULL)
    if ((ptr = strchr (s, ' ')) == NULL)
      fprintf (stderr, "\n2UTF: %s '%s' \n", bad_line, s);
    else
      fprintf (stderr, "%s", ptr + 1);
  if (EOF == fclose (aliases_file))
    Error (IO_err);
  fprintf (stderr, "\n2UTF: %s \n\n", avail_ext_charsets);
  for (index = 0; index < ext_charsets_number; index++)
    fprintf (stderr, "%s \n", ext_charsets[index].names);
  return (1);
}

  inline int
Look_for_ext_charset (enum USASCII_is_subset_type USASCII_is_subset)
{
  FILE *ret;
  unsigned char *charset_name, *command_line, *cp2;
  int index;

  *(charset_name = xmalloc (strlen (charset_p->name) + 3)) = ' ';
  *(cp2 = Stpcpy (charset_name + 1, charset_p->name)) = ' ';
  *(cp2 + 1) = '\0';
  Strtoupper (charset_name);
  if (Debug >= 3)
    fprintf (stderr, "2UTF: Looking for name '%s' in configuration file \n", charset_name);
  for (index = 0; index < ext_charsets_number; index++)
  {
    if (Str_str (ext_charsets[index].names, charset_name))
    {
      charset_p->USASCII_is_subset = ext_charsets[index].USASCII_is_subset;
      if (reverse || show_charmap)
	command_line = ext_charsets[index].from_UTF;
      else
	command_line = ext_charsets[index].to_UTF;
      if (command_line == NULL)
	break;
      if (command_line[0] == '%')
      {
	command_line++;
	charset_p->type = NON_BUF_PIPE;
      }
      else
	charset_p->type = BUF_PIPE;
      if (USASCII_is_subset == IS && charset_p->USASCII_is_subset == NO)
      {
	charset_p = &USASCII_charset;
	return (TRUE);
      }
      ret = popen (command_line, "w");
      if (Debug >= 4)
	fprintf (stderr, "2UTF: popen (\"%s\", \"w\") returned %lx \n", command_line, (unsigned long int) ret);
      if (ret == NULL)
      {
	if (verbose)
	  fprintf (stderr, "2UTF: %s \n '%s' \n ", can_not_exec, command_line);
	return (EOF);
      }
      else
      {
	if (verbose)
	  fprintf (stderr, "2UTF: %s '%s' \n", using, ext_charsets[index].names);
	/* For the output of interractive programms */
	setvbuf (ret, NULL, Mail ? _IOLBF : _IONBF, 0);
	charset_p->pipe = ret;
	return (TRUE);
      }
    }
  }
  return (FALSE);
}

  inline int
Open_iconv (struct charset_type * charset_p)
{
  iconv_t h;
  char charset_name[sizeof(charset_p->name)];

  h = (iconv_t) -1;
  Stpcpy(charset_name, charset_p->name); /* some stupid iconv libraries can't cope with uppercase names */
  Strtolower(charset_name);
  if (reverse) {
    if (Debug >= 3)
      fprintf (stderr, "2UTF: Trying reverse iconv_open('%s','utf-8')\n", charset_name);
    h = iconv_open(charset_p->name, "utf-8");
  } else {
    if (Debug >= 3)
      fprintf (stderr, "2UTF: Trying iconv_open('utf-8','%s')\n", charset_name);
    h = iconv_open("utf-8", charset_name);
  }
  if (h != (iconv_t) -1) {
    charset_p->type = ICONV;
    charset_p->pipe = stdout;
    charset_p->USASCII_is_subset = NO;
    charset_p->iconv_p = xmalloc(sizeof(*(charset_p->iconv_p)));
    charset_p->iconv_p->iconv_handle = h;
    *(charset_p->iconv_p->inendptr = charset_p->iconv_p->in_buf) = *(charset_p->iconv_p->outptr = charset_p->iconv_p->out_buf) = '\0';
    charset_p->iconv_p->inleft = 0;
    if (Debug >= 2)
      fprintf (stderr, "2UTF: Got '%x' for '%s' from iconv \n", h, charset_p->name);
    return TRUE;
  } else {
    return FALSE;
  }
}

void
Output_consumed_chars (unsigned char *space_between_enc_words, unsigned char *charset_name, size_t charset_name_length, unsigned char *encoding)
{
  int index = -1;
  unsigned char *charp, *encp;

  while (space_between_enc_words[++index])
    PUTC_IN_UTF8 (space_between_enc_words[index]);
  space_between_enc_words[0] = '\0';
  charp = charset_name;
  PUTC_IN_UTF8 ('=');
  PUTC_IN_UTF8 ('?');
  while ((size_t) (charp - charset_name) < charset_name_length)
  {
    PUTC_IN_UTF8 (*charp);
    charp++;
  }
  if ((encp = encoding))
  {
    PUTC_IN_UTF8 ('?');
    while (*encp)
    {
      PUTC_IN_UTF8 (*encp);
      encp++;
    }
  }
}

  inline int
Parse_string (char *charmap_format_string, wchar_t * charmap, char *s)
{
  unsigned int index;
  unsigned long unichar;

  if (s[0] == '#' || s[0] == '%')
    return (0);
  if (sscanf (s, charmap_format_string, &index, &unichar) == 2)
  {
    charmap[index] = (wchar_t) unichar;
    if (Debug > 8)
      fprintf (stderr, "2UTF: '%s'  -->   0x%.2X is U+%.4lX.\n" ,s, index, (long unsigned int) charmap[index]);
    return (1);
  }
  else
    return (0);
}

  inline void
Pipe_to_UTF8 (FILE * in_stream)
{
  register int c;

  if (charset_p->type == ICONV)
    while ((c = getc (in_stream)) != EOF)
      Put_to_iconv_buf (c, charset_p);
  else if (charset_p->type == KNOWN)
    while ((c = getc (in_stream)) != EOF)
      Putc_in_UTF8 (c, charset_p);
  else
    while ((c = getc (in_stream)) != EOF)
      if (putc (c, charset_p->pipe) == EOF)
	Error (IO_err);
  if (charset_p->type == ICONV)
    Put_to_iconv_buf (-1, charset_p);
  if (ferror (in_stream))
    Error (IO_err);
}

  inline int
Putc_in_UTF8 (int c, struct charset_type * charset_p)
{
  char s[12];
  register int length;

  length = wctomb (s, charset_p->charmap[c]);
  if (length != -1)
  {
    if (fwrite (s, 1, length, charset_p->pipe) != (size_t) length)
      Error (IO_err);
  }
  else if (putc (0x80, charset_p->pipe) == EOF)
    Error (IO_err);
  return (c);
}

  inline int
Put_to_iconv_buf (int c, struct charset_type * charset_p)
{
  /* c == -1 means flush buffer */
  if (c>=0) {
    *charset_p->iconv_p->inendptr++ = c;
    charset_p->iconv_p->inleft++;
  }
  if (c<0 || charset_p->iconv_p->inendptr - charset_p->iconv_p->in_buf > ICONV_IN_BUF_SIZE - 10) {
    /* buffer is full - do conversion */
    size_t outleft, conv, sz;
    char * inptr;
    /* inleft = charset_p->iconv_p->in_buf + ICONV_IN_BUF_SIZE - charset_p->iconv_p->inptr; */
    outleft = charset_p->iconv_p->out_buf + ICONV_OUT_BUF_SIZE - charset_p->iconv_p->outptr;
    inptr = charset_p->iconv_p->in_buf;
    while (charset_p->iconv_p->inleft > 0) {
      errno = 0;
      conv = iconv (charset_p->iconv_p->iconv_handle, &inptr, &charset_p->iconv_p->inleft, &charset_p->iconv_p->outptr, &outleft);
      if (conv  == (size_t) -1 || errno) {
	if (errno == EINVAL) {
	  if (c<0 || Debug > 4)
	    fprintf (stderr, "2UTF: iconv error because of incomplete multibyte character; input is '%.2s'\n", inptr);
	  memmove (charset_p->iconv_p->in_buf, inptr, charset_p->iconv_p->inleft);
	  break;
	} else if (errno == EILSEQ) {
	  if (Debug>3)
	    fprintf (stderr, "2UTF: iconv EILSEQ error; input is '%.2s'\n", inptr);
	  charset_p->iconv_p->inleft--; outleft--;
	  *charset_p->iconv_p->outptr++ = *inptr++;
	  continue;
	} else {
	  /* if (Debug) */
	    fprintf (stderr, "2UTF: iconv unknown error errno %i; input is '%.2s'\n", errno, inptr);
	  memmove (charset_p->iconv_p->outptr, inptr, charset_p->iconv_p->inleft);
	  charset_p->iconv_p->inleft = 0;
	  break;
	}
      }
    }
    charset_p->iconv_p->inendptr = charset_p->iconv_p->in_buf + charset_p->iconv_p->inleft;
    if (sz = charset_p->iconv_p->outptr - charset_p->iconv_p->out_buf) {
      charset_p->iconv_p->outptr = charset_p->iconv_p->out_buf;
      if (c == -3) {
	char * enc;
	if (fputs(enc = Encode_MIME_word(charset_p->iconv_p->out_buf, sz), charset_p->pipe) < 0)
	  Error (IO_err);
	free(enc);
      } else {
	if (fwrite(charset_p->iconv_p->out_buf, sizeof(char), sz, charset_p->pipe) <= 0)
	  Error (IO_err);
      }
    }

  }
  if (c == -2)
    fflush (charset_p->pipe);
  return 1;
}

  int
Read_config_file ()
{
  FILE *config_file;
  enum
  {
    PATHS, CHARSETS
  }
  state;
  size_t size;
  unsigned char *config_pathnames = CONFIG_PATHNAMES;
  unsigned char *config_pathname = config_pathnames;
  unsigned char *cp, *cp2, *nl;

  /* check for double null terminator */
  while (*(config_pathname = strchr (config_pathname, '\0') + 1) != '\0');
  config_pathname = config_pathnames;
  do
  {
    if (Debug > 4)
      fprintf (stderr, "2UTF: Looking for '%s' \n", config_pathname);
    if ((config_file = fopen (config_pathname, "rt")) == NULL)
      if (*(config_pathname = strchr (config_pathname, '\0') + 1) == '\0')
	return (FALSE);
  }
  while (config_file == NULL);
  if (Debug > 2)
    fprintf (stderr, "2UTF: Opened configuration file '%s' \n", config_pathname);
  if ((size = Getdelim (&line.buf, &line.length, '\0', config_file)) == (size_t) -1 || EOF == fclose (config_file))
    Error (IO_err_reading_config);

  cp = line.buf;
  paths_number = 0;
  paths = read_paths;
  ext_charsets_number = 0;
  state = PATHS;
  do
  {
    if ((nl = strchr (cp, '\n')) != NULL)
      *nl = '\0';
    if (*cp != '#')
    {
      switch (state)
      {
	case PATHS:
	  if ((cp = strtok (cp, " \t\n")))
	  {
	    if (Strcasecmp (cp, "[charsets]") == 0)
	    {
	      state = CHARSETS;
	    }
	    else
	    {
	      if (paths_number >= MAX_PATHNAMES)
		Error (too_many_pathnames);
	      paths[paths_number++] = xstrdup (cp);
	      if (Debug > 2)
		fprintf (stderr, "2UTF: Pathname for charmaps in configuration file: \n '%s' \n", paths[paths_number - 1]);
	    }
	  }
	  break;
	case CHARSETS:
	  {
	    if (ext_charsets_number >= MAX_EXT_CHARSETS)
	      Error (too_many_ext_charsets);
	    ext_charsets[ext_charsets_number].USASCII_is_subset = NO;
	    if (strncmp (cp += strspn (cp, " \t"), "[US-ASCII_is_subset]", strlen ("[US-ASCII_is_subset]")) == 0)
	    {
	      cp += strlen ("[US-ASCII_is_subset]") + 1;
	      ext_charsets[ext_charsets_number].USASCII_is_subset = IS;
	    }
	    *(cp2 = ext_charsets[ext_charsets_number].names = xmalloc (strlen (cp) + 3)) = ' ';
	    *(cp2 = Stpcpy (cp2 + 1, cp)) = ' ';
	    *(cp2 + 1) = '\0';
	    if (!strtok (cp, " \t\n") || nl == NULL)
	      break;
	    if (Debug > 2)
	    {
	      fprintf (stderr, "2UTF: Charset names: '%s' \n", ext_charsets[ext_charsets_number].names);
	      if (ext_charsets[ext_charsets_number].USASCII_is_subset == IS)
		fprintf (stderr, "2UTF: US-ASCII is subset " "of this charset. \n");
	    }
	    Strtoupper (cp2 = ext_charsets[ext_charsets_number].names);
	    while (*cp2++)
	      if (*cp2 == '\t')
		*cp2 = ' ';
	    cp = nl + 1;
	    if ((nl = strchr (cp, '\n')) != NULL)
	      *nl = '\0';
	    ext_charsets[ext_charsets_number].to_UTF = xstrdup (cp);
	    if (!strtok (cp, " \t\n"))
	      ext_charsets[ext_charsets_number].to_UTF = NULL;
	    else if (Debug > 2)
	      fprintf (stderr, "2UTF: To UTF-8: '%s' \n", ext_charsets[ext_charsets_number].to_UTF);
	    if (nl != NULL)
	    {
	      cp = nl + 1;
	      if ((nl = strchr (cp, '\n')) != NULL)
		*nl = '\0';
	      ext_charsets[ext_charsets_number].from_UTF = xstrdup (cp);
	      if (!strtok (cp, " \t\n"))
		ext_charsets[ext_charsets_number].from_UTF = NULL;
	      else if (Debug > 2)
		fprintf (stderr, "2UTF: From UTF-8: '%s' \n", ext_charsets[ext_charsets_number].from_UTF);
	    }
	    if (ext_charsets[ext_charsets_number].to_UTF == NULL &&ext_charsets[ext_charsets_number].from_UTF == NULL)
	      break;
	    if (Debug > 2)
	      fprintf (stderr, "2UTF: Entry %i O.K. \n", ext_charsets_number);
	    ext_charsets_number++;

	  }
	  break;
      }
    }
    if (nl == NULL)
      break;
    else
    {
      cp = nl + 1;
      continue;
    }
  }
  while (TRUE);
  if (paths_number <= 0)
    paths = compiled_paths;
  /*Error (no_pathnames); */

  return (TRUE);
}

  inline int
Seek_boundary (FILE * in_stream, char *boundary, int push_boundary)
{
  int ret = FALSE;
  size_t length=0;
  unsigned char *lbp;

  while (ret == FALSE)
  {
    if (in_stream)
    {
      if ((length = Getline (&line.buf, &line.length, in_stream)) == (size_t) -1)
	if (ferror (in_stream))
	  Error (IO_err);
	else {
	  /* FLUSH_OUTPUT(charset_p); */
	  return (FALSE);
	}
      lbp = line.buf;
      if (lbp[0] == '-' && lbp[1] == '-')
      {
	ret = Str_is_boundary (lbp + 2, boundary, push_boundary);
	push_boundary = FALSE;
      }
    }
    else
    {
      ret = Str_is_boundary (lbp = NULL, boundary, push_boundary);
      push_boundary = FALSE;
    }
    if (ret == TRUE || ret == END_BOUNDARY)
      if (!charset_p->USASCII_is_subset) {
	/* FLUSH_OUTPUT(charset_p); */
	Validate_charset ("us-ascii", 0);
      }
    if (ret < OUTER_BOUNDARY)
    {
      if (lbp)
	while (lbp < line.buf + length)
	{
	  PUTC_IN_UTF8 ((unsigned char) *lbp);
	  lbp++;
	  EMPTY_BUFFERS(charset_p);
	}
      else
	fprintf (charset_p->pipe, ret == END_BOUNDARY ? "--%s--\n" : "--%s\n", boundary);
    }
  }
  /*FLUSH_OUTPUT(charset_p);*/
  return (ret);
}

  void
Short_help (int exit_code)
{
  fprintf (stderr, "%s%s", short_help, more_help);
  exit (exit_code);
}

  int
Strcasecmp (const char *str1, const char *str2)
{
  while (toupper(*str1)==toupper(*str2) && *str1)
  {
    str1++;
    str2++;
  }
  return ( toupper(*str1)-toupper(*str2) );

}

  int
Strcase_has_prefix (const char *string, const char *prefix)
{
  while (toupper(*string)==toupper(*prefix) && *prefix)
  {
    string++;
    prefix++;
  }
  return (*prefix=='\0' ? 0 : toupper(*string)-toupper(*prefix) );
}

  char *
Stpcpy (char *To, const char *From)
{
  register char *to=To;

  while ((*to=*From++))
    to++;
  return (to);
}

  char *
Stpncpy (char *To, const char *From, size_t count)
{
  register char *to=To;
  char *ret;

  while ((size_t)(to-To) < count)
    if ((*to=*From++))
      to++;
    else
      break;
  ret = to;
  while ((size_t)(to-To) < count)
    *to++ = '\0';
  return (ret);
}

  int
Str_has_prefix (const char *string, const char *prefix)
{
  while (*string==*prefix && *prefix)
  {
    string++;
    prefix++;
  }
  return (*prefix=='\0' ? 0 : *string-*prefix );
}

  int
Str_is_UTF8 (char *charmap_filename)
{
  register int i, iplus;

  /* Unicode-1-1-UTF-8 */
  if (Strcasecmp (charmap_filename, "UTF-8") == 0 || \
      Strcasecmp (charmap_filename, "UTF-2") == 0 || \
      (Strcase_has_prefix (charmap_filename, "Unicode-") == 0 \
       &&(iplus = strspn ( \
	   charmap_filename + (i = strlen ("Unicode-")), "1234567")) > 0 && \
       charmap_filename[i += iplus] == '-' && \
       (iplus = strspn (charmap_filename + (i += 1), "01234567")) > 0 && \
       (Strcasecmp (charmap_filename + (i += iplus), "-UTF-8") == 0 || \
	Strcasecmp (charmap_filename + i, "-UTF-2") == 0) \
      ) \
     )
    return (TRUE);
  else
    return (FALSE);
}

  inline int
Str_is_boundary (char *linebuf, char *boundary, int push_boundary)
{
  int boundary_len;
  int ret = FALSE, index;
  static struct
  {
    char **lines;
    int last, pending, pending_ret;
  }
  boundaries =
  {
    NULL, -1, -1, 0
  };
  unsigned char *lbp;

  if (push_boundary)
  {
    if (++boundaries.last % 10 == 0)
      boundaries.lines = xrealloc (boundaries.lines, \
	  sizeof (boundaries.lines[0]) * (boundaries.last + 10));
    boundaries.lines[boundaries.last] = xstrdup (boundary);
  }
  if (boundaries.pending != -1)
  {
    if (linebuf)
      Error (internal_err);
    if (line.length < 90)
      line.buf = xrealloc (line.buf, 90);
    *(lbp = Stpcpy (line.buf, boundaries.lines[boundaries.pending])) = '\n';
    lbp[1] = '\0';
    if (boundaries.pending_ret == END_BOUNDARY)
      strcpy (lbp, "--\n");
    lbp = line.buf;
  }
  else if (!(lbp = linebuf))
    Error (internal_err);

  for (index = boundaries.last; index >= 0; index--)
  {
    boundary_len = strlen (boundaries.lines[index]);
    if (strncmp (lbp, boundaries.lines[index], boundary_len) == 0)
      if (lbp[boundary_len +strspn (lbp + boundary_len, " \t")] == '\n')
      {
	if (Debug >= 2)
	  fprintf (stderr, " header boundary line found\n");
	ret = TRUE;
	break;
      }
      else if (lbp[boundary_len] == '-' \
	  &&lbp[boundary_len + 1] == '-' \
	  &&(lbp[boundary_len + 2 \
	    +strspn (lbp + boundary_len + 2, " \t")] == '\n'))
      {
	if (Debug >= 2)
	  fprintf (stderr, " -- end boundary line found\n");
	ret = END_BOUNDARY;
	break;
      }
  }
  if (ret)
    if (index == boundaries.last)
      boundaries.pending = -1;
    else
    {
      boundaries.pending = index;
      if (Debug)
	fprintf (stderr, " -- this is boundary of outer message !\n");
      boundaries.pending_ret = ret;
      ret = OUTER_BOUNDARY + boundaries.last - index;
    }
  if (ret >= END_BOUNDARY)
    boundaries.last--;
  return (ret);
}

  char *
Str_str (char *haystack_, char *needle_)
{
  char *haystack, *needle;
  register char *n_, *n;
  register int index;

  haystack = xstrdup (haystack_);
  needle = xstrdup (needle_);
  n = haystack;
  n_ = haystack_;
  for (index = 0; index < 2; index++)
  {
    while (*n_)
      if (!(*n_ == '-' || *n_ == '_'))
	*n++ = *n_++;
      else
	n_++;
    *n = '\0';
    n = needle;
    n_ = needle_;
  }
  n = strstr (haystack, needle) ? haystack_ : NULL;
  free (haystack);
  free (needle);
  return (n);
}

  inline char *
Strtoupper (char *string)
{
  register int index;

  for (index = 0; string[index] != 0; index++)
    string[index] = toupper (string[index]);
  return string;
}

  inline char *
Strtolower (char *string)
{
  register int index;

  for (index = 0; string[index] != 0; index++)
    string[index] = tolower (string[index]);
  return string;
}

  int
Spit (wchar_t min, wchar_t max, wchar_t charmap[], char unknown_char)
{
  char s[22], header[] = "  0 1 2 3 4 5 6 7 8 9 A B C D E F  0 1 2 3 4 5 6 7 8 9 A B C D E F \n";
  register wchar_t index,t;
  register int length;
  int prefix_length;

  prefix_length = sprintf (s, "%.2lx", (long unsigned int) max);
  fprintf (charset_p->pipe, "%*c%s", prefix_length, ' ', header);
  for (index = min / 32 * 32; index <= max / 32 * 32 + 31; index++)
  {
    if (index % 32 == 0)
      fprintf (charset_p->pipe, "%*.2lX: ", prefix_length, (unsigned long) index);
    if (charset_p->type == ICONV) {
      Put_to_iconv_buf (index, charset_p);
      Put_to_iconv_buf (-1, charset_p);
    } else {
      t = charmap == NULL ? index : (charmap[index] >= 0x80 && charmap[index] < 0xA0 ? (wchar_t) '.' : charmap[index]);
      length = wctomb (s, t <= 0xFF && iscntrl(t) ? (wchar_t) '.' : t);
      /*
      if ((length == 1) && (((unsigned) s[0] < 0x20) || ((unsigned) s[0] == 0x7F)))
      {
	length = wctomb (s, (wchar_t) '.');
      }
      */
      if (length != -1)
      {
	if (fwrite (s, 1, length, charset_p->pipe) != (size_t) length)
	  Error (IO_err);
      }
      else if (putc (unknown_char, charset_p->pipe) == EOF)
	Error (IO_err);
    }
    if (index < 0x3000 || (index >= 0xF000 && index < 0xF900) || (index >= 0xFF60 && index < 0xFFE0) || index >= 0xFFE8)
      if (putc (' ', charset_p->pipe) == EOF)
	Error (IO_err);
    switch (index % 32)
    {
      case 31:
	putc ('\n', charset_p->pipe);
	break;
      case 15:
	putc (' ', charset_p->pipe);
    }
    if (index % (32 * 8) == (32 * 8 - 1))
      fprintf (charset_p->pipe, "%*c%s", prefix_length, ' ', header);
    if (index == 0x7FFFFFFF)
      break;
  }
  return (1);
}

  int
Validate_charset (char *charset_name, enum USASCII_is_subset_type USASCII_is_subset)
{
  int c, element;
  static int charsets_count = 0;
  static struct charset_type *charsets = NULL, *old_charset_p;
  struct charmap_file_type charmap_file =
  {NULL, DEFAULT};
  struct charset_type *charsets_old_addr;
  wchar_t wchar;

  if (Debug >= 5)
    fprintf (stderr, "Validate_charset('%s',%i), charset is '%s', old charset was '%s'\n", charset_name, USASCII_is_subset, charset_p->name, old_charset_p ? old_charset_p->name:NULL);

  if (charset_name != NULL)
  {
    old_charset_p = charset_p;

    if (charset_p->name != NULL && Strcasecmp (charset_name, charset_p->name) == 0)
    {
      if (Debug >= 7)
	fprintf (stderr, "Charset the same: '%s' \n", charset_name);
      if (USASCII_is_subset)
	if (!charset_p->USASCII_is_subset)
	{
	  charset_p = &USASCII_charset;
	  if (Debug >= 2)
	    fprintf (stderr, "US-ASCII isn't subset " "of '%s', changing to US-ASCII", charset_name);
	}
    }
    else if (Strcasecmp (charset_name, "US-ASCII") == 0)
    {
      charset_p = &USASCII_charset;
    }
    else if (strlen (charset_name) < (size_t) (Mail ? 4 : 2) ||Strcasecmp (charset_name, "'unknown'") == 0)
    {
      if (Debug && Strcasecmp (charset_name, "'unknown'") != 0)
	fprintf (stderr, "Too short charset name: `%s\'\n", charset_name);
      charset_p = &unknown_charset;
    }
    else if (Str_is_UTF8 (charset_name))
    {
      charset_p = &UTF8_charset;
    }
    else
    {
      for (element = charsets_count - 1; element >= 0; element--)
      { /* may be we have used that charset before */
	if (Strcasecmp (charsets[element].name, charset_name) == 0)
	{
	  charset_p = &charsets[element];
	  if (charset_p == old_charset_p)
	    Error (internal_err);
	  if (charset_p->type == BUF_PIPE)
	    goto Open; /* can't reuse buffered pipe second time */
	  else if (charset_p->type == ICONV)
	    iconv (charset_p->iconv_p->iconv_handle, NULL, NULL, NULL, NULL);
	  goto Return1;
	}
      }

      charsets_old_addr = charsets;
      charsets = xrealloc (charsets, (sizeof (struct charset_type)) * ++charsets_count);

      if (NULL != charsets_old_addr && old_charset_p >= charsets_old_addr && old_charset_p <= &charsets_old_addr[charsets_count - 2]) {
	    old_charset_p += charsets - charsets_old_addr;
      }
      charset_p = &charsets[charsets_count - 1];

Open:
      charset_p->type = UNKNOWN;
      charset_p->pipe = unknown_charset.pipe;
      strcpy (charset_p->name, charset_name);
      if (Debug >= 2)
	fprintf (stderr, "Changing charset from '%s' to '%s'\n", old_charset_p->name, charset_p->name);
      if (old_charset_p->type == BUF_PIPE && old_charset_p->pipe != charset_p->pipe) {
	pclose (old_charset_p->pipe);
	old_charset_p->pipe = NULL;
      } else {
	FLUSH_OUTPUT(old_charset_p);
      }

      if (iconv_only)
	Open_iconv(charset_p);
      else if (! Look_for_ext_charset (USASCII_is_subset)) {
	if (iconv_first)
	  Open_iconv(charset_p);
	if (charset_p->type == UNKNOWN)
	  if (Fopen_charmap (charset_p, &charmap_file))
	  {
	    charset_p->charmap = xmalloc (256 * sizeof (wchar_t));
	    c = Get_charmap (charset_p->charmap, &charmap_file, unknown_wchar);
	    if (EOF == fclose (charmap_file.stream))
	      Error (IO_err);
	    switch (c)
	    {
	      case err_few_chars:
		Error (bad_charmap_format);
	      case err_IO:
		Error (IO_err);
	      case err_internal:
		Error (internal_err);
	      case err_long:
		if (Debug >= 8)
		  fprintf (stderr, "2UTF: %s \n", long_file);
		break;
	      case err_short:
		if (verbose)
		  fprintf (stderr, "2UTF: %s: \n", incomplete_charmap);
		break;
	    }
	    charset_p->type = KNOWN;
	    charset_p->pipe = stdout;
	    charset_p->USASCII_is_subset = IS;
	    for (wchar = ' '; wchar <= '~'; wchar++)
	      if (charset_p->charmap[wchar] != wchar)
	      {
		charset_p->USASCII_is_subset = NO;
		if (USASCII_is_subset)
		  charset_p = &USASCII_charset;
		break;
	      }
	  } else if (!iconv_first) {
	    Open_iconv(charset_p);
	  }
      }
    }
    /* return (charset_p->type == UNKNOWN ? FALSE : TRUE); ???*/
Return1:
    if (Debug >= 2)
      fprintf (stderr, "Changing charset from '%s' to '%s' again\n", old_charset_p->name, charset_p->name);
    if (old_charset_p->type == BUF_PIPE && old_charset_p->pipe != charset_p->pipe)
    {
      pclose (old_charset_p->pipe);
      old_charset_p->pipe = NULL;
    }
    else
      FLUSH_OUTPUT(old_charset_p);
    return (charset_p->type == UNKNOWN ? FALSE : TRUE);

  }
  else
  {				/* restore charset selected before the current */
    if (Debug >= 2)
      fprintf (stderr, "Restoring charset from '%s' to '%s'\n", charset_p->name, old_charset_p->name);
    if (charset_p->type == BUF_PIPE)
    {
      pclose (charset_p->pipe);
      charset_p->pipe = NULL;
      charsets_count--;
    }
    else
      FLUSH_OUTPUT(charset_p);
    charset_p = old_charset_p;
    if (charset_p->type == BUF_PIPE)
      if (Look_for_ext_charset (USASCII_is_subset) == FALSE)
	fprintf (stderr, "2UTF: Can't find the same ext. charset name second time ?? \n");
    return (charset_p->type == UNKNOWN ? FALSE : TRUE);
  }
}

  inline void *
xmalloc (size_t size)
{
  register void *pointer = malloc (size);

  if (pointer == NULL)
    Error (out_of_mem);
  return pointer;
}

  inline void *
xrealloc (void *pointer, size_t size)
{
  register void *new_pointer = realloc (pointer, size);

  if (new_pointer == NULL)
    Error (out_of_mem);
  return new_pointer;
}

  inline char *
xstrdup (const char *string)
{
  return (strcpy (xmalloc (strlen (string) + 1), string));
}

/*
   inline char *
   xstrndup (const char *string, size_t size)
   {
   register char *new_string = strndup (string, size);

   if (new_string == NULL)
   Error (out_of_mem);
   return new_string;
   }
 */

  int
main (int argc, char *argv[])	/* char *env[]) */
{
#include "approx.c"

  /*FILE *charmap_file = NULL; */
  unsigned char default_unknown_char = 0x80;
  char unknown_char = default_unknown_char;
  char *charmap_filename = NULL, *ptr;
  unsigned char *next_token, /* s[max_string_length], */ *stop_char_ptr;
  const char *optstring = "248Cc:d::ef::Hhi:loprS::su::vVWw";
  const struct long2short_options_type long2short_options[] =
  {
    {
      "UCS-2", '2'
    }
    ,
    {
      "UCS2", '2'
    }
    ,
    {
      "ucs-2", '2'
    }
    ,
    {
      "ucs2", '2'
    }
    ,
    {
      "UCS-4", '4'
    }
    ,
    {
      "UCS4", '4'
    }
    ,
    {
      "ucs-4", '4'
    }
    ,
    {
      "ucs4", '4'
    }
    ,
    {
      "UCS-wchar_t", 'w'
    }
    ,
    {
      "ucs-wchar_t", 'w'
    }
    ,
    {
      "UTF-8", '8'
    }
    ,
    {
      "UTF8", '8'
    }
    ,
    {
      "utf-8", '8'
    }
    ,
    {
      "utf8", '8'
    }
    ,
    {
      "create-aliases", 'C'
    }
    ,
    {
      "charmap-file", 'c'
    }
    ,
    {
      "debug", 'd'
    }
    ,
    {
      "encode-headers", 'e'
    }
    ,
    {
      "format", 'f'
    }
    ,
    {
      "forward", 'o'
    }
    ,
    {
      "help", 'h'
    }
    ,
    {
      "?", 'h'
    }
    ,
    {
      "HTML", 'H'
    }
    ,
    {
      "html", 'H'
    }
    ,
    {
      "iconv", 'i'
    }
    ,
    {
      "list", 'l'
    }
    ,
    {
      "reverse", 'r'
    }
    ,
    {
      "show-charmap", 'W'
    }
    ,
    {
      "spit-glyphs", 'S'
    }
    ,
    {
      "switch-to-UTF-8", 's'
    }
    ,
    {
      "switch-to-UTF8", 's'
    }
    ,
    {
      "switch-to-utf-8", 's'
    }
    ,
    {
      "switch-to-utf8", 's'
    }
    ,
    {
      "unknown-char", 'u'
    }
    ,
    {
      "verbose", 'v'
    }
    ,
    {
      "version", 'V'
    }
    ,
    {
      "blurb", 'V'
    }
    ,
    {
      NULL, '\0'
    }
  };

  enum
  {
    UCS2, UCS4, UCSwchar_t, UTF8f
  }
  output_format = UTF8f;
  int index, create_aliases = FALSE, file_arg = 0, html_doc = FALSE, list_charmaps = FALSE, spit = FALSE, swap, switch_to_unicode = FALSE;
  register int c;
  long int l;
  union
  {
    u_int8_t byte[4];
    u_int16_t b16[2];
    u_int32_t b32;
  }
  u_int;
  wchar_t range, spit_min = 0xF000, spit_max = 0xF1FF, wchar;

  UTF8_charset.pipe = USASCII_charset.pipe = unknown_charset.pipe = stdout;

  /* standard UCS byte order is big endian */
#if (__BYTE_ORDER != __BIG_ENDIAN)
  swap = TRUE;
#else
  swap = FALSE;
#endif

  if (argc <= 1)
  {
  }
  else
  {
    /*while ((c = getopt_long (argc, argv, optstring, long_options, NULL)) != -1)*/
    Long2short_options (argc, argv, long2short_options);
    while ((c = getopt (argc, argv, optstring)) != -1)
    {
      if (verbose)
	fprintf (stderr, " -%c", c);
      switch (c)
      {
	case '?':
	case ':':
	  Short_help(3);
	case '2':
	  output_format = UCS2;
	  break;
	case '4':
	case 'w':
	  output_format = UCS4;
	  break;
	case '8':
	  output_format = UTF8f;
	  break;
	case 'C':
	  create_aliases = 1;
	  break;
	case 'V':
	  fprintf (stderr, "%s%s", version, blurb);
	  exit (0);
	case 'c':
	  charmap_filename = xstrdup (optarg);
	  if (verbose)
	    fprintf (stderr, "'%s'", charmap_filename);
	  break;
	case 'd':
	  Debug = 1;
	  if (optarg)
	    Debug = atoi (optarg);
	  if (verbose)
	    fprintf (stderr, "%i", Debug);
	  verbose = TRUE;
	  break;
	case 'e':
	  encode = TRUE;
	  break;
	case 'f':
	  if (optarg)
	  {
	    charmap_format[DEFAULT] = xstrdup (optarg);
	  }
	  else
	    charmap_format[DEFAULT] = default_charmap_format;
	  if (verbose)
	    fprintf (stderr, "'%s'", charmap_format[DEFAULT]);
	  break;
	case 'H':
	  html_doc = TRUE;
	  break;
	case 'h':
	  Help (default_unknown_char);
	  exit (0);
	case 'i':
	  iconv_only = TRUE;
	  if (optarg) {
	    if (Strcasecmp(optarg, "only") == 0)
	      iconv_only = TRUE;
	    else if (Strcasecmp(optarg, "first") == 0) {
	      iconv_only = FALSE;
	      iconv_first = TRUE;
	    } else if (Strcasecmp(optarg, "last") == 0) {
	      iconv_only = FALSE;
	      iconv_first = FALSE;
	    } else
	      Short_help(5);
	  }
	  break;
	case 'l':
	  list_charmaps = TRUE;
	  break;
	case 'o':
	  reverse = FALSE;
	  break;
	case 'p':
	  Read_config_file ();
	  Print_paths ();
	  exit (0);
	case 'r':
	  reverse = TRUE;
	  break;
	case 'S':
	  spit = 1;
	  if (optarg)
	  {
	    if (strcspn (optarg + strspn (optarg, "\t\n "), "-,;") == 0)
	    {
	      spit_min = 0;
	      if ((next_token = strtok (optarg, "\t\n -,;")) == NULL)
		spit = 2;
	    }
	    else
	    {
	      if (strpbrk (optarg + strspn (optarg, "\t\n -,;"), "-,;"))
		spit = 2;
	      if ((next_token = strtok (optarg, "\t\n -,;")) == NULL)
		Short_help(5);
	      errno = 0;
	      range = strtoul (next_token, (char **) &stop_char_ptr, 16);
	      if (errno != ERANGE && *stop_char_ptr == '\0' &&range >= 0 && range <= 0x7FFFFFFF)
		spit_min = range;
	      else
		Short_help(5);
	      next_token = strtok (NULL, "\t\n -,;");
	    }
	    if (next_token)
	    {
	      errno = 0;
	      range = strtoul (next_token, (char **) &stop_char_ptr, 16);
	      if (errno != ERANGE && *stop_char_ptr == '\0' &&range >= 0 && range <= 0x7FFFFFFF)
		spit_max = range;
	      else
		Short_help(5);
	    }
	    else if (spit == 2)
	      spit_max = (spit_min > 0x7FFFFFFF - 511) ? 0x7FFFFFFF : spit_min / 32 * 32 + 511;
	    else
	      spit_max = spit_min / 32 * 32 + 31;
	    if (spit_max < spit_min)
	    {
	      range = spit_min;
	      spit_min = spit_max;
	      spit_max = range;
	    }
	    if (strtok (NULL, "\t\n -,;"))
	      Short_help(5);
	  }
	  /*fprintf(stderr,"min = %lx\n",spit_min); */
	  if (verbose)
	    fprintf (stderr, "0x%.4lX-0x%.4lX\n", (long unsigned int) spit_min, (long unsigned int) spit_max);
	  break;
	case 's':
	  switch_to_unicode = TRUE;
	  break;
	case 'u':
	  if (optarg)
	    if (strlen (optarg) <= 1)
	      unknown_char = optarg[0];
	    else
	    {
	      errno = 0;
	      l = strtol (optarg, (char **) &stop_char_ptr, 0);
	      if (errno != ERANGE && *stop_char_ptr == '\0' && l <= 0xFF)
		unknown_char = l;
	      else
		Short_help(5);
	    }
	  else
	    unknown_char = default_unknown_char;
	  if (verbose)
	    fprintf (stderr, "0x%.2X", unknown_char);
	  break;
	case 'v':
	  verbose = TRUE;
	  fprintf (stderr, " -v");
	  break;
	case 'W':
	  show_charmap = TRUE;
	  break;
	  /*          case 'w':
		      output_format = UCSwchar_t;
		      break; */
	default:
	  fprintf (stderr, "getopt returned character code 0x%X ??\n", c);
      }
    }
    if (verbose)
      putc ('\n', stderr);
  }
  if (encode && !iconv_only)
    Error (add_iconv_only);
  if (!(ptr = strrchr (argv[0], '/')))
    ptr = argv[0];
  else
    ptr++;
  if (Strcasecmp (ptr, "fromUTF") == 0)
    reverse = !reverse;
  if (Debug > 7)
    fprintf (stderr, "2UTF: argv[0]='%s', filename='%s'. \n", argv[0], ptr);
  if (Debug)
    if (reverse)
      fprintf (stderr, "2UTF: from UTF \n");
    else
      fprintf (stderr, "2UTF: to UTF \n");
  if (switch_to_unicode)
    fprintf (stderr, "\033%%G");
  if (iconv_only) {
    paths_number = 0;
  } else {
    Read_config_file ();
  }
  if (atexit (&Close_pipe) != 0)
    Error (internal_err);
  if (create_aliases)
    if (!(c = Create_aliases ()))
    {
      fprintf (stderr, "2UTF: %s '%s' \n", can_not_create, aliases_pathname);
      exit (7);
    }
  if (list_charmaps)
    exit (List_charmaps ()? 0 : 8);
  if (spit)
  {
    Spit (spit_min, spit_max, NULL, unknown_char);
    exit (0);
  }
  if (argc > 1 && optind < argc) {
    charmap_filename = argv[file_arg = argc - 1];
  }
  else if (charmap_filename == NULL)
    if (create_aliases)
      exit (0);
    else
    {
      /* Assuming mail message */
      if (output_format == UCS2 || output_format == UCS4 || reverse)
	Error (unimplemented);
      Mail = TRUE;
      c = parse_message (0);
      if (charset_p->type == BUF_PIPE || charset_p->type == NON_BUF_PIPE)
	pclose (charset_p->pipe);
      Validate_charset ("'unknown'", 0);
      /*charset_p = &unknown_charset;*/
      Pipe_to_UTF8 (stdin);
      if (c != END_BOUNDARY)
      {
	if (Debug)
	  fprintf (stderr, "parse of message failed: %d\n", c);
	exit (1);
      }
      else if (Debug)
	fprintf (stderr, "parse of message complete\n");
      exit (0);
    }
  /* For the output of interractive programms */
  setvbuf (stdout, NULL, _IONBF, 0);
  if (show_charmap)
  {
    reverse = FALSE;
    unknown_wchar = (wchar_t) '?';
  }
  if (!Validate_charset (charmap_filename, 0))
  {				/* (charset_p->type == UNKNOWN) */
    if (strchr (charmap_filename, '/') == NULL)
    {
      fprintf (stderr, "%s '%s' \n", can_not_find_alias, charmap_filename);
      for (index = 0; index < paths_number; index++)
	fprintf (stderr, " %s*%s* \n", paths[index], charmap_filename);
    }
    else
      fprintf (stderr, " %s \n", charmap_filename);
    Error (can_not_open_any);
  }
  else if (charset_p->type == UTF8)
  {
    if (verbose)
      fprintf (stderr, "2UTF: %s '%s' \n", using, "Unicode UTF-8");
  }
  else if (charset_p->type == USASCII)
  {
    if (verbose)
      fprintf (stderr, "2UTF: %s '%s' \n", using, "US-ASCII");
    charset_p->charmap = xmalloc (256 * sizeof (wchar_t));
    charset_p->type = KNOWN;
    charset_p->pipe = stdout;
    charset_p->USASCII_is_subset = IS;
    for (wchar = 0; wchar <= 0x7F; wchar++)
      charset_p->charmap[wchar] = wchar;
    for (wchar = 0x7F; wchar <= 0xFF; wchar++)
      charset_p->charmap[wchar] = unknown_wchar;
  }

  if (charmap_filename != argv[file_arg])
    free (charmap_filename);
  if (show_charmap)
  {
    unknown_wchar = (wchar_t) '?';
    if (charset_p->type != UTF8)
      Spit (0, 255, charset_p->charmap, unknown_char);
    else
      Spit (0, 0x7FFFFFFF, NULL, unknown_char);
    exit (0);
  }
  if (charset_p->type != KNOWN && (output_format == UCS2 || output_format == UCS4))
    Error (unimplemented);
  if (reverse)
  {
    if (output_format == UCS2)
    {
      while (fread (u_int.byte, 1, 2, stdin) == 2)
      {
	/* check Byte Order Mark */
	if (0xFFFE == u_int.b16[0])
	  swap = TRUE;
	else if (0xFEFF == u_int.b16[0])
	  swap = FALSE;
	else
	{
	  if (swap)
	  {
	    c = u_int.byte[0];
	    u_int.byte[0] = u_int.byte[1];
	    u_int.byte[1] = c;
	  }
	  wchar = u_int.b16[0];
	  Print_approx_Macro (1, wchar, unknown_char)
	}
      }
    }
    else if (output_format == UCS4)
    {
      while (fread (u_int.byte, 1, 4, stdin) == 4)
      {
#if (__BYTE_ORDER == __PDP_ENDIAN)
#error
	c = u_int.b16[0];
	u_int.b16[0] = u_int.b16[1];
	u_int.b16[1] = c;
#endif
	/* check Byte Order Mark */
	if (0xFFFE0000 == u_int.b32)
	  swap = TRUE;
	else if (0x0000FEFF == u_int.b32)
	  swap = FALSE;
	else
	{
	  if (swap)
	  {
	    c = u_int.byte[0];
	    u_int.byte[0] = u_int.byte[3];
	    u_int.byte[3] = c;
	    c = u_int.byte[1];
	    u_int.byte[1] = u_int.byte[2];
	    u_int.byte[2] = c;
	  }
	  wchar = u_int.b32;
	  Print_approx_Macro (1, wchar, unknown_char)
	}
      }
    }
    else if (output_format == UTF8f)
    {
      if (charset_p->type == ICONV) {
	while ((c = getc (stdin)) != EOF)
	  Put_to_iconv_buf (c, charset_p);
	Put_to_iconv_buf (-2, charset_p);
      } else if (charset_p->type == KNOWN) {
	while ((c = Freadmb (&wchar, stdin)) != EOF)
	  Print_approx_Macro (c, wchar, unknown_char)
      } else if (charset_p->type == UTF8 || charset_p->type == BUF_PIPE || charset_p->type == NON_BUF_PIPE || charset_p->type == USASCII) {
	while ((c = getc (stdin)) != EOF) {
	  if (putc (c, charset_p->pipe) == EOF)
	    Error (IO_err);
	}
      } else
	Error (internal_err);
      if (ferror (stdin))
	Error (IO_err);
    }
    else
      Error (internal_err);

  }
  else
    /* not reverse */
  {
    if (output_format == UCS2)
    {
      putchar (0xFE);
      putchar (0xFF);
      while ((c = getchar ()) != EOF)
      {
	u_int.b16[0] = (u_int16_t) charset_p->charmap[c];
#if (__BYTE_ORDER != __BIG_ENDIAN)
	c = u_int.byte[0];
	u_int.byte[0] = u_int.byte[1];
	u_int.byte[1] = c;
#endif
	if (fwrite (u_int.byte, 1, 2, stdout) != 2)
	  Error (IO_err);
      }
    }
    else if (output_format == UCS4)
    {
      putchar (0);
      putchar (0);
      putchar (0xFE);
      putchar (0xFF);
      while ((c = getchar ()) != EOF)
      {
	u_int.b32 = (u_int32_t) charset_p->charmap[c];
#if (__BYTE_ORDER == __LITTLE_ENDIAN)
	c = u_int.byte[0];
	u_int.byte[0] = u_int.byte[3];
	u_int.byte[3] = c;
	c = u_int.byte[1];
	u_int.byte[1] = u_int.byte[2];
	u_int.byte[2] = c;
#elif (__BYTE_ORDER == __PDP_ENDIAN)
	c = u_int.byte[0];
	u_int.byte[0] = u_int.byte[1];
	u_int.byte[1] = c;
	c = u_int.byte[2];
	u_int.byte[2] = u_int.byte[3];
	u_int.byte[3] = c;
#elif (__BYTE_ORDER == __BIG_ENDIAN)
#else
#error Unknown byte order.
#endif
	if (fwrite (u_int.byte, 1, 4, stdout) != 4)
	  Error (IO_err);
      }
    }
    /*      else if (output_format == UCSwchar_t)
	    {
	    while ((c = getchar ()) != EOF)
	    if (fwrite (&charset_p->charmap[c], sizeof (wchar_t), 1, stdout) != 1)
	    Error (IO_err);
	    }
     */
	    else if (output_format == UTF8f)
	      Pipe_to_UTF8 (stdin);
	    else
	      Error (internal_err);
  }
  if (feof (stdin))
    exit (0);
  else
    Error (IO_err);
  exit (101);
}
