/* 
 * truefalse.S  
 * This file is placed in the public domain.
 */
#include <sys/syscall.h>

#ifndef VALUE
#error "Please define VALUE to true or false"
#endif

/* values for VALUE */
#define true 0
#define false 1

#ifdef __i386__
#define SUPPORTED

	.globl _start
_start:
        movl    $SYS_exit,%eax
        movl    $VALUE,%ebx
        int     $0x80

#endif  /* __i386__ */

#ifdef __alpha__
#define SUPPORTED
#include <asm/pal.h>

	.align 3
	.globl _start
	.ent _start,0
_start:
	.frame $30, 0, $26
	ldiq $0, SYS_exit
	ldiq $16, VALUE

	.set noat
	call_pal PAL_callsys
	.end _start
	
#endif  /* __alpha__ */

#ifdef __mc68000__
#define SUPPORTED

	.text
	.globl _start
	.type _start, @function
	.align 4
_start:
	movel #SYS_exit, %d0
	movel #VALUE, %d1
	trap &0
	.size _start, . - _start

#endif /* __mc68000__ */

#ifdef __mips__
#define SUPPORTED

	.text
	.align 2
	.globl _start
	.ent _start,0
_start:
	addiu $2,$0,SYS_exit
	addiu $4,$0,VALUE
	syscall
	.end _start
#endif

#ifdef __sparc__
#define SUPPORTED
#include <asm/unistd.h>

	.text
	mov	__NR_exit, %g1
	mov	VALUE, %o0
	t	0x10

#endif

#ifndef SUPPORTED
#error "Unsupported architecture"
#endif
