// XSH.C The root part of the AWC Shell Script Compiler
// Written in 1990 by Al Williams
// Updated 1998 for Linux/ANSI
#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <signal.h>
#include <sys/wait.h>
#include <unistd.h>

int shpid;
FILE *out;
char pipename[32];
extern char *name;
extern char lines[];
extern char *shell;
extern char *opt;
extern unsigned linesize;
char linebuf[8192];
char *decode();

void atend(int notused)
  {
  int rc;
  if (wait(&rc)==shpid) 
    rc=(rc&0xFF00)>>8; 
  else
    return; 
/* delete NSHPIPE */
  unlink(pipename);
  exit(rc);
  }  

void


main(int argc,char *argv[],char *envp[])
  {
  char *p;
  sprintf(pipename,".NSHPIPE%d",getpid());
  mknod(pipename,S_IFIFO|0777,0);  
  signal(SIGCHLD,atend);
  signal(SIGTERM,SIG_IGN);
  signal(SIGINT,SIG_IGN);
  signal(SIGHUP,SIG_IGN);
  signal(SIGQUIT,SIG_IGN);
  if (!(shpid=fork()))
   {
   char **newargv;
   int i,o=1;
   newargv=(char **)malloc((argc+3)*sizeof(char *));
   if (!newargv) { perror(name); exit(127); }
   newargv[0]=shell;
   if (opt) newargv[o++]=opt;
   newargv[o]=pipename;
   for (i=1;i<argc;i++) newargv[i+o]=argv[i];
   newargv[i+o]=NULL;
   execve(shell,newargv,envp);
/* should not get here */
   perror(name); exit(127);
   }
  out=fopen(pipename,"w");
  if (!out) { perror(name); exit(127); } else
    {
    char *lp=lines,*lbp=linebuf;
    while (linesize--)
      {
      *lbp++=*lp;
      if (!*lp++) 
         { 
         lbp=linebuf; 
         fprintf(out,"%s\n",decode(linebuf)); 
         fflush(out); 
         }
      }
    fprintf(out,"exit\n");
    fflush(out);
    }
  pause();  /* wait for SIGCLD */
}
    






