/* A prototypical decode routine for the Script Compiler
   Williams
 You have several choices here:
 1) Don't change anything. Fine. Everyone who has seen this source
    can crack your code, but maybe you don't care!
 2) Change the cryptkey string below. Now, just about anyone can
    crack your code, but it will take them a small amount of effort
 3) Completely rewrite the decode routine. This can be as easy or
    hard as you want to make it.

The routine here converts the string in place by xoring it with the
key. It is important that the transform is reversible in some way. In
other words, calling decode twice should not change the string.
    */
#include <string.h>

static char cryptkey[]={ 'S'-0x20, 'E'-0x20, 'C'-0x20, 'T'-0x20,
			'O'-0x20, 'R'-0x20, '_'-0x20, '*'-0x20 };
char *decode(char *s)
   {
   static int i=0;
   char *rs=s;
   while (*s)
    {
    *s^=cryptkey[i];
    if (!*s) *s^=cryptkey[i];  
    if (++i>=sizeof(cryptkey)) i=0;
    s++;
    }
  return rs;
  }








