/*
 *  line - a GNUishly version of the HP-UX line command.
 *  Copyright (C) 1995 Torsten Poulin
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Torsten Poulin, torsten@diku.dk
 *
 *---------
 * $Log: line.c,v $
 * Revision 1.2  1995/05/29  17:20:33  torsten
 * Made a bit more compatible with the HP-UX version and compliant
 * with its own man page ;-)
 *
 * Revision 1.1  1995/05/25  15:05:24  torsten
 * Initial revision
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <unistd.h>
#include <getopt.h>

#define LINELEN 1025  /* or whatever ... */

#define VERSTR "line 1.2\n"

#define HELPSTR \
"Usage: %s [OPTION]\n\n"\
"  -t, --timeout SECONDS       abort after this many seconds\n"\
"      --help                  display this text and exit\n"\
"      --version               output version information and exit\n\n"\
"The timeout option is not documented in POSIX and other industry\n"\
"standards, and should not be used in portable applications.\n"

static const char RCS[] = "$Id: line.c,v 1.2 1995/05/29 17:20:33 torsten Exp $";

void alarm_handler(int dummy)
{
  exit(0);
}

int main(int argc, char **argv)
{
  char line[LINELEN];
  int c;
  long secs = 0;


  for (;;)
    {
      int option_index = 0;
      static struct option long_options[] =
	{
	  {"timeout", 1, 0, 't'},
	  {"help", 0, 0, 'h'},
	  {"version", 0, 0, 'V'},
	  {0, 0, 0, 0}
	};

      c = getopt_long(argc, argv, "t:", long_options, &option_index);

      /*
       * Detect the end of the options.
       */
      if (c == -1)
     	break;

      /*
       * Long option?
       */

      if (c == 0)
	c = long_options[option_index].val;

      switch (c)
	{
	case 't':
	  if ((secs = atol(optarg)) <= 0)
	    {
	      fprintf(stderr,
		      "%s: timeout argument must be a positive integer\n",
		      *argv);
	      exit(2);
	    }
	  break;

	case 'h':
	  printf(HELPSTR, *argv);
	  exit(0);

	case 'V':
	  printf(VERSTR);
	  exit(0);

	default:
	  fprintf(stderr, "Try `%s --help\' for more information.\n", *argv);
	  exit(2);
	}
    }

  if (secs)
    {
      signal(SIGALRM, alarm_handler);
      alarm(secs);
    }

  /*
   * Finally the real job.
   */

  if (fgets(line, LINELEN, stdin) == NULL)
    {
      putchar('\n');
      exit(1);
    }
  fputs(line, stdout);

  exit(0);
}
