/*
	confobj.h	Configuration Class Header
	Copyright (c) 2000, 2001, 2002 Kriang Lerdsuwanakij
	email:		lerdsuwa@users.sourceforge.net

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __K_CONFOBJ_H
#define __K_CONFOBJ_H

#include "config.h"
#include "setupcurses.h"
#include "list.h"
#include "gzfileio.h"

#include CXX__HEADER_map

USING_NAMESPACE_STD;

struct DirConfig {
	string	dir;
	bool	globDot;
	bool	globPath;

	DirConfig(string dir_, bool globDot_, bool globPath_) : 
		dir(dir_), globDot(globDot_), globPath(globPath_) {}

	bool	operator ==(const DirConfig& d) const {
		return dir == d.dir && globDot == d.globDot
				    && globPath == d.globPath;
	}
	bool	operator !=(const DirConfig& d) const {
		return !(*this == d);
	}
};

typedef sptr_list<DirConfig>	DirList;
typedef sptr<DirConfig>		DirItem;

#define SCAN_MODE_FULL		0
#define SCAN_MODE_SMART		1
#define SCAN_MODE_PARTIAL	2

extern string	confLocalFile;

#define DEFAULT_COLOR		INT_MAX		/* Must be the same type as
						   in AttrConfig */
struct AttrConfig {
	COLOR_TYPE	colorForeground;
	COLOR_TYPE	colorBackground;
	ATTR_TYPE	colorAttr;
	ATTR_TYPE	bwAttr;
};

struct KcdConfig {
	bool	cfgQuietFull;
	bool	cfgQuietSmart;
	bool	cfgQuietPartial;
	bool	cfgQuiet;

	bool	cfgAutoScan;
	bool	cfgSpaceSelect;
	bool	cfgSortTree;
	bool	cfgCaseSensitiveSort;
	bool	cfgGraphicChar;
	bool	cfgScrollBar;

	bool	cfgGlobDot;
	bool	cfgGlobPath;

	unsigned	cfgShowListThreshold;

	AttrConfig	cfgAttrNormal;
	AttrConfig	cfgAttrLink;
	AttrConfig	cfgAttrHighlight;
	AttrConfig	cfgAttrURL;
	AttrConfig	cfgAttrHeader;
	AttrConfig	cfgAttrBold;
	AttrConfig	cfgAttrItalic;
	AttrConfig	cfgAttrScrollArrow;
	AttrConfig	cfgAttrScrollBlock;
	AttrConfig	cfgAttrScrollBar;
	AttrConfig	cfgAttrTitle;
	AttrConfig	cfgAttrMore;
	AttrConfig	cfgAttrLinkBold;
	AttrConfig	cfgAttrLinkItalic;
	AttrConfig	cfgAttrHighlightBold;
	AttrConfig	cfgAttrHighlightItalic;

	COLOR_TYPE	cfgDefaultBackground;

	DirList	*cfgSkipDir;
	DirList	*cfgStartDir;

	KcdConfig();
	~KcdConfig();

	KcdConfig(const KcdConfig &c);
	KcdConfig& operator=(const KcdConfig &c);
	
	void SetScanMode(int mode, int forceQuiet);

	void SetAttr(AttrConfig &cfg, int colorFg, int colorBg, 
		     ATTR_TYPE colorAttr, ATTR_TYPE bwAttr) {
		cfg.colorForeground = colorFg;
		cfg.colorBackground = colorBg;
		cfg.colorAttr = colorAttr;
		cfg.bwAttr = bwAttr;
	}
};

typedef map<string, KcdConfig> configMap;
extern KcdConfig kcdConfig;
extern KcdConfig defConfig;
extern configMap allConfig;

bool	FindSkipDir(const string &str);
bool	FindStartDir(const string &str);

int	k_fnmatch(const string &pattern, const string &str);

#endif	/* __K_CONFOBJ_H */
