/*
	khwin.h		Hypertext Window Header
	Copyright (c) 1996-8,2000,2001,2003 Kriang Lerdsuwanakij
	email:		lerdsuwa@users.sourceforge.net

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef __K_KHWIN_H
#define __K_KHWIN_H

#include "config.h"

#include CXX__HEADER_climits
USING_NAMESPACE_STD;

#include "khdoc.h"
#include "editbox.h"
#include "scrnman.h"
#include "statwin.h"
#include "miscobj.h"
#include "scroll.h"
#include "gzfileio.h"
#include "confobj.h"

const int	idHyperWindow	 = 1;
const int	idStatWindow	 = 2;
const int	idURLWindow	 = 3;
const int	idHScrollBar	 = 4;
const int	idVScrollBar	 = 5;
const int	idScrollBox	 = 6;
const int	idMoreBar	 = 7;

const int	modeNoScroll	 = 0;
const int	modeHScroll	 = 1;
const int	modeVScroll	 = 2;
const int	modeHVScroll	 = 3;


class	khGeometryManager : public NCGeometryManagerBase {
	public:
		static bool	disableScrollBar;
		
		khGeometryManager(int mode_) : NCGeometryManagerBase(mode_) {}
		void	SetWinRect(int id, NCRect &rect);
};

class	khScreenManager : public NCScreenManager {
	protected:
		bool		lockScreen;

		virtual void	RequestResize();

		void		InitAttr(int id, const AttrConfig &cfg, ATTR_TYPE& attr);

	public:
		virtual int	ReadKeyboard();
	
		khScreenManager(NCGeometryManagerBase &geoMan_);
		virtual ~khScreenManager() {}
};

class	HyperWindow : public NCWindowBase {
	protected:
		khMarkerBar	marker;
		HyperDocument	&html;		// Our document, parser
		StatusWindowBase	&status, &url;
		ScrollBarBase		&hscroll, &vscroll;

		WINDOW	*blankWin;
		int	numRealColumn;

		typedef sptr_list<Anchor>::const_iterator iterType;

		Anchor	newSelected;		// Save new anchor generated by
						// ProcessCall(...) for processing

		const Anchor	*anchorSelected;	// Selected anchor (by pressing 
						//	spacebar) 
		const Anchor	*prevHighlight;		// Store previously highlighted
						//	anchor to restore char
						//	attributes to normal ones
		iterType	curAnchorIter;	// Current (highlighted) or closest
						//	(not highlighted) anchor
		int	curRow, curColumn;	// Cursor position
		int	padRow, padColumn;	// Current upper-left pad
						//	position displayed
						   
		int	initSize;		// User-supplied size ?
		int	initRow, initColumn;	// User-supplied size
		
		string	startSection;
		int	lockKey;

						// For vi key binding
		bool	viFoundG;		// g prefix
		bool	viFoundZ;		// Z prefix
		bool	viFoundCount;		// count prefix
		size_t	viCount;		// count prefix

		bool	emacsFoundAlt;

		void	InitObject();		// Document variables

/*		
		void	InitFileIn(const char *fileName);	// Read file to `buffer'
		void	InitFileIn(FILE *file);		// Read stream to `buffer'
		void	ReadFile(gzFile file);		// Used by InitFileIn(...)
*/
		
		int	isInitScreen;		// Screen initialized ?
							
						// Prepare document for display
		void	PrepareDisplay(bool sameDocument = false);

		bool	MatchSubString(iterType &curA, const string &findText);
		
		void	Highlight();
		
		void	FitHighlightHorizontal(iterType &newA);
		void	FitHighlightTop(iterType &newA);
		void	FitHighlightMiddle(iterType &newA);
		void	FitHighlightBottom(iterType &newA);

		void	CenterPad(iterType &newA);
		void	CenterRowPad(iterType &newA);
		void	CenterRowPadIfScroll(iterType &newA);
		
		virtual	void	ProcessKey(int key);
#ifdef NCURSES_MOUSE_VERSION
		virtual void	ProcessMouse(MEVENT & /*event*/);
#endif
		virtual Anchor	ProcessCall(Anchor *p);

		void	ProcessKeySelect();
		void	ProcessKeyCenter();
		void	ProcessKeyNextStatus();
		void	ProcessKeyExit();
		void	ProcessKeyPanLeft();
		void	ProcessKeyPanRight();
		void	ProcessKeyUp();
		void	ProcessKeyDown();
		void	ProcessKeyFirstLine();
		void	ProcessKeyLastLine();
		void	ProcessKeyScrollUpLines(size_t);
		void	ProcessKeyScrollDownLines(size_t);
		void	ProcessKeyPrevPage() { ProcessKeyScrollUpLines(GetRow()-1); }
		void	ProcessKeyNextPage() { ProcessKeyScrollDownLines(GetRow()-1); }
		void	ProcessKeyFirstPage();
		void	ProcessKeyLastPage();
		void	ProcessKeyPrev();
		void	ProcessKeyNext();
		void	ProcessKeyBeginLine();
		void	ProcessKeyEndLine();
	
		bool	PosBeforeAnchor(iterType &p, int x, int y);
		bool	PosAfterAnchor(iterType &p, int x, int y);
		bool	PosAtAnchor(iterType &p, int x, int y);

		int	GetDocRow();
		int	GetDocColumn();
		int	GetNumChar(int y);

	public:
		virtual void	DoResize();
		virtual void	DoUpdate();
		virtual void	DoRestCursor();

		// For all constructors
		// row <= 0 && col <= 0 for full-screen plus specified
		// 	row, col
	
		HyperWindow(NCScreenManager &scrn_, int id_, HyperDocument &html_,
				StatusWindowBase &status_,
				StatusWindowBase &url_,
				ScrollBarBase &hscroll_,
				ScrollBarBase &vscroll_,
				const string &startSection_,
				int lockKey_ = 0, int row = 0, int col = 0);

		virtual ~HyperWindow();
		virtual void	Init();		// Alloc and setup pad
		virtual void	KeyboardLoop();
};

class	SomethingWithFind {		// Provide FindText interface for
					// khStatusWindowWithFind
	public:
		// CursorMode:
		//	return: nonzero if cursor must be turned on before find
		//		and turned off after find
		virtual int	CursorMode() = 0;

		virtual void	FindText(const string & /*text*/, bool find_backward = false) = 0;
		virtual void	FindPrev(const string & /*text*/) = 0;
		virtual void	FindNext(const string & /*text*/) = 0;
		virtual void	SelectText(const string & /*text*/) = 0;
		virtual void	FindProcessKey(int ch) = 0;
};


class	khHyperWindowWithFind : public HyperWindow, public SomethingWithFind {
	public:
		virtual int	CursorMode();
		virtual void	FindText(const string &text, bool find_backward = false);
		virtual void	FindPrev(const string &text);
		virtual void	FindNext(const string &text);
		virtual void	SelectText(const string &text);
		virtual void	FindProcessKey(int ch);

	public:
		virtual void	ProcessKey(int ch);
		virtual Anchor	ProcessCall(Anchor *p);

		khHyperWindowWithFind(NCScreenManager &scrn_, int id_,
				HyperDocument &html_,
				StatusWindowBase &status_,
				StatusWindowBase &url_,
				ScrollBarBase &hscroll_,
				ScrollBarBase &vscroll_,
				const string &startSection_,
				int lockKey_ = 0, int row = 0, int col = 0);
		virtual ~khHyperWindowWithFind();
};

#endif	/* __K_KHWIN_H */
