# copy-message.pl - Copy message from msgid to msgstr
# Copyright (c) 2000 Kriang Lerdsuwanakij
# email:	lerdsuwa@users.sourceforge.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


print "# Automatically generated by copy-message.pl\n";

@msgid_list = ();
$begin_multiline_msgid = 0;
$in_multiline_msgid = 0;

while (<STDIN>) {

	if ($begin_multiline_msgid) {
		if (/^\s*msgstr/) {		# Information
			print $_;
			$begin_multiline_msgid = 0;
			$in_multiline_msgid = 0;
		}
		elsif (/^\s*\"/) {		# Continue multiline msgid
			print $_;
			push @msgid_list, $_;
			$begin_multiline_msgid = 0;
		}
		else {
			print $_;
			$begin_multiline_msgid = 0;
			$in_multiline_msgid = 0;
		}
	}
	elsif ($in_multiline_msgid) {
		if (/^\s*\"/) {			# Continue multiline msgid
			print $_;
			push @msgid_list, $_;
		}
		elsif (/^\s*msgstr/) {		# Start msgstr
			$output_tag = 0;
			for $line (@msgid_list) {
				if ($output_tag == 0) {
					print "msgstr" . "$line";
					$output_tag = 1;
				}
				else {
					print $line;
				}
			}
			$in_multiline_msgid = 0;
		}
		else {
			print $_;
			$in_multiline_msgid = 0;
		}
	}
	elsif (/^\s*msgid\s*\"\"/) {
		print $_;
		@msgid_list = ();
		push @msgid_list, " \"\"\n";
		$begin_multiline_msgid = 1;
		$in_multiline_msgid = 1;
	}
	elsif (/^\s*msgid/) {
		print $_;
		@msgid_list = ();
		push @msgid_list, $';
		$begin_multiline_msgid = 0;
		$in_multiline_msgid = 1;
	}
	else {
		print $_;
	}
}
