

;				IMPLICATOR
;			(C)opyright Andrew H. Nelson 1989-2000

;	Implicator, in a nutshell, implements about everything that has to
;do with PRODUCTION RULE EXPERT SYSTEM SHELLs.  It also has an Augmented
;Transition Network PARSER and all the functions necessary to define nets
;and parse grammers.

;	It was built in a small subset of Common LISP as just another
;set of Lisp functions.  Why ?  SEAMLESS Integration.  No shells, no
;clutter.  You want graphics, windows, or editors; use yours.  You
;want to port what you build using Implicator to a Lisp machine, PC,
;or a mainframe, using one of the leading Common Lisp interpreters;
;PORT WITH NO CHANGES REQUIRED.

;add it to your product or LISP ENVIRONMENT.  The help file is the only
;documentation you get with Implicator, but it's thorough, and the source
;is well documented.

;	Some buzz words that might get your attention and motivate you to go
;through the small, but horrendous HELP FILE and TUTORIAL FILE that's included
;here:
 
;Integrated FORWARD AND BACKWARD CHAINING with the same rules, 
;ABDUCTION, CONDITIONING (generate rules from a given set of facts to produce
;a desired set of facts), AGENDA BASED forward-chaining, ATN, SCHEMAs, 
;DEMONS, OBJECT-ORIENTED, INHERITANCE, UNIFICATION, ALTERNATE WORLDS and VIEW-
;POINTS, NON-MONOTONIC TRUTH MAINTENANCE, SIMPLE, SEAMLESS and COMMON.

;	Now the usual disclaimer.  Don't depend on it for anything. I don't
;guarantee it does anything.  If you use it and take a loss, you have my
;sympathy but you are not entitled to anything else.  I won't, (and can't)
;be legally bound to help you out in any way should something go wrong.
;Also, there might be a small dependency upon XLISP 1.7 built in.  If there
;is please let me know.

;                       Andrew H. Nelson
;			4250 Glencoe Ave, #1303
;			Marina Del Rey, CA, 90292
;			(attn: Implicator)
;                       nelsonah@aol.com
;                       nelsonah@globetranz.com

;  Copyright (C) Andrew H. Nelson 1989-2000.  All rights reserved.
;Now Released under Gnu Public License.  See gpl.html in this release.

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; COMMON LISP initialization for XLISP 1.7
;;; These functions defined must have equivalents in you lisp environment
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

; get some more memory (not required for portability)
(expand 15)

; don't tell when we are garbage collecting

(setq *gc-flag* nil)
(ALLOC 200)

;;;    use (string (char x pos)) vice substr in common lisp
;;;    use (string (char x pos)) vice substr in common lisp
;;;    use (string (char x pos)) vice substr in common lisp
;;;    use (string (char x pos)) vice substr in common lisp


;; no for in xlisp
;; (for x = i to j (...) (...) ...)
;; (for x = i downto j (...) (...) ...)

(defmacro FOR (var eqsign x dir y &rest body)
	`(prog 	((,var ,x)) 
		(cond ((not (equal ',eqsign '=)) (return '"sytax error")))
		(cond ((not (or (equal ',dir 'downto)
                                (equal ',dir 'to))) (return '"sytax error")))
		TAG
			(progn ,@body)
		(setq ,var (cond ((equal ',dir 'to) (1+ ,var))
				 ((equal ',dir 'downto ) (1- ,var))
				 (t (return 'syntax_error))))
		(if (or (and (equal ',dir 'to) (<= ,var ,y))
			(and (equal ',dir 'downto) (>= ,var ,y)))
			(go TAG) (return t))))

;;; Common Lisp open

(defun open (filename direction)
  (cond ((equal direction :input) (openi filename))
        ((equal direction :output) (openo filename))
        (t (print filename) 
           (break "not opened  --- input or output ????"))))

; Common lisp string-append
(setq string-append #'strcat)

(defun get-choice (test sequence &optional choice)
  (cond ((null sequence) choice)
        ((null choice) (get-choice test (cdr sequence) (car sequence)))
        (t (if (funcall test (car sequence) choice) 
               (get-choice test (cdr sequence) (car sequence))
               (get-choice test (cdr sequence) choice)))))

(defun sort (sequence test)
  (cond ((null sequence) nil)
        (t (cons (get-choice test sequence)
                 (sort (del1st
                        (get-choice test sequence)
                        sequence) test)))))

(defun del1st (x list)
  (cond ((null list) nil)
        ((equal x (car list)) (cdr list))
        (t (cons (car list) (del1st x (cdr list))))))
;; common lisp loop 

(DEFMACRO LOOP
          (&rest x)
          (BACKQUOTE (PROG NIL
                           TAG
			   (progn ,@x)
                           (GO TAG) )) )

 ; Common lisp y-or-n-p
 (defun y-or-n-p (x &aux answer)
  (progn (princ x) (setq answer (read))
         (or (equal answer 'y)
             (equal answer 'yes)
             (equal answer 'ok)
             (equal answer 'alright)
             (equal answer 'sure)
             (equal answer 'maybe)
             (equal answer 'pos)
             (equal answer 'positive)
             (equal answer 'probably)
             (equal answer 'couldbe))))

 ; no cadddr in gclisp
 ; (defun cadddr (x) (car (cdr (cdr (cdr x)))))

 ; no cadar in gclisp
 ; (defun cadar (x) (car (cdr (car x))))


; (mapcan fun list [ list ]...)
(defmacro mapcan (&rest args) `(apply #'nconc (mapcar ,@args)))

; (mapcon fun list [ list ]...)
(defmacro mapcon (&rest args) `(apply #'nconc (maplist ,@args)))

(DEFUN REMOVE-IF (TESTFUNC SEQUENCE)
 (COND ((NULL SEQUENCE) NIL)
       ((FUNCALL TESTFUNC (CAR SEQUENCE)) (REMOVE-IF TESTFUNC (CDR SEQUENCE)))
       (T (CONS (CAR SEQUENCE) (REMOVE-IF TESTFUNC (CDR SEQUENCE))))))


;;; create an atom from a list   '(s y m b o l) -> 'symbol
 
(defun implode (x)
 (intern (lst->str x)))

(DEFUN lst->str (X)
  (COND ((NULL (CDR X)) (SYMBOL-NAME (CAR X)))
        (T (string-append (SYMBOL-NAME (CAR X)) (lst->str (CDR X))))))

;;; create a list from an atom  'symbol -> '(s y m b o l)

(defun explode (x)
 (str->lst (symbol-name x)))

(DEFUN str->lst (X)
 (DO* ((POS 1 (1+ POS))
       (LNG 1)
;;;    use (string (char x pos)) vice substr in common lisp
       (STRNG (SUBSTR X POS LNG) (SUBSTR X POS LNG))
       (SYM (intern STRNG) (intern STRNG))
       (LST (LIST SYM) (CONS SYM LST)))
       ((= POS (LENGTH X)) (reverse lst))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; COMMON LISP initialization for XLISP 1.7
;;; These functions defined must have equivalents in you lisp environment
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; initialization file for XLISP 1.7

; get some more memory
(expand 1)

; some fake definitions for Common Lisp pseudo compatiblity
(setq first  car)
(setq second cadr)
(setq rest   cdr)

; (when test code...) - execute code when test is true
(defmacro when (test &rest code)
          `(cond (,test ,@code)))

; (unless test code...) - execute code unless test is true
(defmacro unless (test &rest code)
          `(cond ((not ,test) ,@code)))

; (makunbound sym) - make a symbol be unbound
(defun makunbound (sym) (setq sym '*unbound*) sym)

; (objectp expr) - object predicate
(defun objectp (x) (eq (type-of x) :OBJECT))

; (filep expr) - file predicate
(defun filep (x) (eq (type-of x) :FILE))

; (mapcan fun list [ list ]...)
(defmacro mapcan (&rest args) `(apply #'nconc (mapcar ,@args)))

; (mapcon fun list [ list ]...)
(defmacro mapcon (&rest args) `(apply #'nconc (maplist ,@args)))

; (set-macro-character ch fun [ tflag ])
(defun set-macro-character (ch fun &optional tflag)
    (setf (aref *readtable ch) (cons (if tflag :tmacro :nmacro) fun))
    t)

; (get-macro-character ch)
(defun get-macro-character (ch)
  (if (consp (aref *readtable* ch))
    (cdr (aref *readtable* ch))
    nil))

; (save fun) - save a function definition to a file
(defmacro save (fun)
         `(let* ((fname (strcat (symbol-name ',fun) ".lsp"))
                 (fval (car ,fun))
                 (fp (openo fname)))
                (cond (fp (print (cons (if (eq (car fval) 'lambda)
                                           'defun
                                           'defmacro)
                                       (cons ',fun (cdr fval))) fp)
                          (close fp)
                          fname)
                      (t nil))))

; (debug) - enable debug breaks
(defun debug ()
       (setq *breakenable* t))

; (nodebug) - disable debug breaks
(defun nodebug ()
       (setq *breakenable* nil))

; initialize to enable breaks but no trace back
(setq *breakenable* t)
(setq *tracenable* nil)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; COMMON LISP initialization for XLISP 1.7
;;; These functions defined must have equivalents in you lisp environment
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; format
;   (pp <expr> [<sink>] )
;
;       <expr>  the expression to print.
;       <sink>  optional. the sink to print to. defaults to
;                   *standard-output*
;       <maxlen> the threshold that pp uses to determine when an expr
;                   should be broken into several lines. The smaller the
;                   value, the more lines are used. Defaults to 45 which
;                   seems reasonable and works well too.
;-

(let ((pp-stack* nil)
      (pp-istack* nil)
      (pp-currentpos* nil)
      (pp-sink* nil)
      (pp-maxlen* nil))
 
(defun pprint (*expr &optional *sink *maxlen)
   (setq pp-stack* nil
         pp-istack* '(0)
         pp-currentpos* 0
         pp-sink* *sink
         pp-maxlen* *maxlen)

   (if (null pp-sink*) (setq pp-sink* *standard-output*))
   (if (null pp-maxlen*) (setq pp-maxlen* 80))
 
   (pp-expr *expr)
   (pp-newline)
   t)
 
 
(defun pp-expr (*expr)
   (cond ((consp *expr)
            (pp-list *expr) )
 
         (t (pp-prin1 *expr)) ) )
 
 
;+
; pp-list
;   Pretty-print a list expression.
;       IF <the flatsize length of *expr is less than pp-maxlen*>
;           THEN print the expression on one line,
;       ELSE
;       IF <the car of the expression is an atom>
;           THEN print the expression in the following form:
;                   "(atom <item1>
;                          <item2>
;                           ...
;                          <itemn> )"
;       ELSE
;       IF <the car of the expression is a list>
;           THEN print the expression in the following form:
;                   "(<list1>
;                     <item2>
;                       ...
;                     <itemn> )"
;
;-
 
(defun pp-list (*expr)
   (cond ((< (flatsize *expr) pp-maxlen*)
            (pp-prin1 *expr) )
 
         ((atom (car *expr))
            (pp-start)
            (pp-prin1 (car *expr))
            (pp-princ " ")
            (pp-pushmargin)
            (pp-rest (cdr *expr))
            (pp-popmargin)
            (pp-finish) )
 
         (t (pp-start)
            (pp-pushmargin)
            (pp-rest *expr)
            (pp-popmargin)
            (pp-finish) ) ) )
 
;+
; pp-rest
;   pp-expr each element of a list and do a pp-newline after every call to
;   pp-expr except the last.
;-
 
(defun pp-rest (*rest)
   (do* ((item* *rest (cdr item*)))
        ((null item*))
            (pp-expr (car item*))
            (if (not (null (cdr item*))) (pp-newline)) ) )
 
;+
; pp-newline
;   Print out a newline character and indent to the current margin setting
;   which is maintained at the top of the pp-istack. Note that is the
;   current top of the pp-stack* is a ")" we push a " " so that we will know
;   to print a space before closing any parenthesis which were started on a
;   different line from the one they are being closed on.
;-
 
(defun pp-newline ()
   (if (eql ")" (pp-top pp-stack*)) (pp-push " " pp-stack*))
 
   (terpri pp-sink*)
   (spaces (pp-top pp-istack*) pp-sink*)
   (setq pp-currentpos* (pp-top pp-istack*)) )
 
;+
; pp-finish
;   Print out the closing ")". If the top of the pp-stack* has a " " on it,
;   then print out the space, then the ")" , and then pop both off the stack.
;-
 
(defun pp-finish ()
   (cond ((eql ")" (pp-top pp-stack*))
            (pp-princ ")") )
 
         (t
            (pp-princ " )")
            (pp-pop pp-stack*) ) )
 
   (pp-pop pp-stack*) )
 
 
;+
; pp-start
;   Start printing a list. ie print the "(" and push a ")" on the pp-stack*
;   so that pp-finish knows to print a ")" when closing an list.
;-
 
(defun pp-start ()
   (pp-princ "(")
   (pp-push ")" pp-stack*) )
 
;+
; pp-princ
;   Prints out an expr without any quotes and updates the pp-currentpos*
;   pointer so that we know where on the line the cursor is at.
;-
 
(defun pp-princ (*expr)
    (setq pp-currentpos* (+ pp-currentpos* (flatc *expr)))
    (princ *expr pp-sink*) )
 
;+
; pp-prin1
;   Does the same thing as pp-prin1, except that the expr is printed with
;   quotes if needed. Hence pp-prin1 uses flatsize to calc expr length instead
;   of flatc.
;-
 
(defun pp-prin1 (*expr)
    (setq pp-currentpos* (+ pp-currentpos* (flatsize *expr)))
    (prin1 *expr pp-sink*) )
 
(defmacro pp-push (*item *stack)
   `(setq ,*stack (cons ,*item ,*stack)) )
 
 
(defmacro pp-pop (*stack)
   `(let ((top* (car ,*stack)))
 
        (setq ,*stack (cdr ,*stack))
        top*) )
 
 
(defun pp-top (*stack) (car *stack))
 
 
(defun pp-pushmargin ()
   (pp-push pp-currentpos* pp-istack*) )
 
 
(defun pp-popmargin ()
   (pp-pop pp-istack*) )

(defun spaces (n f)
    (dotimes (x n) (write-char 32 f)))

)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;; COMMON LISP initialization for XLISP 1.7
;;; These functions defined must have equivalents in you lisp environment
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;; Parser primitives used in atn-main of the interpreter ;;;;;
;;;;;;	queue mgmt to build the parse tree                   ;;;;;

(DEFUN QUEUE (X L) 
  (INVERT (CONS X (INVERT L))))


(DEFUN INVERT (L)
  (COND ((NULL L) NIL)
	(T (CONS (LAST L) (INVERT (BUTLAST L))))))


(DEFUN BUTLAST (L) 
  (COND ((NULL (CDR L)) NIL)
	(T (CONS (CAR L) (BUTLAST (CDR L))))))


(DEFUN LAST (L) 
  (COND ((NULL (CDR L)) (CAR L)) 
	(T (LAST (CDR L)))))

(defmacro mapq1 (func parm q &aux temp-mpq1) 
 `(cond ((null ,q) nil)
	(t (setq temp-mpq1 (,func ,parm (car ,q)))
	   (if  (null temp-mpq1) (mapq1 ,func ,parm (cdr ,q))
		(cons temp-mpq1  (mapq1 ,func ,parm (cdr ,q)))))))

(defmacro mapq2 (func parm1 parm2 q &aux temp-mpq2) 
 `(cond ((null ,q) nil)
	(t (setq temp-mpq2 (,func ,parm1 ,parm2 (car ,q)))
	   (if  (null temp-mpq2) (mapq2 ,func ,parm1 ,parm2 (cdr ,q))
		(cons temp-mpq2  (mapq2 ,func ,parm1 ,parm2 (cdr ,q)))))))

;;;	stack functions to build the tree

(defun push (x)
  (setq *stk* (cons x *stk*)))

(defun topstk ()
  (car *stk*))

(defun pop(&aux ret)
  (setq  ret  (car *stk*))
  (setq *stk* (cdr *stk*))
  ret)

(defun pushtoken (x)
  (setq *token* (cons x *token*)))

(defun toptoken ()
  (car *token*))

(defun poptoken(&aux ret)
  (setq  ret  (car *token*))
  (setq *token* (cdr *token*))
  ret)

;;;;;  
;;;;; the help function
;;;;;

(defun help (n &aux key)
  (setq key (symbol-name n))
  (do*	((fp (open "ontology.txt" :input))
	 (subject "AI")
	 (subject1 "online help")
	 (buffer (read-line fp) (if (not (null fp)) (read-line fp))))
	((null buffer) (if (not (null fp)) (close fp) t))
	(progn
	 (if 	(and (> (length buffer) 0)
                        ;;         (string (char buffer 1))
			(equal "*" (substr buffer 1 1)))
		(progn (setq subject buffer) (setq subject1 (read-line fp))))
	 (if (>=  (length buffer) (+ 5 (length key)) )
	     (if (equal key (substr buffer 5 (length key)))
		 (progn
			(princ (string-append subject "\n"))
			(princ (string-append subject1 "\n\n"))
			(princ (string-append buffer "\n"))
			(print_entry fp) (close fp) (setq fp nil)))))))

(defun print_entry (fp)
  (do 	((buffer (read-line fp) (read-line fp)))
	((equal (length buffer) 0) t)
	(princ (string-append buffer "\n"))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; END THE COMMON LISP initialization file for XLISP 1.7
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;   IMPLICATOR Copyright (c) Andrew H. Nelson 1989
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun putprop (object value property)
  (setf (get object property) value))

(defun remprop (object property)
  (setf (get object property) nil))

;  Copyright (C) Andrew H. Nelson 1989, 1990, 1991, 1992, 1993, 1994, 1995, 1996, 1997, 1998, 1999, 2000.  All rights reserved.
;  May not be copied, reproduced, or used in any manner without
;  1989, 1990, 1991the expressed written permission of the author.  Now released under GNU Public License.  See a copy of  the GPL in gpl.html with this release.

(setq title     "         Implicator (C)            "
      copyright "Copyright (C) Andrew H. Nelson 1989")

(defun declare-copyright ()
 (progn (terpri) (princ title) (terpri) (princ copyright) (terpri)))

(declare-copyright)

;(setq *ExpertPath*
;      (progn (terpri)
;             (princ "input pathname of files e.g. \"\\\\dir\\\\dir\\\\\" --")
;             (read)))

(setq *ExpertPath* "\\stuff\\ai\\")

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;; atn  globals  ;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(setq debug        nil	;flag for debug functions in the atn to exec
      *dictionary* nil	;list of all words known by atn
      *features*   nil	;all features (morphology) of those words
      *agenda*     nil  ;atn agenda
      *actions*    nil
      *sentence*   nil
      *uselist*    nil	;save-last and use
      *ParseTree*          nil
      *token*      nil
      *sem-end*    nil	;all semantics functions on the end queue
      *sem-wait*   nil	;all semantics functions on the wait queue
      *stk*        nil)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;; expert system globals ;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 ;assertions are represented as lists of atoms
 ;the database will be a list of assertions

 ;this erases the world
 ;see save-world and init-world for more

 (defun erase-world ()
  (setq *assertions*	nil   ;short term memory
	*cf-strategey*  'ia   ;what strategy to figure confidence factor
	*non-monotonic* nil   ;non-monotonic truth maintenance ?
	*rules*		nil   ;long term memory
	*database*	nil   ;longterm + shortterm for back chaining
        *context*       nil   ;list of viewpoints in current world
	rules-used-list nil   ;rules and instantiated facts that fired them
	*objects*	nil   ;schema objects or instantiations
	*ruletext*	nil   ;english explaination of a rule
        it              nil   ;last pattern used by present, flush, remove
        them            nil   ;last patterns used by allpresent, forevery
        self            nil   ;current object
	ltm		nil   ;list of rule names
       	$FcAgenda	nil   ;the forward chaining agenda
	stm		nil)) ;shortterm memort

 ;since we are loading up lets erase the world and start fresh
 (erase-world)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 (defun get-object-from-file (file)
  (let* ((fp (open file :input))
	 (buffer  (if (not (null fp)) (read fp) nil )))
         (progn   (if (not (null fp)) (close fp)) buffer)))

 (defun save-object-to-file (obj filename)
  (let* ((fp (open filename :output)))
	 (progn (pprint obj fp) (close fp))))

 (defun init-world()
  (let* ((world	     (progn (terpri) (princ "load world named? ") (read))))
        (init-w world)))

 (defun save-world()
  (let* ((world	     (progn (terpri) (princ "save world named? ") (read))))
        (save-w world)))

 (defun init-w(x)
  (let* ((world	     (symbol-name x))
	 (assertions (string-append *ExpertPath* world ".stm"))
	 (rules      (string-append *ExpertPath* world ".ltm"))
	 (rules-used (string-append *ExpertPath* world ".rul"))
	 (database   (string-append *ExpertPath* world ".dbf"))
         (context    (string-append *ExpertPath* world ".ctx"))
	 (ruletxt    (string-append *ExpertPath* world ".exp")))
  (progn
    (setq *assertions* (get-object-from-file assertions))
    (setq *rules* (get-object-from-file rules))
    (setq rules-used-list (get-object-from-file rules-used))
    (setq *ruletext* (get-object-from-file ruletxt))
    (setq *database* (get-object-from-file database))
    (setq *context*  (get-object-from-file context))
    (mapcar #'recall-viewpoint *context*)
    (initrules *rules*)
    (setq ltm (get_rule_names)) t)))


 (defun save-w(x)
  (let* ((world	     (symbol-name x))
	 (assertions (string-append *ExpertPath* world ".stm"))
	 (rules-used (string-append *ExpertPath* world ".rul"))
	 (rules      (string-append *ExpertPath* world ".ltm"))
	 (database   (string-append *ExpertPath* world ".dbf"))
         (context    (string-append *ExpertPath* world ".ctx"))
	 (ruletxt    (string-append *ExpertPath* world ".exp")))
  (progn
    (save-object-to-file *assertions* assertions)
    (save-object-to-file *rules*  rules)
    (save-object-to-file *ruletext* ruletxt)
    (save-object-to-file *context* context)
    (mapcar #'save-viewpoint *context*)
    (save-object-to-file rules-used-list rules-used)
    (save-object-to-file *database* database))))
	
(defun debugon()
 (progn (setq debug t) (break "debug mode on") t))

(defun cc () (continue))

(defun display (&optional fp)
  (progn
    (if (null fp) (setq fp *standard-output*))
    (print '------actions------ fp)
    (print '------agenda------- fp) (print (car *agenda*) fp)
    (print '------*actions*---- fp) (print *actions* fp)
    (print '------queue-------- fp) (print *ParseTree* fp)
    (print '------sentence----- fp) (print *sentence* fp)
    (print '------stack-------- fp) (print *stk* fp)
    (print '------token-------- fp) (print *token* fp)))

(defun snapshot (x)
  (let ((fp (open (string-append "snapshot." (symbol-name x)) :input)))
       (progn (display fp) (close fp) t)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; symbol primitives needed to break up and find roots etc ;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(defun newsym (sym)
 (intern (symbol-name (gensym (symbol-name sym)))))

(defun make$ (sym)
 (intern (string-append "$" (symbol-name sym))))

(DEFUN SYM-EQ (X Y)
  (EQUAL (SYMBOL-NAME X) (SYMBOL-NAME Y)))

(defun sym-eql (x y)
;;;     (or (not (atom x)) (not (atom y)))
;;;     good example of De Morgan's law in action
 (cond  ((not (and (atom x) (atom y))) nil)
	((null x) (and (null x) (null y)))		;if null x then null y
	((null y) nil)					;if null y (not null x)
	(t (sym-eql-aux (explode x) (explode y)))))	;must be symbols

(defun sym-eql-aux (x y)
  (cond ((null x) t)
	((null y) nil)
        (t (and (sym-eq (car x) (car y)) (sym-eql-aux (cdr x) (cdr y))))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;  tree manipulation primitives and such ;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; returns first occurance of node in tree l

(defun search (x l)
  (cond ((null l) nil)
	((atom (car l)) (if (sym-eql x  (car l))
			    l (search x (cdr l))))
	(t (or (search x (car l)) (search x (cdr l))))))

;;; returns last occurance of node in tree l

(defun getlast (x l &optional answer)
  (cond ((null l) answer)
	((atom l) (if (sym-eql x l) l answer))
	((atom (car l)) (if (sym-eql x (car l))
			(progn (setq answer l) (getlast x (cdr l) answer))
			(getlast x (cdr l) answer)))
	(t (or (getlast x (cdr l)answer) (getlast x (car l)answer)))))

;;; prints the tree

(DEFUN PRTTREE (X &optional SPACES fp)
  (IF (NULL SPACES) (SETQ SPACES 1) (SETQ SPACES (+ SPACES 5)))
  (if (null fp) (setq fp *standard-output*))
  (COND ((NULL X) T)
	((and (equal (length x) 2)
	      (atom (cadr x)))
		(dotimes (y spaces t) (princ " " fp))
		(princ (car x) fp) (princ " -- " fp) (print (cadr x) fp) )
        ((ATOM (CAR X))
         (DOTIMES (Y SPACES T) (PRINC " " fp))
         (PRINT (CAR X) fp)
         (DOLIST (Z (CDR X) T) (PRTTREE Z SPACES fp)))
        (T (DOLIST (Z X T) (PRTTREE Z SPACES fp)))))


;;; return name of branch of tree

(defun nodename(x) (car x))

;;; return nodes branches

(defun branches (x)
  (cdr x))

;;; pred to determine if this node the chosen one

(defun thenode (name tree)
  (cond ((nodep tree)
	 (sym-eql name (nodename tree)))
	(t nil)))


;;; is this node a leaf ?

(defun leafp (node)
  (and  (not (atom node))
	(atom (car node))
	(equal (length node) 2) (atom (cadr node))))

;;; is this structure a node ?

(defun nodep (node &aux bool)
  (setq bool t)
  (or (leafp node)
      (and (not (atom node)) (atom (car node)) (>= (length node) 2)
           (dolist (b (branches node) bool)
	           (setq bool (and bool (nodep b)))))))

;;; delete a branch and all of its sub branches from the tree

(defun prune (name x &aux good temp)
  (setq good nil)
  (cond ((atom x) x)
	((thenode name x) nil)
	((nodep x)
         (dolist (branch (branches x) (cons (nodename x) (reverse good)))
	         (if (setq temp (prune name branch))
		     (setq  good (cons temp good))
		     good)))
	(t x)))

;;; graft on a branch to the tree

(defun graft (name y x &aux good temp)
  (setq good nil)
  (cond ((atom x) x)
	((thenode name x) (cons (nodename x) (cons y (branches x))))
	((nodep x)
         (dolist (branch (branches x) (cons (nodename x) (reverse good)))
	         (if (setq temp (graft name y branch))
		     (setq  good (cons temp good))
		     good)))
	(t x)))

;;; replace a branch on the tree with another branch

(defun replace(name y x &aux good temp)
  (setq good nil)
  (cond ((atom x) x)
	((thenode name x)
         (cond ((listp y) (cons (nodename x) y))
	       (t (list (nodename x) y))))
	((nodep x)
         (dolist (branch (branches x) (cons (nodename x) (reverse good)))
	         (if (setq temp (replace name y branch))
		     (setq  good (cons temp good))
		     good)))
	(t x)))

;;; strips non-terminals from parse tree and
;;; returns a tree of terminal symbols only

(defun reducetree (x &aux good temp)
  (setq good nil)
  (cond ((leafp x) (cadr x))
	((nodep x)
         (dolist (branch (branches x) (reverse good))
	         (if (setq temp (reducetree branch))
		     (setq  good (cons temp good))
		     good)))
	(t x)))

;;; strips non-terminals from parse tree and
;;; returns a tree of the last non-terminal symbols only

(defun analyzetree (x &aux good temp)
  (setq good nil)
  (cond ((leafp x) (car x))
	((nodep x)
         (dolist (branch (branches x) (reverse good))
	         (if (setq temp (analyzetree branch))
		     (setq  good (cons temp good))
		     good)))
	(t x)))

;;; flattens a tree to a single list of symbols

(defun squash (s)
  (cond ((null s) nil)
	((atom s) (list s))
	(t (append (squash (car s)) (squash (cdr s))))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;  end tree manipulation primitives and such ;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;; the dictionary facility ;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;; dictionary entry has a property list:
;;;	root-form
;;;	part-of-speech
;;;	feature-assignments .... association list ((tense past) (number 1))
;;;		tense = past or present or future or tenseless
;;;             number= 1s 2s 3s 1p 2p 3p
;;;		


(defmacro defword (word root-form part-of-speech &rest feature-assignments)
 `(progn
    (setf (get ',word 'lex) ',word)
    (setf (get ',word 'root) ',root-form)
    (setf (get ',word 'type) ',part-of-speech)
    (setf (get ',word 'features) ',feature-assignments)
    (setq *dictionary* (cons ',word *dictionary*))
    t))

(defmacro dictionary (word part root &rest x)
 `(setf (get ',word 'features) ',x))

;;;	define dimensions  default values  other values

	(defmacro deffeature (dim default &rest other-values)
	 `(setq *features*
		(cons (list ',dim ',default ',other-values) *features*)))

	(DEFMACRO FEATURE (X)
	  (BACKQUOTE (ASSOC (QUOTE (COMMA X)) *FEATURES*)))

	(DEFMACRO DEFAULT (X)
	  (BACKQUOTE (CADR (FEATURE (COMMA X)))))

	(DEFMACRO OTHER (X)
	  (BACKQUOTE (CADDR (FEATURE (COMMA X)))))

	(defmacro featurep (x)
	  `(not (null (feature ,x))))

	(defmacro feature-value-p (f v)
	  `(or  (member ,v  (default ,f) :test #'equal)
		(member ,v  (other ,f)   :test #'equal)
		(member 'anything (other ,f) :test #'equal)))


(defmacro d-the (dimension of constituent &aux temp)
 `(progn
   (if  (sym-eql '$  ',constituent)
	(setq temp
	      (cadr (assoc ',dimension (get ,constituent 'features))))
	(setq temp
	      (cadr (assoc ',dimension (get ',constituent 'features)))))
   (if (null temp) (setq temp (default ',dimension)))
   (if (equal temp 'anything) (setq temp nil))
   temp))


;;; differs from the book on ':='
;;;      (:= mood of $s-maj  'question)
;;; instead of
;;;      (:= (the mood of $s-maj) 'question)

(defmacro := (dimension of constituent value)
 `(if (sym-eql '$ ',constituent)

	(if 	(feature-value-p ,dimension ,value)
		(setf   (get ,constituent 'features)
			(cons 	(list ',dimension ,value)
				(get ,constituent 'features)))
		'"unknown feature or feature value")

	(if 	(feature-value-p ,dimension ,value)
		(setf	(get ',constituent 'features)
			(cons	(list ',dimension ,value)
				(get ',constituent 'features)))
		'"unknown feature or feature value")
))

;;;	the advertized stuff in chapter 4
;;;

;;;	look at input stream, if next symbol terminal-symbol
;;;	remove it from input stream and return true

	(defmacro category (term)
	 `(progn
	    (setq $last (car *sentence*))	
            (if (equal (get (car *sentence*) 'type) ',term)
                   (progn
			(setq *ParseTree*
		  	   (queue (list ',term (car *sentence*)) *ParseTree*))
			(setq *sentence* (cdr *sentence*))
                          t))))

;;;	give networks names and define grammers

	(defmacro defnet (net-name network)
          `(progn (setq ,net-name ',network) ',net-name))

;;;	detach constituent location

	(defun detach (c l &aux templ)
	  (setq templ (last (mapq1 getlast l *ParseTree*)))
	(if (eval debug) (break "detach"))
	  (if (null templ)
	      (progn
		(setq templ (mapq1 getlast l *stk*))
		(if (eval debug) (break "detach"))
		(if (null templ)
		    nil
		    (progn
			(setq templ (prune c templ))
			(setq *stk* (mapq2 replace l (cdr templ) *stk*))
			(if (eval debug) (break "detach")) t
			)))
	      (progn
		(setq templ (prune c templ))
		(setq *ParseTree* (mapq2 replace l (cdr templ) *ParseTree*))
		(if (eval debug) (break "detach")) t
		)))

;;;     drop a piece of the tree structure back into the input stream

	(defun drop (x &aux temp)
	 (progn
		(setq temp (last (mapq1 getlast x *ParseTree*)))
		(if (eval debug)(break "drop1: temp"))
		(if (null temp) nil
		    (progn
			(if (eval debug)(break "drop1-in: sentence"))
			(setq *sentence* (append (squash (reducetree temp))
						 *sentence*))
			(setq *ParseTree* (mapq1 prune x *ParseTree*))
			t ))

	 	(if (null temp)
	     	    (progn
			(setq temp (last (mapq1 getlast x *stk*)))
			(if (eval debug)(break "drop2: temp"))
			(if (null temp) nil
		    	    (progn
			    (if (eval debug)(break "drop2-in: sentence"))
			    (setq *sentence* (append  (squash (reducetree temp))
						      *sentence*))
			    (setq *stk* (mapq1 prune x *stk*))
			    (if (search x *stk*)
				(setq *stk* (cons (mapq1 prune x (car *stk*))
						  (cdr *stk*))))
			     t ))))

			(if (null temp) nil t)))

;;;     translate a piece of the tree structure back into the structure stuff

	(defun analyze (x &aux temp)
	  (progn
		(setq temp (last (mapq1 getlast x *ParseTree*)))
		(if (null temp)
		    (setq temp (last (mapq1 getlast x *stk*))))
		(squash (analyzetree temp))))

;;;	assign right side value to left side
;;;	(defmacro := (L R)
;;;	  (setf ,l ,R))

;;; 	(== "left-hand-side" right-hand-side)

	(defun == (x y) (sym-eql x y))

;;;	constituent is inserted into the input stream
;;;     lisp passes atom by value, lists by name
	
	(defmacro insert (c)
	 `(if	(listp ',c)
		(setq *sentence* (cons ,c *sentence*))
	  	(setq *sentence* (cons ',c *sentence*))))

;;;	look at input stream, if next symbol terminal-symbol
;;;	return true

	(defmacro peek (term)
          `(progn
		(setq $last (car *sentence*))
		(equal (get (car *sentence*) 'type) ',term)))

;;;	puts last parsed object into a special list which the use command
;;;	knows about

	(defun save-last ()
	  (setq *uselist* (cons $last *uselist*)))

;;;	returns the first (leftmost in tree) node of type category that
;;;	is found directly under constituent

	(defmacro the-first (category of constituent &optional key &aux answer)
	 `(if (equal ',category 'nil) nil
	    (progn
		(setq answer nil)
		(if (d-the ,category of ,constituent)
                        (setq answer (d-the ,category of ,constituent)))

		(if (and (null answer)
			 (or (sym-eql (car *token*)  ',constituent)
			     (sym-eql (car *token*)   ,constituent)))
		    (setq answer (car (mapq1 search ',category *ParseTree*))))

		(if (null answer)
		(if (or (sym-eql '$  ',constituent)
			(listp ',constituent))
		(setq answer (car
		  (or
		  (mapq1 search ',category (mapq1 search ,constituent *stk*))
 		  (mapq1 search ',category (mapq1 search ,constituent *ParseTree*)))))
		(setq answer (car
		  (or
		  (mapq1 search  ',category (mapq1 search ',constituent *stk*))
		(mapq1 search  ',category (mapq1 search ',constituent *ParseTree*)))))))

		(cond 	((atom answer) answer)
			((leafp  answer)
			 (if (null ,key) (cadr answer) (nodename answer)))
			((nodep answer)
			 (if (null ,key) (branches answer) (nodename answer)))
			(t answer))
)))

;;;	returns the last (rightmost in tree) node of type category that
;;;	is found directly under constituent

;;;	 (last (mapq1 getlast x *stk*))

	(defmacro the (category of &optional constituent key &aux answer)
	`(if (equal ',category  'nil)  nil
	  (if (equal ',category 'word) ',of
	      (progn
		(setq answer nil)
		(if (d-the ,category of ,constituent)
                        (setq answer (d-the ,category of ,constituent)))

		(if (eval debug) (break "the: answer"))

		(if (and (null answer)
			 (or (sym-eql (car *token*)  ',constituent)
			     (sym-eql (car *token*)   ,constituent)))
		    (setq answer (last (mapq1 getlast ',category *ParseTree*))))

		(if (null answer)
		(if (or (sym-eql '$  ',constituent)
			(listp ',constituent))
		(setq answer (last
		  (or
	(mapq1 getlast ',category (mapq1 getlast ,constituent *ParseTree*))
	(mapq1 getlast ',category (mapq1 getlast ,constituent *stk*)))))
		(setq answer (last
		  (or
	(mapq1 getlast  ',category (mapq1 getlast ',constituent *ParseTree*))
	(mapq1 getlast  ',category (mapq1 getlast ',constituent *stk*)))))))

		(if (eval debug) (break "the end"))

		(cond 	((atom answer) answer)
			((leafp answer)
			 (if (null ,key) (cadr answer) (nodename answer)))
			((nodep answer)
			 (if (null ,key) (branches answer) (nodename answer)))
			(t  answer))
			))))

;;;	inserts the last item saved into the input stream
;;;
	(defun use(&aux ret)
	   (setq ret (car *uselist*))
	   (if (not (null ret))
		(progn
	 		(setq *uselist* (cdr *uselist*))
			(setq *sentence* (cons ret *sentence*)))))
	
;;;	look at input stream, if next word
;;;	from input stream has root remove it and return true

	(defmacro word (root)
	 `(progn
		(setq $last (car *sentence*))
		(if  (equal (get (car *sentence*) 'root) ',root)
                   (progn
			(setq *ParseTree*
		  	   (queue (list ',root (car *sentence*)) *ParseTree*))
			(setq *sentence* (cdr *sentence*))
                          t))))




;;;     backtracking atn interpreter


;;;; agenda       = (choice-point1 choice-point2 ...)
;;;; choice-point = (sentence actions)
;;;; sentence     = '(some words like this in a list)
;;;; actions      = '(list of actions to perform)

(defun store_choicepoint (s actions queue stk token)
  (setq *agenda* (cons (list s actions queue stk token) *agenda*)))

(defun backto_choicepoint ()
  (setq *sentence* (caar *agenda*)
        *actions*  (list (cadar *agenda*))
        *ParseTree*	   (caddar *agenda*)
        *stk*      (car (cdddar *agenda*))
        *token*    (cadr(cdddar *agenda*))
        *agenda*   (cdr *agenda*)))

;  Copyright (C) Andrew H. Nelson 1989, 1990, 1991, 1992, 1993, 1994, 1995, 1996, 1997, 1998, 1999, 2000.  All rights reserved.
;  May not be copied, reproduced, or used in any manner without
;  1989, 1990, 1991the expressed written permission of the author.  Now released under GNU Public License.  See a copy of  the GPL in gpl.html with this release.

;;; function atn

;;; args: *s*, the input sentence - a nonlocal variable.
;;; vars: *agenda* - stores the choice-points put on by
;;;                  the either command.  Initially it is
;;;                  set to the (parse s-maj) action, and *s* to
;;;                  the input sentence.
;;; algorithm:
;;; loop: Until either a successful parse, or *agenda* is empty.
;;;       Call atn-main choosing the first choice-point from
;;;       *agenda*, and removing it from the list.  If successful,
;;;       print out resulting tree; else try next choice-point.
;;; end loop.

(defun atn (sentence start-action)
  (setq *sentence*      sentence
        *agenda*        '((nil (done atn) nil nil nil))
        *actions*       nil
        *ParseTree*             nil)
  (store_choicepoint sentence start-action nil nil nil)
  (catch 'done
	(loop
	   (if (eval debug) (break "atn start"))
           (backto_choicepoint)
           (if (null *actions*) (throw 'done *sentence*))
           (if (atn-main *actions*) (throw 'done 't)))))

;  Copyright (C) Andrew H. Nelson 1989, 1990, 1991, 1992, 1993, 1994, 1995, 1996, 1997, 1998, 1999, 2000.  All rights reserved.
;  May not be copied, reproduced, or used in any manner without
;  1989, 1990, 1991the expressed written permission of the author.  Now released under GNU Public License.  See a copy of  the GPL in gpl.html with this release.


;;; function atn-main
;;;
;;; args: actions - A list of actions to be performed.
;;;
;;; loop: Until either no more actions on actions or an action fails.
;;;       Remove first action from actions and eval it.
;;;
;;;       case: category, word, peek, = etc: If test
;;;             is successful, then continue.
;;;             otherwise report failure to atn.
;;;
;;;             seq: Put all of the subactions on front of actions.
;;;
;;;             either: pick one of the possibilities "at random"
;;;                     and put it on the front of actions.
;;;                       For each alt action, store a choice-point
;;;                       with (a) current *s*
;;;                            (b) the alt action added to actions.
;;;
;;;             parse: Add a done action to actions.  Put the network
;;;                    associated with the constituent to be parsed on
;;;                    actions.
;;;
;;;             done: The parser has completed a constituent.  If there
;;;                   are not further actions, then, if *s* is empty,
;;;                   report back success, and if *s* has things left on
;;;                   it, report back failure.

(defun atn-main (start &aux actions node temp)
  (progn
      (setq actions start)
      (catch 'exit
           (loop
		(if (eval debug) (break "atn-main"))
		(cond ((null actions)
                            (if (null *sentence*)
				(throw 'exit t)
                                (throw 'exit nil)))

		      ((listp (caar actions)) (setq actions (car actions)))

		      ((or
			(equal (caar actions) 'category)
			(equal (caar actions) 'word)
			(equal (caar actions) 'peek)
			(equal (caar actions) '==)
			(equal (caar actions) ':=)
			(equal (caar actions) 'insert)
			(equal (caar actions) 'debugon)    ;turn debug mode on
			(equal (caar actions) 'drop)
			(equal (caar actions) 'detach)
			(equal (caar actions) 'the)
			(equal (caar actions) 'the-first)
			(equal (caar actions) 'save-last)
			(equal (caar actions) 'semantics)
			(equal (caar actions) 'snapshot)   ;snap shot atn
			(equal (caar actions) 'use))
		       (if (eval (car actions))
			   (setq actions (cdr actions))
			   (throw 'exit nil)))

		      ((equal (caar actions) 'optional)
                        (if (null *sentence*)
			    (setq actions (cdr actions))
			    (progn
				(store_choicepoint
						*sentence*
						(cdr actions)
						*ParseTree*
						*stk*
						*token*)
				(setq actions (cons   (cadar actions)
						      (cdr actions))))))

		      ((equal (caar actions) 'optional*)
			(if (null *sentence*)
			    (setq actions (cdr actions))
                            (progn
				(store_choicepoint
					*sentence*
					(cdr actions)
					*ParseTree*
					*stk*
					*token*)
                                (setq actions
					(cons (cadar actions) actions)) )))

		      ((equal (caar actions) 'seq)
			(setq actions (append (cdar actions) (cdr actions))))

		      ((equal (caar actions) 'either)
			   (progn
				(dolist (acts (cddar actions) t)
				  (store_choicepoint
						*sentence*
						(cons acts (cdr actions))
						*ParseTree*
						*stk*
						*token*))
				(setq actions (cons (cadar actions)
						    (cdr actions)))))

		     ((equal (caar actions) 'parse)
			   (progn
				(setq node  (cadar actions)
				      $last (newsym node))
				(set (make$ node) $last)
				(pushtoken $last)
				(push *ParseTree*)
				(setq *ParseTree* nil)
				(setq actions (cons (list 'done
                                                          $last)
						    (cdr actions)))
				(setq actions (cons (eval node)
						    actions))))

		     ((equal (caar actions) 'done)
		      (progn	
			(setq temp    (cons (poptoken) *ParseTree*)
			      *ParseTree*     (pop)
			      *ParseTree*     (queue temp *ParseTree*)
			      actions (cdr actions))
			(dolist (x *sem-end* t) (funcall x))
			(setq *sem-end* nil)))

                     (t (throw 'exit t))
		
      		);end cond
		(if (eval debug) (break "atn-main endloop"))
	   );end      loop
	);end         catch
   );end              progn
);end                 defun atn-main


;;; define a semantics function --- what does a parsed word mean ?
;;; a function or action associated with the word to give it meaning.

(defmacro defsemantics (name code)
 `(setq ,name
	(list (list 'lambda nil ',code))))

;;; the intermediator between syntax and semantics functions
;;; "when" indicates when the semantic function associated with "where"
;;; should be evaluated.
;;; three possibles:
;;;   immediate, end (of the current constituent), and
;;;   wait (until a semantics immediate call on the current constituent)

(defmacro semantics (when where)
 `(cond ((equal ',when 'end) (setq *sem-end* (cons ',where *sem-end*))t)
        ((equal ',when 'immediate) (funcall ,where)
				   (dolist (x *sem-wait* t) (funcall x))
				   (setq *sem-wait* nil) t)
        ((equal ',when 'wait     ) (setq *sem-wait* (cons ',where *sem-wait*))t)
	(t nil)))

;;; add 1st argument to the sense associated with the constituent.
;;; if sense not there already create it.
;;; add-sense also adds connector to two or more

(defmacro add-sense (name code &aux temp)
 `(progn
   (setq temp (d-the sense of ,name))
   (break "name and temp")
   (cond ((null temp) (setq temp ',code))
	 (t (cond ((listp (car temp)) (setq temp (cons ',code temp)))
		   (t (setq temp (cons ',code (list temp)))))))
   (break "name and temp")
   (:= sense of ,name temp)
   t))

;  Copyright (C) Andrew H. Nelson 1989, 1990, 1991, 1992, 1993, 1994, 1995, 1996, 1997, 1998, 1999, 2000.  All rights reserved.
;  May not be copied, reproduced, or used in any manner without
;  1989, 1990, 1991the expressed written permission of the author.  Now released under GNU Public License.  See a copy of  the GPL in gpl.html with this release.

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;    develop the learning inference engine (learnfrom I F)     ;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;;;
;;; (rule name (if (a1) (a2) ... (aN)) (then (c1) (c2) ... (cN)))
;;;
;;; create all common rules

(defun rule-equal (x y) (match (cddr x) (cddr y)))

;;; do one pass on the rules finding and producing rule reductions

(defun generalize (&aux results buffer found)
  (setq buffer *rules* buffer1 *rules*)
  (dolist (x buffer t)
          (dolist (y buffer1 t)
                  (if (not (equal (cadr x) (cadr y)))
                      (if  (and  (not (null (abstract-rule x y)))
                                 (null found))
                           (setq found t)) )))
  found)

;;; do all rule reductions until there are no more capable of being
;;; reduced

(defun generalize-all ()
  (do () ((null (generalize)) t)))


;;; create a common rule from two rules if possible

(defun abstract-rule (rule1 rule2 &aux n a1 a2 a3 c1 c2 c3 rule)
  (setq a1  (cdaddr rule1)
        c1  (cdr (cadddr rule1))
        a2  (cdaddr rule2)
        c2  (cdr (cadddr rule2))
        a3  (stm_sort (bagpatterns a1 a2))
        c3  (stm_sort (bagpatterns c1 c2))
        n   (intern (symbol-name (gensym "A-RULE")))
        )


;;; did we find something?
  (if (or (null a3) (null c3))
      (setq rule nil)
      (setq rule (list 'rule n (cons 'if a3) (cons 'then c3))))

;;; check redundancy

  (setq a1 (squash a1) a2 (squash a2) a3 (squash (reverse a3))
        c1 (squash c1) c2 (squash c2) c3 (squash (reverse c3)) )

  (if (or (and (match a1 a3) (match c1 c3))
          (and (match a2 a3) (match c2 c3))
          (member rule *rules* :test #'rule-equal) )
      (setq rule nil))

;;; if something good remember it
  (if (not (null rule))
      (progn
        (pprint rule)
        (set n rule)
        (setq *database* (append (build-database (list rule))
                                                 *database*)
              ltm (reverse (cons n (reverse ltm)))
              *rules*    (cons rule *rules*)) ))
  rule)

;;; do the patterns match each other ?
(defun samepatternp (x y &aux results)
  (if (setq results (match x y))
      (or (equal results 't)
          (catch 'exit
                 (dolist (x results t)
                         (if (and (not (variablep  (cadr x)))
                                  (listp (cadr x))
                                  (not (lvariablep (caadr x))))
                             (throw 'exit nil)))))))

;;; collect the same patterns
(defun bagpatterns (x y &aux results)
 (dolist (p x results)
         (dolist (p1 y results)
                 (if (and (samepatternp p p1)
                          (not (member p1 results :test #'equal)))
                          (setq results (cons p1 results))))))

;;; bag all facts that have a given term
 (defun bagi (term Iset &optional bag)
   (dolist (i Iset bag)
           (if (and (member term i :test #'equal)
                    (not (member i bag :test #'equal)))
               (setq bag (cons i bag)))))

;;; bag all facts that relate to a certain fact
 (defun bagof (fact Iset &aux bag)
  (dolist (term fact bag)
          (setq bag (bagi term Iset bag))))

;;; some set functions  F not I and In
 (defun FnotI (F I)
  (cond ((null I) F)
        (t (FnotI (delete (car I) F :test #'equal) (cdr I)))))

 (defun In (term Iset)
  (cond ((null Iset) nil)
        ((atom (car Iset))
         (or (equal (car Iset) term)
             (In term (cdr Iset))))
        (t (or (In term (car Iset))
               (In term (cdr Iset))))))

;;; abstract creates a rule from a conclusion and Initial fact set
 (defun abstract (fact Iset &aux Ifs then rule var symbol_table)
  (setq ifs          (bagof fact Iset)
        then         fact
        rule         (intern (symbol-name (gensym "A-RULE")))
        symbol_table nil)
  (dolist (term fact t)
          (if (In term ifs)
              (progn
                (if (null (setq var (st-lookup term symbol_table)))
                    (setq symbol_table (upd-st term
                                               (gensym "$A-")
                                               symbol_table)
                          var   (st-lookup term symbol_table)))
                (setq ifs  (subst var term ifs  :test #'equal)
                      then (subst var term then :test #'equal))
              ); end progn
          );end if
  ); end dolist

  (set   rule
  (list 'rule rule (cons 'if (stm_sort ifs)) (list 'then then)))

  (setq ltm (reverse (cons rule (reverse ltm))))

  (setq *database* (append (build-database (list (eval rule)))
                                *database*))
  (eval rule)

  ); end defun abstract

;;; learnfrom takes and Initial set of facts (antecedents)
;;; and a Final set of facts (conclusions) and generates
;;; rules that map the Inital set to the Final set
;;; ************ MACHINE LEARNING *************
  (defun learnfrom (I F &aux rules thens)
    (setq thens (FnotI F I)
          rules nil
          rules (dolist  (conclusion thens rules)
                         (setq rules (cons (abstract conclusion I)
                                           rules))) ))

  (defun learn (I F)
    (setq *rules* (append (learnfrom I F) *rules*)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;; develop the forward-chaining inference engine (match p d e)  ;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

 ; datum   : hypotheses or facts
 ; pattern : goals and conditions (or rules)
 ;           '?' = wild card element in pattern
 ;           '*' = wild card elements in pattern
 ;

 ;update the symbol table
 (defun upd-st (symbol value table)
   (cons (list symbol value) table))

 ;look up symbol value in table
 (defun st-lookup (symbol table)
   (if (and (not (null table)) (not (equal table t))
            (assoc symbol table))
       (cadr (assoc symbol table))))

 ;is x a variable ?
 (defun variablep (x)
   (and (atom x) (not (numberp x)) (not (equal (type-of x) :string))
        (equal (car (explode x)) '$)))

 ;is x a variable holding a list $$varname
 (defun lvariablep (x &aux temp)
   (and (variablep x) (equal (cadr (explode x)) '$)))

 ;trim variable --- get rid of $ or $$
 (defun trim-variable-sign(x &aux temp)
   (setq temp (explode x))
   (implode (cond ((equal (cadr temp) '$) (cddr temp))
                  (t (cdr temp)))))

 ;is it a anything but this value symbol ?
 (defun negatep (x)
  (and (atom x)
       (equal (car (explode x)) '!)))

 ;it is a match in that it is anything but the value
 (defun nonmatchp (x y)
  (and (atom x) (atom y)
       (equal (car (explode x)) '!)
       (not (equal (implode (cdr (explode x))) y))))

 ;replace a variable with its value in a predicate term
 ;by substitution of its value from a symbol table

 (defun repl (s a)
   (repl-aux  s  a))

 (defun repl-aux (s a)
   (cond ((null s) nil)
         ((and (listp s)(lvariablep (car s)))
          (append (st-lookup (car s) a) (repl-aux (cdr s) a)) )
         ((variablep s) (st-lookup s a))
         ((atom s) s)
         (t (cons (repl-aux (car s) a) (repl-aux (cdr s) a)))))


 ;replace all eval's with its value in a pred term
 ;by substituing its value during an eval

 (defun reval (s)
  (cond ((null s) nil)
        ((atom s) s)
        ((equal (car s) 'eval) (eval (cadr s)))
        ((equal (car s) 'find) (find (cadr s)))
        (t (cons (reval (car s)) (reval (cdr s))))))

 ;match using following symbols in the pattern (p)
 ; $x = a variable,    !somevalue = not some value,
 ; $$x = a list variable. It is equivalent to this :
 ;  (a b $$x) will match (a b and now anything after it)
 ; ? = any one thing,  *  = any zero or more things.
 ;
 (defun match ( p d &optional st)
   (cond      ((and (null p) (null d))(if (null st) t st))

	      ((and (null d) (equal p '(*))) (if (null st) t st))

              ((or  (null p) (null d)) nil)   ;one shorter? no match

              ((or (numberp p) (numberp d)) (equal p d))

              ((or (atom p) (atom d))
               (or (equal p d)
                   (equal p t)
                   (and (atom p) (equal p '*))
                            (if (variablep p)
                                (match (st-lookup p st) d st))
                   (and (atom d) (atom p)
                        (or (equal p '?)
                            (nonmatchp p d)))
               ))

              ((or (listp (car p)) (listp (car d)))
               (and (match (car p) (car d) st)
                    (match (cdr p) (cdr d) st)))

             ;;; atoms and numbers taken care of above
             ;;; now concentrate on flat lists '(a b c) '(a b c)

              ((or (equal (car p) '?)         ;wild card ?
               (equal (car p) (car d)))       ;first elements same?
              (match (cdr p) (cdr d) st))

              ((equal (car p) '*)             ;pattern wild ?
               (or (match  (cdr p) (cdr d) st)   ;drop * (a b c) (a b c)
                   (match  p (cdr d) st)         ;keep * (a * c) (a b c)
                   (match  (cdr p) d st) ))      ;       (a * c) (a c)

              ;a list variable, pop-11 like in behavior
              ((lvariablep (car p))
               (if (null (st-lookup (car p) st))
                   (match (cdr p) nil (upd-st (car p) d st))
                   (match (append
                                 (st-lookup (car p) st)
                                 (cdr p))
                          d st)))

              ;an atomic variable
              ((variablep (car p))
               (if (null (st-lookup (car p) st))
                   (match (cdr p) (cdr d)
                          (upd-st (car p) (car d) st))
                   (match (cons (st-lookup (car p) st) (cdr p))
                          d
                          st)))

              ;pattern says !somevalue so data != somevalue
              ((and (negatep (car p))
                   (not (equal (implode (cdr (explode (car p))))
                                 (car d))))
               (match (cdr p) (cdr d) st))

 )) ;end the matcher

;;; behaves like the pop-11 matches in that it globally binds
;;; the resulting variables values and interns the variables

(defun matches (p d &aux x)
  (setq x (match p d))
  (cond ((null x)  nil)
        ((listp x) (dolist (y x t) (set (trim-variable-sign (car y))
                                        (cadr y))))
        (t x)))

;;; present returns true if a pattern is present in short term memory
;;; as a side effect it places the instantiation of the pattern into
;;; the global variable 'it'.  (pop-11 again)

(defun present (p)
 (catch 'yes (dolist (x *assertions* nil)
                     (if (match p x)
                         (progn   (setq it x)
                                  (throw 'yes t))))))

;;; allpresent (pop-11 again) returns true if a pattern is present in
;;; short term memory.  As a side effect, it assigns a list of all
;;; instantiations of the pattern to the global variable 'them'

(defun allpresent (p &aux temp)
  (setq temp them them nil)
  (dolist (x *assertions* t)
          (if (match p x) (setq them (cons x them)))) )

;;; forall (pop-11 again) returns true if the pattern is present for all
;;; facts in shortterm memory
;;; Universal Quantification

(defun forall (p)
  (catch 'exit
         (dolist (x *assertions* t)
                 (if (match p x) t (throw 'exit nil)))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;  Copyright (C) Andrew H. Nelson 1989, 1990, 1991, 1992, 1993, 1994, 1995, 1996, 1997, 1998, 1999, 2000.  All rights reserved.
;  May not be copied, reproduced, or used in any manner without
;  1989, 1990, 1991the expressed written permission of the author.  Now released under GNU Public License.  See a copy of  the GPL in gpl.html with this release.

;  A unification algorithm
;  input:   t1 and t2,  two terms to be unified.
;  output:  theta, the most general unifier of t1 and t2, or nil

;  algorithm:

;    Initialize theta to nil, the stack - the equation t1 = t2,
;    and failure to false.

;    while stack not empty and not failure do:

;       pop x = y from the stack
;        case
;            x is a var that does not occur in y:
;              substitute y for x in the stack and in theta
;              add x = y to theta

;            y is a variable that does not occur in x:
;              substitute x for y in the stack and in theta
;              add y = x to theta

;            x and y are identical constants or variables:
;              continue

;            x is f(x1, ... , xN) and y is f(y1, ... , yN)
;              for some functor f and n > 0:
;              push xi = yi, i = 1, ... , N on the stack

;            otherwise  failure = true

;       if failure, then output failure; else output theta

(defun MGU (t1 t2)  ;returns the Most General Unifier or nil
  (let* ((stack   (list (list t1 t2)))
         (x_and_y  nil)
         (theta    nil)
         (x        nil)
         (y        nil) )
        (do  ()
             ((null stack) theta)
             (progn
                (setq x_and_y  (car stack)
                      stack    (cdr stack)
                      x        (car x_and_y)
                      y        (cadr x_and_y))
                (cond
                      ((and (variablep x) (not (occurs x y)))
                       (setq stack (subst y x stack)
                             theta (subst y x theta)
                             theta (cons (list x y) theta)) )

                      ((and (variablep y) (not (occurs y x)))
                       (setq stack (subst x y stack)
                             theta (subst x y theta)
                             theta (cons (list y x) theta)) )

                      ((and (atom x) (atom y) (equal x y)) t)

                      ((and (listp x) (listp y)
                            (equal (length x) (length y)))
                       (do* ((xn x (cdr xn))
                             (yn y (cdr yn))
                             (xi (car xn) (car xn))
                             (yi (car yn) (car yn)))
                            ((null xn) t)
                            (setq stack (cons (list xi yi) stack))))

                       (t  (setq stack nil) (setq theta nil))

                )     ;end cond
              )  ;end progn and body of the do
        ))) ;end do let and defun

  (defun print-unification (x y)
    (dolist (z (MGU x y) t)
            (progn
              (princ (car z)) (princ " = ") (print (cadr z)))))

  (defun occurs (x y)
   (cond  ((null y) nil)
          ((atom y) (equal x y))
          (t (or (occurs x (car y)) (occurs x (cdr y))))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;  Copyright (C) Andrew H. Nelson 1989, 1990, 1991, 1992, 1993, 1994, 1995, 1996, 1997, 1998, 1999, 2000.  All rights reserved.
;  May not be copied, reproduced, or used in any manner without
;  1989, 1990, 1991the expressed written permission of the author.  Now released under GNU Public License.  See a copy of  the GPL in gpl.html with this release.

; An abstract interpreter for logic programs
;
; Input:     A logic program P
;            A goal          G

; Output:    G-theta, if this was the instance of G deduced from P
;            or
;            failure if failure has occured.

; Algorithm: Initialize the resolvent to be G, the input goal.

;         1  While resolvent is not empty do:
;                Choose a goal A from the resolvent and a
;                 renamed clause A' <- B1,B2, ... ,Bn, n>=0, from P
;                 such that A and A' unify with mgu theta
;                 or
;                Exit if no such goal and clause exist.
;                Remove A from and add B1,B2, ... ,Bn to the
;                 resolvent.
;                Apply theta to the resolvent and to G.

;          2  If the resolvent is empty output G,
;                else output failure.


(defun head (x) (car x))
(defun body (x) (cdr x))

 ;; now first - we want to see if we can catch a fact without
 ;; resorting to unification on rules (shudder)
 ;; StackFrame = (MGU ClauseBody Programptr)

(defun choose-goal (A P &optional line &aux clause)
(if (null line) (setq line 0))
  (cond ((null P) nil)
        (t  (setq clause (rename-variables (car P)))
            (cond ((equal A (head clause))
                   (list nil (body clause) line))
                  ((MGU  A (head clause))
                   (list (MGU A (head clause)) (body clause) line))
                  (t (choose-goal A (cdr P) (1+ line)))))))

 ;;; 1.  save current environment
 ;;; 2.  restore an environment and then poison a choice

  ;;; Make $Stack and $PgmPtr persistent after life of logic-engine
  ;;; application.

  (setq $Stack '((($Fail Fail) nil 0)) $PgmPtr 0)

(defun logic-engine(G P &optional Fail &aux Resolvant theta Success)

  ;;; if fail , didn't like previous answer so backtrack through
  ;;; memoized function   ((look it up!!))
  ;;; memoized because of $Stack and $PgmPtr

   (if Fail
      (setq  G         (caar   $Stack)
             Resolvant (cadar  $Stack)
             $PgmPtr    (caddar $Stack)
             $Stack     (cdr    $Stack))
      (setq Resolvant G $PgmPtr 0 Stack nil))

    (do      () ((null Resolvant) t)
             (if  (setq success
                        (choose-goal (car Resolvant)
                                     (nthcdr (if (> $PgmPtr 0) $PgmPtr 0) P)
                                     $PgmPtr))
                  (progn
                      ;;; save the current environment except
                      ;;; point $PgmPtr +1 to next line if it
                      ;;; has to BackTrack
                      ;;; $StackFrame = (G Resolvant $PgmPtr + 1)
                      ;;; Push the stackframe to $Stack.

                      (setq $Stack
                            (cons (list G
                                        Resolvant
                                        (1+ (caddr success)))
                                   $Stack))

                       ;;; we chose a goal successfully, so
                       ;;; next time we choose point to top
                       ;;; of program again.

                      (setq $PgmPtr   0
                            theta     (car success)
                            Resolvant (append  (cadr success) (cdr Resolvant)))

                      (dolist (x theta t)
                              (setq Resolvant
                                    (subst (cadr x) (car x)
                                           Resolvant)
                                    G
                                    (subst (cadr x) (car x)
                                    G))))

                  ;; well - that didn't work so backtrack
                  (if (not (null $Stack))
                        (setq  G          (caar $Stack)
                               Resolvant  (cadar $Stack)
                               $PgmPtr    (caddar $Stack)
                               $Stack     (cdr $Stack))

                  ;; exit if no such goal and clause exist
                  ;; and nothing to backtrack to
                  (setq Resolvant nil G nil))    ))

     G   ;return Goal or nil if unsuccessful

 ); end logic-engine

(defun rename-variables (clause &aux body)
   (setq body clause)
   (dolist (x (find-unique-variables clause) body)
           (setq body (rename-a-variable x body))))

(defun rename-a-variable (variable body)
  (let ((x  (gensym "$temp_")))
       (subst x variable body :test #'equal)))

(defun find-variables (clause &optional varlist)
  (cond  ((null clause) varlist)
         ((atom clause) (if (and (variablep clause)
                                 (not (occurs clause varlist)))
                            (cons clause varlist)))
          (t (append (find-variables (car clause) varlist)
                     (find-variables (cdr clause) varlist)))))

 (defun find-unique-variables (clause &aux unique-variables)
   (dolist (x (find-variables clause) unique-variables)
           (if (member x unique-variables :test #'equal)
               t
               (setq unique-variables (cons x unique-variables)))))

;;; Build "Find".
;;; Backward chain to find a fact using a pattern

  (defun Find (x &aux success)
   (setq success (car (logic-engine (list x) *database*)))
   (if (null success) nil (setq it success)))

;;; Find All facts that match the given pattern, store it in 'them'

  (defun FindAll(x &aux success store)
    (setq store nil success (car (logic-engine (list x) *database*)))
    (if (null success)
        nil
        (catch 'exit
               (loop
                    (setq store   (if (member success store :test #'equal)
                                      store
                                      (cons success store))
                          success (car (logic-engine (list x) *database* t)))
                    (if   (or (null success) (equal success '$fail))
                          (throw 'exit t))  )))
    (if (null store) nil (setq them store)))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;  Copyright (C) Andrew H. Nelson 1989, 1990, 1991, 1992, 1993, 1994, 1995, 1996, 1997, 1998, 1999, 2000.  All rights reserved.
;  May not be copied, reproduced, or used in any manner without
;  1989, 1990, 1991the expressed written permission of the author.  Now released under GNU Public License.  See a copy of  the GPL in gpl.html with this release.

 ;;; a schema is a template for knowledge representation using
 ;;; frames or slots that are named.  An instantiation of a
 ;;; schema consists of a template of frames or slots with
 ;;; vals stored in the frames or slots.  A schema inherits
 ;;; slots or frames from other schema.  An instance of a
 ;;; schema may inherit slots and slot vals from another
 ;;; instance of a schema.

 ;;; used the symbol property list to store the slot names
 ;;; the slot is_a will hold a list of all schema that
 ;;; this schema will inherit slots from

 (defmacro defschema (name super-schema &rest slots)
  `(progn
    (setq ,name :schema)
    (putprop ',name ',super-schema 'is_a)
    (dolist (x ',slots t)
            (if (listp x)
                (putprop ',name (cadr x) (car x))
                (putprop ',name nil x))))
  ) ;end defmacro

 ;;; get the slot val.  If slot val not present here, go up
 ;;; the inheritance chain.

 (defun get-slot-value(schema slot)
   (getslot schema slot))

 ;;; This get-slot-value uses inheritance by transitting the
 ;;; is_a node hierarchy in a breadthfirst manner.  It is a
 ;;; cyclic graph and can get in an infinite loop if
 ;;; a class is_a subclass which is a subclass of the
 ;;; original class.  To work properly it must 'poison' the nodes where it has
 ;;; already been and eliminate them as contenders to search.

 (defun get-svalue(schema slot)
    (let ((val (get schema slot))
          (next  (get schema 'is_a)))
         (if (null val)
             (catch 'exit
                    (progn
                    (dolist (x next nil)
                            (if (get x slot)
                                (throw 'exit (get x slot))))
                    (dolist (x next nil)
                             (if (get-svalue x slot)
                                (throw 'exit (get-svalue x slot))))))
             val)))

 ;;; now make it a directed arc (non - cyclical) in nature.
 ;;; Prune mixins already investigated.
 ;;; Also change strategy from breadfirst search to depth
 ;;; search.  Necessary.

 (defun GetSlot(schema slot &optional poisoned)
    (let ((val   (get schema slot))
          (next  (get schema 'is_a)))
         (if (null val)
             (catch 'exit
                    (progn

                    (dolist (x poisoned t)
                            (setq next
                                  (delete x next :test #'equal)))

                    (dolist (x next nil)
                             (if (GetSlot x slot next)
                                (throw 'exit (GetSlot x slot next))))))

             val)))

 (defun put-slot-value(schema slot val)
   (setf (get schema slot) val))

 ;;; a symbol property list is a list composed of pairs of
 ;;; lisp objects.  the first object is the slot-name, the second
 ;;; is the slot-value

 ;;; build the selector functions
     (defun 1stslot (x)
       (let ((slot (car x))
             (val (cadr x))
            )
            (cond (slot (list slot val))
                  (t nil))))

 ;;; now build a way to "instantiate" a schema
 ;;; make it represent a state using slots and vals
 ;;; as representing the state of a particular instance
 ;;; of a schema.   The instance will transition to
 ;;; other states by changing the vals of the instance's
 ;;; slots.

  ;;; you need persistent storage to track all objects in
  ;;; the world.

  (setq *objects* nil)

  (defun make-object (schema &rest slots-and-their-values)
     (let ((slots (get-all-slots schema))
           (OBJECT (gensym (string-append (symbol-name schema) "_")))
           (newslots slots-and-their-values))
          (progn
            (do*  ((x slots (cddr x))
                   (sx (car x) (car x))
                   (vx (cadr x) (cadr x)))
                   ((null x) t)
                   (putprop object vx sx))
            (do* ((x newslots (cdr x))
                   (sx (caar x) (caar x))
                   (vx (cadar x) (cadar x)))
                   ((null x) t)
                   (putprop object vx sx))
             (setq *objects* (cons object *objects*))
             (putprop object schema 'instance_of)
             (putprop object (list schema) 'is_a)
             object)))

 ;;; define relations between instantiated objects only
 ;;; relation is not reflexive, that is if A r B
 ;;; it is not always B r A

 (defun defrelation (object1 relation object2)
   (cond ((and (member object1 *objects* :test #'equal)
               (not (equal object1 object2))
               (member object2 *objects* :test #'equal))
          (putprop object1 object2 relation))
         (t '"error --- an object is not properly defined")))


 (defun get-all-slots (object)
        (append (symbol-plist object)
                (mapcan 'get-all-slots
                        (get object 'is_a))))

 ;;; now create the facts

 (defun facts<-slots (object)
     (let  ((slot-value-list (get-all-slots object)))
          (do* ((x slot-value-list (cddr x))
                (y (car x) (car x))
                (z (cadr x) (cadr x)))
               ((null x) 'done)
               (cond ((null z) t)
		     ((equal (car (explode y)) ':) t)	
                     ((listp z)
		      (if       (equal (car z) :phrase)
                                (remember (cons y (cons object (cdr z) )))
				(dolist (zz z t)
                                        (if (listp zz)
                                            (remember (cons y
                                                      (cons object zz)))
                                            (remember (list y object zz))))
                     ))
                     (t (remember (list y object z)))))))

 ;;; now do it automatically  knowing that *objects* has list of
 ;;; instantiated objects

 (defun compile-facts () (mapcar #'facts<-slots *objects*)
                         (flush '(* *no_value*)) )

 ;;; now create methods or functions that reside in the
 ;;; slot hierarchy

 (defmacro defmessage (name-schema arg-list body)
  `(defmethod ',name-schema ',arg-list ',body))

  (defun defmethod (name-schema arg-list  body)
    (let ((message (car name-schema))
          (schema  (cadr name-schema))
          (closure  (list (list 'lambda arg-list body))))
         (putprop schema closure message)))

 ;;; now create demons --- messages that are activated
 ;;; before or after a message is sent
 ;;; Defining a demon ---  1.  the message must already exits
 ;;;                       2.  It must 'attach' to an already
 ;;;                           existing message.
 ;;;                       3.  It shouldn't call itself
 ;;;                       4.  It should have same # of args.



 (defun defdemon (demon keyword message)
   (cond  ((equal keyword :before)
           (putprop message
                    (cons demon (get message 'before))
                    'before))
           ((equal keyword :after)
            (putprop message
                     (cons demon (get message 'after))
                    'after))
           (t (break " error in defdemon:
                       eval demon message keyword"))))

 ;;; now create a way to use them using 'send message'
 ;;;

 ;;; self is standard when you want to send a message that
 ;;; uses other messages from and object to itself
 ;;; i.e.,  (send-message self message arg1 arg2 ... argN)

 (setq self nil)

  (defun send-message (object message &rest args)
    (let ((msg (get-svalue (get object 'instance_of) message))
          (afters  (get message 'after))
          (before  (get message 'before))
          (temp self))
         (if (and msg (equal (caar msg) 'lambda))
             (if  (equal (length (cadar msg))
                         (length args))
                   (prog2
                     (progn
                        (setq self object)
                        (dolist (x (get message 'before) t)
                                (if (not (null x))
                                    (eval (append
                                            (list 'send-message
                                                  'object
                                                  x)
                                             args))))) ;end progn
                     (apply msg args)  ;return this  from send-msg
                     (progn
                        (dolist (x (get message 'after) t)
                                (if (not (null x))
                                    (eval (append
                                            (list 'send-message
                                                  'object
                                                  x)
                                             args))))
                     (setq self temp)) ;end progn
                     ) ;end prog2

                  (break "incorrect # of args specified for msg"))
             (break "not a method for this schema")
         )))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;  Copyright (C) Andrew H. Nelson 1989, 1990, 1991, 1992, 1993, 1994, 1995, 1996, 1997, 1998, 1999, 2000.  All rights reserved.
;  May not be copied, reproduced, or used in any manner without
;  1989, 1990, 1991the expressed written permission of the author.  Now released under GNU Public License.  See a copy of  the GPL in gpl.html with this release.

;  this uses the predicates to test the restrictions

(defun test (predicates argument)
  (cond ((null predicates) t)
        ((funcall (car predicates) argument)
         (test (cdr predicates) argument))
        (t nil)))


 ;this procedure adds a new assertion to the database

 (defun remember (new)
  (cond  ((member new *assertions* :test 'equal) nil)
         ((null new) nil)
         ((equal new t) nil)
         ((atom new) (stm_insert (list new))
                     (setq *database* (cons (list (list new))
                                            *database*))

                     (setq $FcAgenda (FcDemon (list new)
                                              *rules*
                                              $FcAgenda)) )
         (t
	     (stm_insert new)

          (setq $FcAgenda (FcDemon new *rules* $FcAgenda))

          (setq *database* (cons (list new) *database*))
             new)))

 ;this procedure finds all assertions that match a given pattern

 (defun recall (p) (recall1 p *assertions*))           ;assertions is free
 (defun recall1 (p a)
   (cond ((null a) nil)
         ((match p (car a) nil) 		     ;a match?
             (cons (car a) (recall1 p (cdr a))))     ;add it to list of founds
         (t (recall1 p (cdr a)))))                   ;if not, next assertion

 ;a problem solver is doing forward chaining if it starts with a collection
 ;of assertions and tries all available rules over and over, adding new
 ;assertions as it goes until no rules apply.

 ;implement this in streams of assertions

 (defun combine-streams (s1 s2) (append s1 s2))
 (defun add-to-stream (e s) (cons e s))
 (defun first-of-stream (s) (car s))
 (defun rest-of-stream (s) (cdr s))
 (defun empty-stream-p (s) (null s))
 (defun make-empty-stream () nil)

;given a pattern and an initial input association list for the matcher
;create another association list of matchings

;rete candidate  see rete-recall for full explanation ....

 (defun or* (x)
   (cond ((null x) nil)
         ((atom x) x)
         (t (or (car x) (or* (cdr x))))))

 (defun filter-assertions (p i)
    (do ((a *assertions* (cdr a))
         (s (make-empty-stream)))
        ((null a) s)
        (let ((n (if (or (equal (length (car a)) (length p))
                         (or* (mapcar #'lvariablep p))
                         (member '* p :test #'equal)
                         (member '+ p :test #'equal))
                     (match p (car a) i) )))
        (cond (n (setq s (add-to-stream n s)))))))


;combine the results of many applications of filter-assertions to
;create another stream of the results
;rete decision goes here !!!!!!!

;if the length of an assertion is greater then that of the condition
;clause (or p for pattern), detailed match evaluations can be stopped
;we are going to test it here

 (defun filter-a-stream (p a)
   (cond ((empty-stream-p a) (make-empty-stream))
;retecode -----------------------------------------
;30 may 88 - fixed error   should be if a > p
	 ((and
		(> (length a) (length p))
                (not (member '* p :test #'equal))
		(not (member '+ p :test #'equal)))
	  (make-empty-stream))
;retecode -----------------------------------------
         (t (combine-streams
               (filter-assertions p (first-of-stream a))
               (filter-a-stream p (rest-of-stream  a))))))

;create means of using filter-a-stream once for each antecedent (precedent)
;passing the output of one use to the input of the next

 (defun cascade-thru (p a)
   (cond ((null p) a)
         (t (filter-a-stream (car p)
                             (cascade-thru (cdr p) a)))))


; feed-to-actions feeds the a-list streams of filterd ifs to s-actions
; feed-to-actions also combines the resulting action streams into a single one

 (defun feed-to-actions (rule-name actions a)
   (cond ((empty-stream-p a) (make-empty-stream))
         (t (combine-streams (s-actions       rule-name
                                              actions
                                              (first-of-stream a))
                             (feed-to-actions rule-name
                                              actions
                                              (rest-of-stream a))))))

; s-actions replaces pattern variables in the action with values, tries
; to add the resulting assertion to the data, and contributes to new action
; streams

 (defun s-actions (rule-name actions a)
   (do ((actx actions (cdr actx))
        (as (make-empty-stream)))
       ((null actx) as)
       (let* ((acty (repl (car actx) a))
              (actz (reval acty))
              (act   actz))
         (cond ((remember act)
		(print `(rule ,rule-name says ,@act))
;		(princ "Because ")
;		(princ (getexpl rule-name))
		(terpri)
		(setq as (add-to-stream act as)))))))


;extract list of patterns from a rule  record rule if it was used

 (setq rules-used-list (make-empty-stream))

 (defun use-rule (rule)
   (let* ((rule-name (cadr rule))
          (ifs       (reverse (cdr (caddr rule))))
          (thens     (cdr     (cadddr rule)))
          (a (cascade-thru ifs (add-to-stream nil (make-empty-stream))))
          (a-stream (feed-to-actions rule-name thens a )))
   (cond ((not (empty-stream-p a-stream))
          (rules-used rule-name ifs thens a) t ))))

 (defun rules-used (rule-name ifs thens a)
  (cond ((empty-stream-p a) t)
        (t   (setq rules-used-list
                 (cons (list rule-name (reval (repl ifs (first-of-stream a)))
                                       (reval (repl thens (first-of-stream a))))
                       rules-used-list))
             (rules-used rule-name ifs thens (rest-of-stream a)))))

; used rule predicate "have you used rule ...?

(defun rule-used-p (rule) (cond ((assoc rule rules-used-list) t) (t nil)))

; "how did you deduce that ... ?
; prints the assertions that allowed the deduction of the argument
; if fact is number gets the fact that corresponds to place in stm sequence

(defun how (fact)
 (if (numberp fact) (setq fact (nthstm fact)))
 (how1 fact rules-used-list nil))

(defun how1 (fact possible success)
  (cond ((null possible) (cond  ( success       t)
                                ((recall fact) (print `(,@fact was given)) t)
                                (t (print `(,@fact is not established)) nil)))
        ((member fact (caddr (car possible )) :test 'equal)
               (print `(,@fact demonstrated by))
               (mapcar #'(lambda (a) (print a)) (cadr (car possible)))
               (how1 fact (cdr possible) t))
        (t     (how1 fact (cdr possible) success))))

; "why did you need that insertion ... ?
; why prints the assertions that depend on its fact
; if fact is number gets the fact that corresponds to place in stm sequence

(defun why (fact)
 (if (numberp fact) (setq fact (nthstm fact)))
 (why1 fact rules-used-list nil))

(defun why1 (fact possible success)
 (cond ((null possible) (cond (success t)
                              (t (print `(,@fact was not used)) nil)))
       ((member fact (cadr (car possible)) :test 'equal)
                (print `(,@fact is needed to show))
                (mapcar #'(lambda (a) (print a))
                                                 (caddr (car possible)))
                (why1 fact (cdr possible) t))
       (t       (why1 fact (cdr possible) success))))

;;;;;;;;;;;  short term memory sort functions  ;;;;;;;;;;;;;

(defun stm_pick (stm &optional choice)
  (cond ((null stm) choice)
        ((null choice) (stm_pick (cdr stm) (car stm)))
        (t (if (< (length (car stm)) (length choice))
               (stm_pick (cdr stm) (car stm))
               (stm_pick (cdr stm) choice)))))

(defun stm_del (x list)
  (cond ((null list) nil)
        ((equal x (car list)) (cdr list))
        (t (cons (car list) (stm_del x (cdr list))))))

;;;  Since the pattern matches against data only when their lengths
;;;  are the same, the assertions in stm are sorted in ascending order
;;;  of their length.  Then the assertions and condition clauses are
;;;  compared in that order.  When comparing a condition clause with
;;;  assertions of the stm, a detailed match evaluation can be skipped
;;;  for an assertion if the length of the assertion is less than
;;;  that of the condition clause (or pattern).
;;;  Also, it can be terminated if the length of an assertion is greater
;;;  than that of the condition clause.

(defun stm_sort (stm )
  (cond ((null stm) nil)
        (t (cons (stm_pick stm)
                 (stm_sort (stm_del
                        (stm_pick stm)
                        stm) )))))

(defun stm_insert(x)
 (setq *assertions* (stm_insert1 x *assertions*)))

(defun stm_insert1 (x l)
  (cond ((null l) (cons x nil))
	((<= (length x) (length (car l))) (cons x l))
	(t (cons (car l) (stm_insert1 x (cdr l))))))

(defun pstm ()
  (pstm1 *assertions* 1))

(defun pstm1 (l seq)
  (cond ((null l) (terpri) t)
	(t (progn
  (terpri) (princ seq) (princ " : ") (princ (car l)) )
	   (pstm1 (cdr l) (1+ seq)))))

(defun nthstm (n)

  (car (nthcdr (if (> (1- n) 0)(1- n) 0) *assertions*)))

(defmacro assert (&rest news)
  `(mapcar 'remember ',news))

(defmacro asserted (fact)
  `(if (member ',fact *assertions* :test 'equal) t))

(defun true* (x)
	(cond	((null x) t)
		((and (car x) (true* (cdr x))) t)
		(t nil)))

;;; behaves like pop-11 remove
(defun remove (fact)
 (deny-aux fact))

;;; behaves like bop-11 flush
;;; use side effect of present (assigns fact to global variable it)
(defun flush (fact)
  (do ((there (present fact) (present fact)))
      ((null there) t)
      (deny-aux it)))

(defun deny (&rest facts &aux sorted_facts)
  (if	(true* (mapcar 'numberp facts))
	(setq sorted_facts (sort facts #'>))
	(setq sorted_facts facts))
  (print sorted_facts)
  (mapcar 'deny-aux sorted_facts) t)

(defun deny-aux (fact)
 (let* ((f  (reval (if (numberp fact) (nthstm fact) fact)))
        (df (list f)))
       (setq *assertions* (delete  f *assertions* :test #'equal)
             *database*   (delete df *database*   :test #'equal))))

;;;;;  non-monotonic deny  nmdeny  ;;;;; when you deny a fact
;;;;;  take out all facts that depend on it too.

(defun nmdeny (fact)
  (nmdeny1 fact rules-used-list nil))

(defun nmdeny1 (fact possible success)
 (cond ((null possible) (cond (success  (deny fact) t)
                              (t        (deny fact) nil)))
       ((member (if (numberp fact) (nthstm fact) fact)
                (cadr (car possible)) :test 'equal)
        (mapcar #'nmdeny (caddr (car possible)))
        (nmdeny1 fact (cdr possible) t))
       (t       (nmdeny1 fact (cdr possible) success))))

(defun clearstm () (setq *assertions* nil ) t)


; *rules* ::= '(rule rule ...)
; rule    ::= '(rule <name> (if (a 1) .. (a N)) (then (p 1) (p N)))

;;----------------- needed intermediate functions --------------------

(defun get_rule_names (&aux namelist)
 (setq namelist nil)
 (dolist (x *rules* (reverse namelist))
	 (setq namelist (cons (cadr x) namelist))))

(defun replrule (newrule)
  (setq *rules* (rrule newrule *rules*)))

(defun rrule (x l &optional f)
  (cond ((null l)
	 (if  (not (null f)) nil (list x)))
	((equal (cadr x) (cadr (car l))) (cons x (rrule x (cdr l) t)))
	(t (cons (car l) (rrule x (cdr l) nil)))))

(defun delrule (oldrule)
  (setq *rules* (drule oldrule *rules*)))

(defun drule (x l)
  (cond ((null l) nil)
	((equal (cadr x) (cadr (car l))) (drule x (cdr l)))
	(t (cons (car l) (drule x (cdr l))))))

(defun drule-aux (rl) (dolist (x rl t) (delrule x)))

(defun getifs (l)
  (cond ((equal (car l) '->) nil)
	((null l) (break "syntax error"))
	(t (cons (car l) (getifs (cdr l))))))

(defun getthens (l)
  (cond ((equal (car l) '->) (cdr l))
	((null l) (break "syntax error"))
	(t (getthens (cdr l)))))

(defun initrules (l)
  (cond ((null l) t)
	(t (set (cadr (car l)) (car l)) (initrules (cdr l)))))

(defun getrule (name l)
  (cond ((null l) nil)
	((equal name (cadr (car l))) (car l))
	(t (getrule name (cdr l)))))

;;----------------- end needed intermediate functions --------------------

; (defrule name <antecedent 1> <a 2> ... <a n> -> <consequent 1> ... <c n>)

(defmacro defrule (name &rest body)
  `(let ((ifs   (cons 'if (getifs ',body)))
	 (thens (cons 'then (getthens ',body))))
        (setq ,name      (list 'rule ',name ifs thens)
	      *rules*    (reverse (cons ,name (reverse *rules*)))
              *database* (append (build-database (list ,name))
                                *database*)
	      ltm        (reverse (cons ',name (reverse ltm))))    ))

(defmacro prules (&rest r)
  `(dolist (x ',r t)
	   (progn
		(print x)
		(print (cadr (assoc x *ruletext*)))
		(pprint (getrule x *rules*)))))

(defun pltm ()
 (dolist (x *rules* t) (progn (pprint x) (terpri))))

(defun nthltm (n)
  (car (nthcdr (if (> (1- n) 0) (1- n) 0) *rules*)))

(defun clearltm () (setq *rules* nil ltm nil *ruletext* nil))

(defmacro deleterule (r)
 `(deleterule-aux ',r))

(defmacro deleterules (&rest r)
 `(mapcar 'deleterule-aux ',r))

(defun deleterule-aux (x)
    (progn	
     (delete-backchain-rule x)
     (setq *rules* (delete (getrule x *rules*) *rules* :test 'equal))
     (setq *ruletext* (delete (assoc x *ruletext*) *ruletext* :test 'equal))
     (setq ltm (delete x ltm :test 'equal))
     ))

(defun delete-backchain-rule (x &aux rules)
  (setq rules (forward->backward (eval x)))
  (dolist (y rules t)
          (setq *database* (delete y *database* :test #'equal))))

(defmacro putexpl (name explain)
  `(if  (member (list ',name ',explain) *ruletext* :test 'equal)
	t
	(setq *ruletext* (cons (list ',name ',explain) *ruletext*))))

(defmacro getexpl (name)
  `(cadr (assoc ',name *ruletext*)))

; forward-chain steps thru rule list until it finds a rule that produces a
; new assertion whereupon it starts over at beginning of rule list.
; fc stops when it fails to find a new assertion with any rule

 (defun forward-chain (&optional n)
   (do ((rules-to-try *rules* (cdr rules-to-try))
	(cycle n (if (not (null n)) (1- cycle)))
        (progress-made nil))
        ((or (null rules-to-try)
	     (and (not (null n)) (zerop cycle)))
	 progress-made)
        (cond ((use-rule (car rules-to-try))
              (setq rules-to-try *rules*)
              (setq progress-made t)))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;  Copyright (C) Andrew H. Nelson 1989, 1990, 1991, 1992, 1993, 1994, 1995, 1996, 1997, 1998, 1999, 2000.  All rights reserved.
;  May not be copied, reproduced, or used in any manner without
;  1989, 1990, 1991the expressed written permission of the author.  Now released under GNU Public License.  See a copy of  the GPL in gpl.html with this release.

;;; Implement Agenda based forward-chaining to see if its
;;; any faster....

;;; the agenda of rules to fire

   (setq $FcAgenda nil)

;;; the operations on the Forward chaining Agenda
;;; Initialize the agenda

   (defun Init-$FcAgenda (facts &optional agenda)
    (cond ((null facts) agenda)
          (t (Init-$FcAgenda (cdr facts)
                             (FcDemon (car facts)
                                      *rules*
                                      agenda)))))

;;; The Forward Chaining Demon is invoked to schedule
;;; a candidate rule to the FC Agenda each time a fact
;;; is created and will potentially match to a "candidate"
;;; rule.

   (defun FcDemon (fact Rules &optional agenda)
     (cond ((null Rules) agenda)
           ((and  (candidate-rule-p fact (f-getifs (car Rules)))
                  (not (member (car Rules) agenda :test #'equal)))
            (FcDemon fact (cdr Rules) (cons (car Rules) agenda)))
           (t (FcDemon fact (cdr Rules) agenda))))

;;; A candidate rule is a rule with one of its if conditions
;;; matching one of the facts in short term memory.

   (defun candidate-rule-p (fact ifs)
     (cond ((null ifs) nil)
           ((or (match (car ifs) fact)
                (candidate-rule-p fact (cdr ifs))) t)
            (t nil)))

;;; Now forward chain with an agenda

   (defun fc-with-agenda ()
     (if (null $FcAgenda)
         (setq $FcAgenda (init-$FcAgenda *assertions*)))
     (do ((progress-made nil))
         ((null $FcAgenda) progress-made)
         (cond ((use-rule (car $FcAgenda))
                (setq progress-made t))
               (t (setq $FcAgenda (cdr $FcAgenda))))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;  Copyright (C) Andrew H. Nelson 1989, 1990, 1991, 1992, 1993, 1994, 1995, 1996, 1997, 1998, 1999, 2000.  All rights reserved.
;  May not be copied, reproduced, or used in any manner without
;  1989, 1990, 1991the expressed written permission of the author.  Now released under GNU Public License.  See a copy of  the GPL in gpl.html with this release.

;;; define a known universe  -- this is a "real world"

 (defun defuniverse (viewpoint)
  (progn
   (setq   *context* (cons viewpoint *context*))
   (setf   (get viewpoint 'rules) *rules*)
   (setf   (get viewpoint 'database) *database*)
   (setf   (get viewpoint 'assertions) *assertions*)
   (setf   (get viewpoint 'rules-used-list) rules-used-list)
   (setf   (get viewpoint 'ruletext) *ruletext*)
   (setf   (get viewpoint 'ltm) ltm)
   (setf   (get viewpoint 'stm) stm)
   ))

;;; define a viewpoint  -- allow hypothetical situations
;;; without having to retract it all later
;;; "brainstorming"

 (defun defviewpoint (viewpoint)
  (progn
   ;;;    store viewpoint names for later recall  ;;;;
   (setq   *context* (cons viewpoint        *context*))
   (setf   (get viewpoint 'rules)           nil)
   (setf   (get viewpoint 'database)        nil)
   (setf   (get viewpoint 'assertions)      nil)
   (setf   (get viewpoint 'rules-used-list) nil)
   (setf   (get viewpoint 'ruletext)        nil)
   (setf   (get viewpoint 'ltm)             nil)
   (setf   (get viewpoint 'stm)             nil)
   ))

;;; invalidate a viewpoint - disallow it as possible
;;; erase it as invalid

 (defun invalidate-viewpoint (viewpoint)
   (defviewpoint viewpoint)
   (setq *context* (delete viewpoint *context* :test #'equal))
   )

;;; define a hypothetical rule for a viewpoint

  (defmacro defhypothesis (name viewpoint &rest body)
    `(let ((ifs (cons 'if (getifs ',body)))
           (thens (cons 'then (getthens ',body))))
          (progn
           (setf (get ,viewpoint 'rules)
                 (cons (list 'rule ',name ifs thens)
                       (get ,viewpoint 'rules)))
           (setf (get ,viewpoint 'database)
                 (append (build-database (list (list 'rule ',name ifs thens)))
                       (get ,viewpoint 'database)))
           (setf (get ,viewpoint 'ltm) (cons ',name (get ,viewpoint 'ltm)))
           )))

;;; display a hypothetical "world"

 (defun display-viewpoint (viewpoint)
  (progn
   (pprint (get viewpoint  'rules))
   (pprint (get viewpoint  'assertions))
   (pprint (get viewpoint  'database))
   (pprint (get viewpoint  'rules-used-list))
   (pprint (get viewpoint  'ruletext))
   (pprint (get viewpoint  'ltm))
   (pprint (get viewpoint  'stm))
   ))

;;; assert facts in a hypothetical world

  (defmacro hypothesize (viewpoint &rest facts)
   `(let ((tempa  (get ,viewpoint 'assertions))
          (tempdb (get ,viewpoint 'database))
          )
         (progn
           (dolist (x ',facts t)
                   (setf (get ,viewpoint 'database) (cons (list x) tempdb)))
           (remprop ,viewpoint 'assertions)
           (putprop ,viewpoint
                    (append tempa ',facts)
                    'assertions))))

;;; brainstorm by forward-chaining in the hypothetical world

  (defun whatif (viewpoint)
    (let ((temprules *rules*)
           (tempas    *assertions*)
           (tempdb    *database*)
           (temprt    *ruletext*)
           (trules-used rules-used-list)
          )
      (progn
         (setq *database*   (append *database* (get viewpoint 'database))
               *ruletext*   (append *ruletext* (get viewpoint 'ruletext))
               *rules*      (append *rules* (get viewpoint 'rules))
               *assertions* (append *assertions*
                                    (get viewpoint 'assertions))
               rules-used-list nil)
         (forward-chain)
         (break "examine consequences or (continue)")
         (if (y-or-n-p "believe it ?")
             t
             (setq *rules*          temprules
                   *assertions*     tempas
                   *database*       tempdb
                   *ruletext*       temprt
                   rules-used-list  trules-used
                                            )))))

;;; Consult a hypothetical world or viewpoint for a Multiple
;;  Knowledge System Paridigm. Expert shares real world knowledge.

  (defun ask-sharing (viewpoint pattern &aux result tempdb)
   (setq tempdb       *database*
         *database*   (append *database* (get viewpoint 'database))
         result       (find pattern)
         *database*   tempdb)
   result)    ;return result

;;; Consult a hypothetical world or viewpoint for a Multiple
;;  Knowledge System Paridigm. Expert only has its knowledge,
;;  none is shared with it.

  (defun ask-nosharing (viewpoint pattern &aux result tempdb)
   (setq tempdb       *database*
         *database*   (get viewpoint 'database)
         result       (find pattern)
         *database*   tempdb)
   result)    ;return result

;;; believe the viewpoint -- incorporate permanently into
;;; the world space

  (defun believe (viewpoint)
   (setq *database*      (append *database* (get viewpoint 'database))
         *ruletext*      (append *ruletext* (get viewpoint 'ruletext))
         *rules*         (append *rules* (get viewpoint 'rules))
         *assertions*    (append *assertions*
                                 (get viewpoint 'assertions))
         rules-used-list (append rules-used-list
                                 (get viewpoint 'rules-used-list))
         ltm             (append ltm (get viewpoint 'ltm))
         stm             (append stm (get viewpoint 'stm)) ))

;;; merge the second viewpoint into the first viewpoint

 (defun merge-viewpoints (viewpoint viewpoint1)
  (progn
   (putprop viewpoint
            (append (get viewpoint  'rules)
                    (get viewpoint1 'rules))
            'rules)
   (putprop viewpoint
            (append (get viewpoint  'assertions)
                    (get viewpoint1 'assertions))
            'assertions)
   (putprop viewpoint
            (append (get viewpoint  'database)
                    (get viewpoint1 'database))
            'assertions)
   (putprop viewpoint
            (append (get viewpoint  'rules-used-list)
                    (get viewpoint1 'rules-used-list))
            'rules-used-list)
   (putprop viewpoint
            (append (get viewpoint  'ruletext)
                    (get viewpoint1 'ruletext))
            'ruletext)
   (putprop viewpoint
            (append (get viewpoint  'ltm)
                    (get viewpoint1 'ltm))
            'ltm)
   (putprop viewpoint
            (append (get viewpoint  'stm)
                    (get viewpoint1 'stm))
            'stm)
   ))

;;; save and recall viewpoints from a file

  (defun save-viewpoint (x)
    (defuniverse 'temp)
    (erase-world)
    (believe x)
    (save-w x)
    (erase-world)
    (believe 'temp)
    (invalidate-viewpoint 'temp))

;;; recall viewpoints from a file

  (defun recall-viewpoint (x)
    (defuniverse 'temp)
    (erase-world)
    (init-w x)
    (defuniverse x)
    (erase-world)
    (believe 'temp)
    (invalidate-viewpoint 'temp))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;  Copyright (C) Andrew H. Nelson 1989, 1990, 1991, 1992, 1993, 1994, 1995, 1996, 1997, 1998, 1999, 2000.  All rights reserved.
;  May not be copied, reproduced, or used in any manner without
;  1989, 1990, 1991the expressed written permission of the author.  Now released under GNU Public License.  See a copy of  the GPL in gpl.html with this release.

;; forward-chain rule is of form:
;; (rule rulename
;;	 (if 	(a_1) (a_2) (a_3) ... (a_n))
;;	 (then	(c_1) (c_2) (c_3) ... (c_n)))
;;
;; backward-chain rule is of form:
;; ((c_1) (a_1) (a_2) ... (a_n))
;;
;; if more than one consequent in a forward-chain rule then
;; the conversion requires multiple backward-chain rules
;; with same antecedents
;; ((c_1) (a_1) (a_2) ... (a_n))
;;  .
;;  .
;;  .
;; ((c_n) (a_1) (a_2) ... (a_n))

 ;;create the logic program for the abstract interpreter
 ;;
   (defun forward->backward (x)
     (let  ((heads  (f-getthens x))
            (rules   nil)
            (body   (f-getifs x)))
           (dolist (head  heads  rules)
                   (setq rules (if (null rules)
                                   (list (cons head body))
                                   (append (list (cons head body))
                                           rules))))))

  (defun build-database (x &aux dbase)
   (dolist (forward-rule x dbase)
           (setq dbase (append  (forward->backward forward-rule)
                              dbase))))


;; convert a fchain rule to a bchain rule by reversing ifs and thens
;; and forward chaining "back" to a conclusion

  (defun fchain->bchain (x)
    (list 'rule
          (gensym (symbol-name (cadr x)))
          (cons 'if (f-getthens x))
          (cons 'then (f-getifs x))))

;; build some funcs to manipulate forward chain rule

;; f-getif returns list of antecedents from rule and not the 'if in front
 (defun f-getifs (rule)
  (cdr(car(cdr(cdr rule)))))

;; f-getthens returns list of consequents from rule and not the 'then in front
 (defun f-getthens (rule)
  (cdr(car(cdr(cdr(cdr rule))))))


 (defun bchain (x)
    (let ((trule *rules*)
          (ta    *assertions*)
          (tdb   *database*)
          (tr-u-l rules-used-list)
          (trt   *ruletext*)
          (tltm  ltm)
          (tstm  stm))
         (progn
           (erase-world)
           (setq *rules*       (mapcar 'fchain->bchain trule)
                 *assertions*  (list x))
           (forward-chain)
           (break "examine using (pstm) or (pltm) or (continue) ?")
           (setq *rules* trule
                 *database* tdb
                 rules-used-list tr-u-l
                 *ruletext* trt
                 ltm tltm
                 stm tstm
                 *assertions* ta))) '"End of Bchain")


 (defun abduce (x y)
    (let ((trule *rules*)
          (ta    *assertions*)
          (tdb   *database*)
          (tr-u-l rules-used-list)
          (trt   *ruletext*)
          (tltm  ltm)
          (tstm  stm))
         (progn
           (erase-world)
           (setq *rules* (mapcar 'fchain->bchain trule))
           (setq *assertions* (list x))
           (forward-chain)
           (allpresent y)
           (setq *rules* trule
                 *database* tdb
                 rules-used-list tr-u-l
                 *ruletext* trt
                 ltm tltm
                 stm tstm
                 *assertions* ta))) them)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;  Copyright (C) Andrew H. Nelson 1989, 1990, 1991, 1992, 1993, 1994, 1995, 1996, 1997, 1998, 1999, 2000.  All rights reserved.
;  May not be copied, reproduced, or used in any manner without
;  1989, 1990, 1991the expressed written permission of the author.  Now released under GNU Public License.  See a copy of  the GPL in gpl.html with this release.

(defun interpret (&aux goal fail x)
 (do ()
     ((not (progn (terpri)
                  (setq $Stack '((($Fail Fail) nil 0))
                        $PgmPtr 0
                        fail    nil
                        );end setq
                  (princ "Query? ")
                  (setq goal (read)))))

     (print-unification goal (car (logic-engine (list goal)
                                                *database*
                                                fail)))
   (catch 'exit
     (loop
        (terpri)
        (setq fail (y-or-n-p "More?  "))
        (if (null fail) (throw 'exit nil))
        (setq x (car (logic-engine (list goal)
                                   *database*
                                   fail)))
        (if (null x) (throw 'exit nil))
        (print-unification goal x)))

  ))

 (defun consult (filename)
   (let ((fp (open filename :input)))
        (progn (setq *database* (append *database* (read fp)))
               (close fp))))

 (defun prologlist (&optional predicate)
   (if (null predicate) (pprint *database*)
       (dolist (x *database* t)
               (if (and  (listp (car x))
                         (equal (caar x) predicate))
                   (pprint x)))))


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;  Copyright (C) Andrew H. Nelson 1989, 1990, 1991, 1992, 1993, 1994, 1995, 1996, 1997, 1998, 1999, 2000.  All rights reserved.
;  May not be copied, reproduced, or used in any manner without
;  1989, 1990, 1991the expressed written permission of the author.  Now released under GNU Public License.  See a copy of  the GPL in gpl.html with this release.

  ;;; now create some "standard" schema and messages

  (defschema schema ())

  ;;; let's see some internals of schema and messages

  (defmessage (:show-slots schema) ()
     (do*   ((slist  (symbol-plist self) (cddr slist))
             (sname  (car slist) (car slist))
             (sval   (cadr slist) (cadr slist)))
            ((null slist) t)
            (progn
              (princ sname) (princ " --- ") (pprint sval))
           ))

  (defmessage (:show-mixins schema) ()
     (get (get self 'instance_of) 'is_a))

  (defmessage (:get-slot-value schema) (slot)
     (get self slot))

  (defmessage (:put-slot-value schema) (slot value)
     (setf (get self slot) value ))

  (defmessage (:show-methods schema) ()
     (do*  ((slist (symbol-plist self) (cddr slist))
            (sname (car slist)     (car slist))
            (sval  (cadr slist)    (cadr slist)))
           ((null slist) t)
           (if (and sval (listp sval) (listp (car sval))
                    (equal (caar sval) 'lambda))
               (progn
                 (terpri) (princ sname) (princ "  ")
                 (pprint sval)))))

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

;  Copyright (C) Andrew H. Nelson 1989, 1990, 1991, 1992, 1993, 1994, 1995, 1996, 1997, 1998, 1999, 2000.  All rights reserved.
;  May not be copied, reproduced, or used in any manner without
;  1989, 1990, 1991the expressed written permission of the author.  Now released under GNU Public License.  See a copy of  the GPL in gpl.html with this release.

;;;  make a thinking object

 (defschema object (schema) 
    rules
    facts
    rules-used
    database)

 (defmessage (:before-infering object) ()
   (progn
       (setq *rules* (send-message self :get-slot-value 'rules))
       (setq *assertions* (send-message self :get-slot-value 'facts))
       (setq rules-used-list (send-message self :get-slot-value 'rules-used))
       (setq *database* (send-message self :get-slot-value 'database))
   ))
  (defmessage (:slots-facts object) () (facts<-slots self))
  (defdemon :slots-facts :after :before-infering)

  (defmessage (:after-infering object) ()
    (progn
      (send-message self :put-slot-value 'rules *rules*)
      (send-message self :put-slot-value 'facts *assertions*)
      (send-message self :put-slot-value 'rules-used rules-used-list)
      (send-message self :put-slot-value 'database *database*)
    ))

   (defmessage (:infer object)  () (forward-chain))

   (defdemon :before-infering :before :infer)
   (defdemon :after-infering  :after  :infer)

   (defmessage (:save object) ()  (save-world))

   (defdemon :before-infering :before :save)

   (defmessage (:teach object) (x) (eval x))
   (defdemon :before-infering :before :teach)
   (defdemon :after-infering :after :teach)

    (defmessage (:tell object) (x) (remember x))
    (defdemon :before-infering :before :tell)
    (defdemon :after-infering :after :tell)

    
    (defmessage (:recall object) () (init-world))
    (defdemon :after-infering :after :recall)

    (defmessage (:examine object) ()
      (progn
        (pstm)  (terpri) (princ "Strike a key to continue ...")
        (read-line) (terpri) (pltm)))
    (defdemon :before-infering :before :examine)

   (defmessage (:deny object) (x) (deny x))
   (defdemon :before-infering :before :deny)
   (defdemon :after-infering :after :deny)

   (defmessage (:listen object) () (read))

