/* conf 1.0 -- Breyten Ernsting -- bje@dds.nl -- 9 Nov 1998 */
/* distributed under the GPL */

#define	APPCONF_WIN32_NATIVE    (FALSE)

#include	"appconf.h"
#include	<fstream.h>

void usage(char *prog,int which)
{
   cout << "usage : " << endl;
   if(which==0)
      cout << "\t" << prog << " -r <file> <section> [<key> <default value>]" << endl;
   else
      cout << "\t" << prog << " -w <file> <section> <key> <value>" << endl;
}

int main(int argc, char *argv[])
{
   int readcfg=0;
   if(argc==1) {
     usage(argv[0],0);
     usage(argv[0],1);
     exit(1);
   }
   if(strcmp(argv[1],"-w")==0)
     readcfg=1;
   
   if((readcfg==1) && (argc < 6)) {
      usage(argv[0],1);
      exit(1);
   }
   
   if((readcfg==0) && ((argc == 5) || (argc==3))) {
      usage(argv[0],0);
      exit(1);
   }
   
   AppConfig	cnf(argv[2]);
   
   cnf.setCurrentPath(argv[3]);
   
   if(readcfg==0) {
      if(argc==6) {
         cout << cnf.readEntry(argv[4],argv[5]) << endl;
      } else { // argv == 2
         BaseConfig::Enumerator *pEnum = cnf.enumEntries();
         size_t nEntries = pEnum->Count();
         for(size_t n=0;n<nEntries;n++)
            cout << (*pEnum)[n] << " " << cnf.readEntry((*pEnum)[n],"") << endl; 
         delete pEnum;
      }
   } else {
      cnf.writeEntry(argv[4],argv[5]);
   }
   return 0;
}

