#include <other/string.h>
#include <other/config.h>
#include <proc/process.h>
#include <pwd.h>

void main(int argc, char **argv)
{
	char	*su = pathfname(argv[0]);
	struct	passwd *grp;
	struct	passwd *pwd = getpwuid(getuid());
	char	pwdname[32];
	CONFIG	*cfg = sys_config("sudo");
	char	*p, *q;

	if(argc < 2)
		fatal(EX_USAGE, "use: root cmd args...\n");

	if(!pwd)
		fatal(EX_OSERR, "root: user not found\n");

	strcpy(pwdname, pwd->pw_name);

	if(!strcmp(su, "sudo"))
	{
		--argc;
		++argv;
		su = pathfname(argv[0]);
		if(argc < 2)
			fatal(EX_USAGE, "use: sudo owner cmd args...\n");
	}
	grp = getpwnam(su);
	endpwent();

	if(!grp)
		fatal(EX_NOUSER, "root: %s: effective group not found\n", su);

	if(!cfg)
		fatal(EX_CONFIG, "root: config missing\n");

	if(!strcmp(su, pwdname))
	{
		close_config(cfg);
		setgid(getgid());
		setuid(getuid());
		++argv;
		execvp(*argv, argv);
		fatal(EX_UNAVAILABLE, "root: %s: unavailable\n", *argv);
	}

	seek_config(cfg, su);
	while(NULL != read_config(cfg))
	{
		if(NULL != (p = get_config(cfg, pwdname)))
		{
			q = strtok(p, ";: \t");
			while(q)
			{
				if(!strcmp(q, argv[1]))
				{
					close_config(cfg);
					setgid(grp->pw_gid);
					setuid(grp->pw_uid);
					++argv;	
					execvp(*argv, argv);
					fatal(EX_UNAVAILABLE, "root: %s: unavailable\n", *argv);
				}
				q = strtok(NULL, ";: \t");
			}
		}
	}

	close_config(cfg);
	fatal(EX_NOPERM, "root: permission denied\n");
}

