/*
 * Detach current process (connect to /dev/null) and execute.  This is
 * kinda a 'daemon' command, in that the command line arguments are
 *  executed once detach becomes a daemon.
 * 
 * $Id: detach.c 1.1 Wed, 04 Jun 1997 15:38:01 -0400 dyfet $
 * Copyright (c) 1997 by Tycho Softworks.
 * For conditions of distribution and reuse see product license.
 */

#include <proc/process.h>
#include <std/files.h>

void main(int argc, char **argv)
{
	if(argc < 2)
		fatal(EX_USAGE, "use: detach command...\n");

	++argv;
	pdetach(D_KEEPNONE);
	open("/dev/null", O_RDWR);
	dup(0);
	dup(0);
	execvp(*argv, argv);
}

