/*
 * Portable emulation of utmp access routines, such as for broken BSD.
 * $Id: utmp.c 1.1 Fri, 04 Apr 1997 09:29:03 -0500 dyfet $
 * Copyright (c) 1997 by Tycho Softworks.
 * For conditions of distribution and use see license.
 */

#include <std/utmp.h>
#include <std/files.h>

#ifdef	GETUTENT_F_MISSING

static	fd_t	ut = -1;
static	struct	utmp	utmp;

void	setutent(void)
{
	if(ut < 0)
		ut = open(_PATH_UTMP, O_RDONLY);
	if(ut < 0)
		return;

	lseek(ut, 0l, SEEK_SET);
}

void	endutent(void)
{
	if(ut > -1)
	{
		close(ut);
		ut = -1;
	}
}

struct	utmp	*getutent(void)
{
	if(ut < 0)
		setutent();

	if(ut < 0)
		return NULL;

	if(read(ut, &utmp, sizeof(utmp)) < sizeof(utmp))
		return NULL;

	return &utmp;
}

#endif
